/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.amqp.exception.AmqpErrorCondition;
import com.azure.core.amqp.exception.AmqpErrorContext;
import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.amqp.exception.AmqpResponseCode;
import com.azure.core.amqp.exception.SessionErrorContext;
import com.azure.core.amqp.implementation.ExceptionUtil;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.RequestResponseChannel;
import com.azure.core.amqp.implementation.RequestResponseUtils;
import com.azure.core.amqp.implementation.TokenManager;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusException;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementNode;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ManagementChannel
implements ServiceBusManagementNode {
    private final MessageSerializer messageSerializer;
    private final TokenManager tokenManager;
    private final Duration operationTimeout;
    private final Mono<RequestResponseChannel> createChannel;
    private final String fullyQualifiedNamespace;
    private final ClientLogger logger;
    private final String entityPath;
    private volatile boolean isDisposed;

    ManagementChannel(Mono<RequestResponseChannel> createChannel, String fullyQualifiedNamespace, String entityPath, TokenManager tokenManager, MessageSerializer messageSerializer, Duration operationTimeout) {
        this.createChannel = Objects.requireNonNull(createChannel, "'createChannel' cannot be null.");
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        HashMap<String, String> loggingContext = new HashMap<String, String>(1);
        loggingContext.put("entityPath", entityPath);
        this.logger = new ClientLogger(ManagementChannel.class, loggingContext);
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.tokenManager = Objects.requireNonNull(tokenManager, "'tokenManager' cannot be null.");
        this.operationTimeout = Objects.requireNonNull(operationTimeout, "'operationTimeout' cannot be null.");
    }

    @Override
    public Mono<Void> cancelScheduledMessages(Iterable<Long> sequenceNumbers, String associatedLinkName) {
        ArrayList numbers = new ArrayList();
        sequenceNumbers.forEach(s -> numbers.add(s));
        if (numbers.isEmpty()) {
            return Mono.empty();
        }
        return this.isAuthorized("com.microsoft:cancel-scheduled-message").then(this.createChannel.flatMap(channel -> {
            Message requestMessage = this.createManagementMessage("com.microsoft:cancel-scheduled-message", associatedLinkName);
            Long[] longs = numbers.toArray(new Long[0]);
            requestMessage.setBody((Section)new AmqpValue(Collections.singletonMap("sequence-numbers", longs)));
            return this.sendWithVerify((RequestResponseChannel)channel, requestMessage, null);
        })).then();
    }

    @Override
    public Mono<byte[]> getSessionState(String sessionId, String associatedLinkName) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'sessionId' cannot be null."));
        }
        if (sessionId.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be blank."));
        }
        return this.isAuthorized("com.microsoft:get-session-state").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:get-session-state", associatedLinkName);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("session-id", sessionId);
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        })).flatMap(response -> {
            Object value = ((AmqpValue)response.getBody()).getValue();
            if (!(value instanceof Map)) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)Exceptions.propagate((Throwable)new AmqpException(false, String.format("Body not expected when renewing session. Id: %s. Value: %s", sessionId, value), this.getErrorContext())));
            }
            Map map = (Map)value;
            Object sessionState = map.get("session-state");
            if (sessionState == null) {
                this.logger.atInfo().addKeyValue("sessionId", sessionId).log("Does not have a session state.");
                return Mono.empty();
            }
            byte[] state = ((Binary)sessionState).getArray();
            return Mono.just((Object)state);
        });
    }

    @Override
    public Mono<ServiceBusReceivedMessage> peek(long fromSequenceNumber, String sessionId, String associatedLinkName) {
        return this.peek(fromSequenceNumber, sessionId, associatedLinkName, 1).next();
    }

    @Override
    public Flux<ServiceBusReceivedMessage> peek(long fromSequenceNumber, String sessionId, String associatedLinkName, int maxMessages) {
        return this.isAuthorized("com.microsoft:peek-message").thenMany((Publisher)this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:peek-message", associatedLinkName);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("from-sequence-number", fromSequenceNumber);
            requestBody.put("message-count", maxMessages);
            if (!CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
                requestBody.put("session-id", sessionId);
            }
            message.setBody((Section)new AmqpValue(requestBody));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        }).flatMapMany(response -> {
            List messages = this.messageSerializer.deserializeList(response, ServiceBusReceivedMessage.class);
            return Flux.fromIterable((Iterable)messages);
        }));
    }

    @Override
    public Flux<ServiceBusReceivedMessage> receiveDeferredMessages(ServiceBusReceiveMode receiveMode, String sessionId, String associatedLinkName, Iterable<Long> sequenceNumbers) {
        if (sequenceNumbers == null) {
            return FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'sequenceNumbers' cannot be null"));
        }
        ArrayList numbers = new ArrayList();
        sequenceNumbers.forEach(s -> numbers.add(s));
        if (numbers.isEmpty()) {
            return Flux.empty();
        }
        return this.isAuthorized("com.microsoft:receive-by-sequence-number").thenMany((Publisher)this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:receive-by-sequence-number", associatedLinkName);
            HashMap<String, Object> requestBodyMap = new HashMap<String, Object>();
            requestBodyMap.put("sequence-numbers", numbers.toArray(new Long[0]));
            requestBodyMap.put("receiver-settle-mode", UnsignedInteger.valueOf((int)(receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE ? 0 : 1)));
            if (!CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
                requestBodyMap.put("session-id", sessionId);
            }
            message.setBody((Section)new AmqpValue(requestBodyMap));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        }).flatMapMany(amqpMessage -> {
            List messageList = this.messageSerializer.deserializeList(amqpMessage, ServiceBusReceivedMessage.class);
            return Flux.fromIterable((Iterable)messageList);
        }));
    }

    private Throwable mapError(Throwable throwable) {
        if (throwable instanceof AmqpException) {
            return new ServiceBusException(throwable, ServiceBusErrorSource.MANAGEMENT);
        }
        return throwable;
    }

    @Override
    public Mono<OffsetDateTime> renewMessageLock(String lockToken, String associatedLinkName) {
        return this.isAuthorized("com.microsoft:peek-message").then(this.createChannel.flatMap(channel -> {
            Message requestMessage = this.createManagementMessage("com.microsoft:renew-lock", associatedLinkName);
            HashMap<String, UUID[]> requestBody = new HashMap<String, UUID[]>();
            requestBody.put("lock-tokens", new UUID[]{UUID.fromString(lockToken)});
            requestMessage.setBody((Section)new AmqpValue(requestBody));
            return this.sendWithVerify((RequestResponseChannel)channel, requestMessage, null);
        }).map(responseMessage -> {
            List renewTimeList = this.messageSerializer.deserializeList(responseMessage, OffsetDateTime.class);
            if (CoreUtils.isNullOrEmpty((Collection)renewTimeList)) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new AmqpException(false, String.format("Service bus response empty. Could not renew message with lock token: '%s'.", lockToken), this.getErrorContext())));
            }
            return (OffsetDateTime)renewTimeList.get(0);
        }));
    }

    @Override
    public Mono<OffsetDateTime> renewSessionLock(String sessionId, String associatedLinkName) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'sessionId' cannot be null."));
        }
        if (sessionId.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be blank."));
        }
        return this.isAuthorized("com.microsoft:renew-session-lock").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:renew-session-lock", associatedLinkName);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("session-id", sessionId);
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        })).map(response -> {
            Object value = ((AmqpValue)response.getBody()).getValue();
            if (!(value instanceof Map)) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new AmqpException(false, String.format("Body not expected when renewing session. Id: %s. Value: %s", sessionId, value), this.getErrorContext())));
            }
            Map map = (Map)value;
            Object expirationValue = map.get("expiration");
            if (!(expirationValue instanceof Date)) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new AmqpException(false, String.format("Expiration is not of type Date when renewing session. Id: %s. Value: %s", sessionId, expirationValue), this.getErrorContext())));
            }
            return ((Date)expirationValue).toInstant().atOffset(ZoneOffset.UTC);
        });
    }

    @Override
    public Flux<Long> schedule(List<ServiceBusMessage> messages, OffsetDateTime scheduledEnqueueTime, int maxLinkSize, String associatedLinkName, ServiceBusTransactionContext transactionContext) {
        return this.isAuthorized("com.microsoft:schedule-message").thenMany((Publisher)this.createChannel.flatMap(channel -> {
            LinkedList messageList = new LinkedList();
            for (ServiceBusMessage message : messages) {
                String partitionKey;
                int encodedSize;
                message.setScheduledEnqueueTime(scheduledEnqueueTime);
                Message amqpMessage = this.messageSerializer.serialize((Object)message);
                int payloadSize = this.messageSerializer.getSize(amqpMessage);
                int allocationSize = Math.min(payloadSize + 512, maxLinkSize);
                byte[] bytes = new byte[allocationSize];
                try {
                    encodedSize = amqpMessage.encode(bytes, 0, allocationSize);
                }
                catch (BufferOverflowException exception) {
                    String errorMessage = String.format("Error sending. Size of the payload exceeded maximum message size: %s kb", maxLinkSize / 1024);
                    AmqpErrorContext errorContext = channel.getErrorContext();
                    return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)Exceptions.propagate((Throwable)new AmqpException(false, AmqpErrorCondition.LINK_PAYLOAD_SIZE_EXCEEDED, errorMessage, (Throwable)exception, errorContext)));
                }
                HashMap<String, Object> messageEntry = new HashMap<String, Object>();
                messageEntry.put("message", new Binary(bytes, 0, encodedSize));
                messageEntry.put("message-id", amqpMessage.getMessageId());
                String sessionId = amqpMessage.getGroupId();
                if (!CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
                    messageEntry.put("session-id", sessionId);
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)(partitionKey = message.getPartitionKey()))) {
                    messageEntry.put("partition-key", partitionKey);
                }
                messageList.add(messageEntry);
            }
            HashMap requestBodyMap = new HashMap();
            requestBodyMap.put("messages", messageList);
            Message requestMessage = this.createManagementMessage("com.microsoft:schedule-message", associatedLinkName);
            requestMessage.setBody((Section)new AmqpValue(requestBodyMap));
            TransactionalState transactionalState = null;
            if (transactionContext != null && transactionContext.getTransactionId() != null) {
                transactionalState = new TransactionalState();
                transactionalState.setTxnId(Binary.create((ByteBuffer)transactionContext.getTransactionId()));
            }
            return this.sendWithVerify((RequestResponseChannel)channel, requestMessage, (DeliveryState)transactionalState);
        }).flatMapMany(response -> {
            List sequenceNumbers = this.messageSerializer.deserializeList(response, Long.class);
            if (CoreUtils.isNullOrEmpty((Collection)sequenceNumbers)) {
                FluxUtil.fluxError((ClientLogger)this.logger, (RuntimeException)new AmqpException(false, String.format("Service Bus response was empty. Could not schedule message()s.", new Object[0]), this.getErrorContext()));
            }
            return Flux.fromIterable((Iterable)sequenceNumbers);
        }));
    }

    @Override
    public Mono<Void> setSessionState(String sessionId, byte[] state, String associatedLinkName) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'sessionId' cannot be null."));
        }
        if (sessionId.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be blank."));
        }
        return this.isAuthorized("com.microsoft:set-session-state").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:set-session-state", associatedLinkName);
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("session-id", sessionId);
            body.put("session-state", (String)(state == null ? null : new Binary(state)));
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null).then();
        }));
    }

    @Override
    public Mono<Void> updateDisposition(String lockToken, DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, String sessionId, String associatedLinkName, ServiceBusTransactionContext transactionContext) {
        UUID[] lockTokens = new UUID[]{UUID.fromString(lockToken)};
        return this.isAuthorized("com.microsoft:update-disposition").then(this.createChannel.flatMap(channel -> {
            this.logger.atVerbose().addKeyValue("lockTokens", Arrays.toString(lockTokens)).addKeyValue("dispositionStatus", (Object)dispositionStatus).addKeyValue("sessionId", sessionId).log("Update disposition of deliveries.");
            Message message = this.createManagementMessage("com.microsoft:update-disposition", associatedLinkName);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("lock-tokens", lockTokens);
            requestBody.put("disposition-status", dispositionStatus.getValue());
            if (deadLetterReason != null) {
                requestBody.put("deadletter-reason", deadLetterReason);
            }
            if (deadLetterErrorDescription != null) {
                requestBody.put("deadletter-description", deadLetterErrorDescription);
            }
            if (propertiesToModify != null && propertiesToModify.size() > 0) {
                requestBody.put("properties-to-modify", propertiesToModify);
            }
            if (!CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
                requestBody.put("session-id", sessionId);
            }
            message.setBody((Section)new AmqpValue(requestBody));
            TransactionalState transactionalState = null;
            if (transactionContext != null && transactionContext.getTransactionId() != null) {
                transactionalState = new TransactionalState();
                transactionalState.setTxnId(Binary.create((ByteBuffer)transactionContext.getTransactionId()));
            }
            return this.sendWithVerify((RequestResponseChannel)channel, message, (DeliveryState)transactionalState);
        })).then();
    }

    @Override
    public Mono<Void> createRule(String ruleName, CreateRuleOptions ruleOptions) {
        return this.isAuthorized("com.microsoft:add-rule").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:add-rule", null);
            HashMap<String, Object> body = new HashMap<String, Object>(2);
            body.put("rule-name", ruleName);
            body.put("rule-description", MessageUtils.encodeRuleOptionToMap(ruleName, ruleOptions));
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        })).then();
    }

    @Override
    public Mono<Void> deleteRule(String ruleName) {
        return this.isAuthorized("com.microsoft:remove-rule").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:remove-rule", null);
            HashMap<String, String> body = new HashMap<String, String>(1);
            body.put("rule-name", ruleName);
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        })).then();
    }

    @Override
    public Flux<RuleProperties> listRules() {
        return this.isAuthorized("com.microsoft:enumerate-rules").then(this.createChannel.flatMap(channel -> {
            Message message = this.createManagementMessage("com.microsoft:enumerate-rules", null);
            HashMap<String, Integer> body = new HashMap<String, Integer>(2);
            body.put("skip", 0);
            body.put("top", Integer.MAX_VALUE);
            message.setBody((Section)new AmqpValue(body));
            return this.sendWithVerify((RequestResponseChannel)channel, message, null);
        })).flatMapMany(response -> {
            List<Object> list;
            AmqpResponseCode statusCode = RequestResponseUtils.getStatusCode((Message)response);
            if (statusCode == AmqpResponseCode.OK) {
                list = this.getRuleProperties((AmqpValue)response.getBody());
            } else if (statusCode == AmqpResponseCode.NO_CONTENT) {
                list = Collections.emptyList();
            } else {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new AmqpException(true, "Get rules response error. Could not get rules.", this.getErrorContext())));
            }
            return Flux.fromIterable(list);
        });
    }

    @Override
    public void close() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.tokenManager.close();
    }

    private Mono<Message> sendWithVerify(RequestResponseChannel channel, Message message, DeliveryState deliveryState) {
        return channel.sendWithAck(message, deliveryState).handle((response, sink) -> {
            if (RequestResponseUtils.isSuccessful((Message)response)) {
                sink.next(response);
                return;
            }
            AmqpResponseCode statusCode = RequestResponseUtils.getStatusCode((Message)response);
            if (statusCode == AmqpResponseCode.NO_CONTENT) {
                sink.next(response);
                return;
            }
            String errorCondition = RequestResponseUtils.getErrorCondition((Message)response);
            if (statusCode == AmqpResponseCode.NOT_FOUND) {
                AmqpErrorCondition amqpErrorCondition = AmqpErrorCondition.fromString((String)errorCondition);
                if (amqpErrorCondition == AmqpErrorCondition.MESSAGE_NOT_FOUND) {
                    this.logger.info("There was no matching message found.");
                    sink.next(response);
                    return;
                }
                if (amqpErrorCondition == AmqpErrorCondition.SESSION_NOT_FOUND) {
                    this.logger.info("There was no matching session found.");
                    sink.next(response);
                    return;
                }
            }
            String statusDescription = RequestResponseUtils.getStatusDescription((Message)response);
            Exception throwable = ExceptionUtil.toException((String)errorCondition, (String)statusDescription, (AmqpErrorContext)channel.getErrorContext());
            this.logger.atWarning().addKeyValue("status", (Object)statusCode).addKeyValue("description", statusDescription).addKeyValue("condition", errorCondition).log("Operation not successful.");
            sink.error((Throwable)throwable);
        }).switchIfEmpty(Mono.error((Throwable)new AmqpException(true, "No response received from management channel.", channel.getErrorContext()))).onErrorMap(this::mapError);
    }

    private Mono<Void> isAuthorized(String operation) {
        return this.tokenManager.getAuthorizationResults().onErrorMap(this::mapError).next().handle((response, sink) -> {
            if (response != AmqpResponseCode.ACCEPTED && response != AmqpResponseCode.OK) {
                String message = String.format("User does not have authorization to perform operation [%s] on entity [%s]. Response: [%s]", operation, this.entityPath, response);
                AmqpException exc = new AmqpException(false, AmqpErrorCondition.UNAUTHORIZED_ACCESS, message, this.getErrorContext());
                sink.error((Throwable)((Object)new ServiceBusException((Throwable)exc, ServiceBusErrorSource.MANAGEMENT)));
            } else {
                sink.complete();
            }
        });
    }

    private Message createManagementMessage(String operation, String associatedLinkName) {
        Duration serverTimeout = MessageUtils.adjustServerTimeout(this.operationTimeout);
        HashMap<String, Object> applicationProperties = new HashMap<String, Object>();
        applicationProperties.put("operation", operation);
        applicationProperties.put("com.microsoft:server-timeout", serverTimeout.toMillis());
        if (!CoreUtils.isNullOrEmpty((CharSequence)associatedLinkName)) {
            applicationProperties.put("associated-link-name", associatedLinkName);
        }
        Message message = Proton.message();
        message.setApplicationProperties(new ApplicationProperties(applicationProperties));
        return message;
    }

    private AmqpErrorContext getErrorContext() {
        return new SessionErrorContext(this.fullyQualifiedNamespace, this.entityPath);
    }

    private List<RuleProperties> getRuleProperties(AmqpValue messageBody) {
        if (messageBody == null) {
            return Collections.emptyList();
        }
        List rules = (List)((Map)messageBody.getValue()).get("rules");
        if (rules == null) {
            return Collections.emptyList();
        }
        ArrayList<RuleProperties> ruleProperties = new ArrayList<RuleProperties>();
        for (Map rule : rules) {
            DescribedType ruleDescription = (DescribedType)rule.get("rule-description");
            ruleProperties.add(MessageUtils.decodeRuleDescribedType(ruleDescription));
        }
        return ruleProperties;
    }
}

