/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class SubscriptionsImpl {
    private final SubscriptionsService service;
    private final ServiceBusManagementClientImpl client;

    SubscriptionsImpl(ServiceBusManagementClientImpl client) {
        this.service = (SubscriptionsService)RestProxy.create(SubscriptionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(String topicName, String subscriptionName, Boolean enrich) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), topicName, subscriptionName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(String topicName, String subscriptionName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.get(this.client.getEndpoint(), topicName, subscriptionName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getAsync(String topicName, String subscriptionName, Boolean enrich) {
        return this.getWithResponseAsync(topicName, subscriptionName, enrich).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getAsync(String topicName, String subscriptionName, Boolean enrich, Context context) {
        return this.getWithResponseAsync(topicName, subscriptionName, enrich, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> getWithResponse(String topicName, String subscriptionName, Boolean enrich, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.getSync(this.client.getEndpoint(), topicName, subscriptionName, enrich, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object get(String topicName, String subscriptionName, Boolean enrich) {
        return this.getWithResponse(topicName, subscriptionName, enrich, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> putWithResponseAsync(String topicName, String subscriptionName, Object requestBody, String ifMatch) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.put(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> putWithResponseAsync(String topicName, String subscriptionName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.put(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> putAsync(String topicName, String subscriptionName, Object requestBody, String ifMatch) {
        return this.putWithResponseAsync(topicName, subscriptionName, requestBody, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> putAsync(String topicName, String subscriptionName, Object requestBody, String ifMatch, Context context) {
        return this.putWithResponseAsync(topicName, subscriptionName, requestBody, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> putWithResponse(String topicName, String subscriptionName, Object requestBody, String ifMatch, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.putSync(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), ifMatch, requestBody, "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object put(String topicName, String subscriptionName, Object requestBody, String ifMatch) {
        return this.putWithResponse(topicName, subscriptionName, requestBody, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> deleteWithResponseAsync(String topicName, String subscriptionName) {
        String accept = "application/xml, application/atom+xml";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), "application/xml, application/atom+xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> deleteWithResponseAsync(String topicName, String subscriptionName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.delete(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> deleteAsync(String topicName, String subscriptionName) {
        return this.deleteWithResponseAsync(topicName, subscriptionName).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> deleteAsync(String topicName, String subscriptionName, Context context) {
        return this.deleteWithResponseAsync(topicName, subscriptionName, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> deleteWithResponse(String topicName, String subscriptionName, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.deleteSync(this.client.getEndpoint(), topicName, subscriptionName, this.client.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object delete(String topicName, String subscriptionName) {
        return this.deleteWithResponse(topicName, subscriptionName, Context.NONE).getValue();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    public static interface SubscriptionsService {
        @Get(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="enrich") Boolean var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> getSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="enrich") Boolean var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Put(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> put(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @BodyParam(value="application/atom+xml") Object var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> putSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @BodyParam(value="application/atom+xml") Object var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Delete(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/{topicName}/subscriptions/{subscriptionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> deleteSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

