/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracingLink;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.instrumentation.ContextAccessor;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ServiceBusTracer {
    private static final AutoCloseable NOOP_CLOSEABLE = () -> {};
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusTracer.class);
    private static final String TRACEPARENT_KEY = "traceparent";
    private static final String MESSAGING_SYSTEM_ATTRIBUTE_NAME = "messaging.system";
    public static final String MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME = "messaging.servicebus.message.enqueued_time";
    public static final String MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME = "messaging.batch.message_count";
    private static final String MESSAGING_OPERATION_ATTRIBUTE_NAME = "messaging.operation";
    private static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    private final Tracer tracer;
    private final String fullyQualifiedName;
    private final String entityPath;

    public ServiceBusTracer(Tracer tracer, String fullyQualifiedName, String entityPath) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null");
    }

    public boolean isEnabled() {
        return this.tracer != null && this.tracer.isEnabled();
    }

    public AutoCloseable makeSpanCurrent(Context span) {
        return this.isEnabled() ? this.tracer.makeSpanCurrent(span) : NOOP_CLOSEABLE;
    }

    public <T> Mono<T> traceMono(String spanName, Mono<T> publisher) {
        return this.traceMono(spanName, publisher, Context.NONE);
    }

    public <T> Mono<T> traceRenewMessageLock(Mono<T> publisher, ServiceBusReceivedMessage message) {
        if (this.isEnabled()) {
            return Mono.defer(() -> {
                Context span = this.startSpanWithLink("ServiceBus.renewMessageLock", null, message, Context.NONE);
                return publisher.doOnEach(signal -> {
                    if (signal.isOnComplete() || signal.isOnError()) {
                        this.endSpan(signal.getThrowable(), span, null);
                    }
                }).doOnCancel(() -> this.cancelSpan(span));
            });
        }
        return publisher;
    }

    public <T> Mono<T> traceScheduleMono(String spanName, Mono<T> publisher, ServiceBusMessage message, Context messageContext) {
        return this.traceMonoWithLink(spanName, OperationName.PUBLISH, publisher, message, messageContext);
    }

    public <T> Flux<T> traceScheduleFlux(String spanName, Flux<T> publisher, List<ServiceBusMessage> batch) {
        if (this.isEnabled()) {
            return Flux.defer(() -> {
                Context span = this.startSpanWithLinks(spanName, OperationName.PUBLISH, batch, Context.NONE);
                return publisher.doOnEach(signal -> {
                    if (signal.isOnComplete() || signal.isOnError()) {
                        this.endSpan(signal.getThrowable(), span, null);
                    }
                }).doOnCancel(() -> this.cancelSpan(span));
            });
        }
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSpan(Throwable throwable, Context span, AutoCloseable scope) {
        if (this.isEnabled()) {
            String errorCondition = null;
            if (throwable instanceof AmqpException) {
                AmqpException exception = (AmqpException)throwable;
                errorCondition = exception.getErrorCondition().getErrorCondition();
            }
            try {
                if (scope != null) {
                    scope.close();
                }
            }
            catch (Exception e) {
                LOGGER.warning("Can't close scope", new Object[]{e});
            }
            finally {
                this.tracer.end(errorCondition, throwable, span);
            }
        }
    }

    public void reportMessageSpan(ServiceBusMessage serviceBusMessage) {
        if (!this.isEnabled()) {
            return;
        }
        Context messageContext = ContextAccessor.getContext(serviceBusMessage);
        if (messageContext == null || messageContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        Map<String, Object> applicationProperties = serviceBusMessage.getApplicationProperties();
        String traceparent = ServiceBusTracer.getTraceparent(applicationProperties);
        if (traceparent != null) {
            return;
        }
        StartSpanOptions startOptions = this.createStartOption(SpanKind.PRODUCER, null);
        Context eventSpanContext = this.tracer.start("ServiceBus.message", startOptions, messageContext);
        this.tracer.injectContext((key, value) -> {
            applicationProperties.put((String)key, value);
            if (TRACEPARENT_KEY.equals(key)) {
                applicationProperties.put("Diagnostic-Id", value);
            }
        }, eventSpanContext);
        this.tracer.end(null, null, eventSpanContext);
        Optional spanContext = eventSpanContext.getData((Object)"span-context");
        if (spanContext.isPresent()) {
            serviceBusMessage.addContext("span-context", spanContext.get());
        }
    }

    public Mono<ServiceBusReceivedMessage> traceManagementReceive(String spanName, Mono<ServiceBusReceivedMessage> publisher) {
        if (this.isEnabled()) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, OperationName.RECEIVE);
            return publisher.doOnEach(signal -> {
                ServiceBusReceivedMessage message;
                if (signal.hasValue() && (message = (ServiceBusReceivedMessage)signal.get()) != null) {
                    Context messageContext = ContextAccessor.getContext(message);
                    startOptions.addLink(this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), messageContext));
                }
                if (signal.isOnComplete() || signal.isOnError()) {
                    Context span = this.tracer.start(spanName, startOptions, Context.NONE);
                    this.tracer.end(null, signal.getThrowable(), span);
                }
            }).doOnCancel(() -> this.cancelSpan(this.tracer.start(spanName, startOptions, Context.NONE))).doOnSubscribe(s -> startOptions.setStartTimestamp(Instant.now()));
        }
        return publisher;
    }

    public Flux<ServiceBusReceivedMessage> traceSyncReceive(String spanName, Flux<ServiceBusReceivedMessage> messages) {
        if (this.isEnabled()) {
            return Flux.defer(() -> {
                StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, OperationName.RECEIVE).setStartTimestamp(Instant.now());
                return messages.doOnEach(signal -> {
                    if (signal.hasValue()) {
                        ServiceBusReceivedMessage message = (ServiceBusReceivedMessage)signal.get();
                        if (message != null) {
                            TracingLink link = this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), Context.NONE);
                            startOptions.addLink(link);
                            ContextAccessor.setContext(message, link.getContext());
                        }
                    } else if (signal.isOnComplete() || signal.isOnError()) {
                        int batchSize = startOptions.getLinks() == null ? 0 : startOptions.getLinks().size();
                        startOptions.setAttribute(MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME, (Object)batchSize);
                        Context span = this.tracer.start(spanName, startOptions, Context.NONE);
                        this.tracer.end(null, signal.getThrowable(), span);
                    }
                }).doOnCancel(() -> this.cancelSpan(this.tracer.start(spanName, startOptions, Context.NONE)));
            });
        }
        return messages;
    }

    Context startSpanWithLinks(String spanName, OperationName operationName, List<ServiceBusMessage> batch, Context parent) {
        if (this.isEnabled() && batch != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, operationName);
            startOptions.setAttribute(MESSAGE_BATCH_SIZE_ATTRIBUTE_NAME, (Object)batch.size());
            for (ServiceBusMessage message : batch) {
                Context messageContext = ContextAccessor.getContext(message);
                startOptions.addLink(this.createLink(message.getApplicationProperties(), null, messageContext));
            }
            return this.tracer.start(spanName, startOptions, parent);
        }
        return parent;
    }

    Context startSpanWithLink(String spanName, OperationName operationName, ServiceBusReceivedMessage message, Context parent) {
        if (this.isEnabled()) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CLIENT, operationName);
            if (message != null) {
                Context messageContext = ContextAccessor.getContext(message);
                startOptions.addLink(this.createLink(message.getApplicationProperties(), message.getEnqueuedTime(), messageContext));
            } else {
                startOptions.addLink(this.createLink(null, null, parent));
            }
            return this.tracer.start(spanName, startOptions, parent);
        }
        return parent;
    }

    Context startProcessSpan(String spanName, ServiceBusReceivedMessage message, Context parent) {
        if (this.isEnabled() && message != null) {
            StartSpanOptions startOptions = this.createStartOption(SpanKind.CONSUMER, OperationName.PROCESS).setRemoteParent(this.extractContext(message.getApplicationProperties()));
            if (message.getEnqueuedTime() != null) {
                startOptions.setAttribute(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, (Object)message.getEnqueuedTime().toEpochSecond());
            }
            Context span = this.tracer.start(spanName, startOptions, parent);
            ContextAccessor.setContext(message, span);
            return span;
        }
        return parent;
    }

    private TracingLink createLink(Map<String, Object> applicationProperties, OffsetDateTime enqueuedTime, Context eventContext) {
        Context link = eventContext.getData((Object)"span-context").isPresent() ? eventContext : this.extractContext(applicationProperties);
        Map<String, Long> linkAttributes = null;
        if (enqueuedTime != null) {
            linkAttributes = Collections.singletonMap(MESSAGE_ENQUEUED_TIME_ATTRIBUTE_NAME, enqueuedTime.toEpochSecond());
        }
        return new TracingLink(link, linkAttributes);
    }

    private Context extractContext(Map<String, Object> applicationProperties) {
        if (applicationProperties == null) {
            return Context.NONE;
        }
        return this.tracer.extractContext(key -> {
            if (TRACEPARENT_KEY.equals(key)) {
                return ServiceBusTracer.getTraceparent(applicationProperties);
            }
            Object value = applicationProperties.get(key);
            if (value != null) {
                return value.toString();
            }
            return null;
        });
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get("Diagnostic-Id");
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get(TRACEPARENT_KEY);
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    private StartSpanOptions createStartOption(SpanKind kind, OperationName operationName) {
        StartSpanOptions startOptions = new StartSpanOptions(kind).setAttribute(MESSAGING_SYSTEM_ATTRIBUTE_NAME, (Object)"servicebus").setAttribute("entity-path", (Object)this.entityPath).setAttribute("hostname", (Object)this.fullyQualifiedName);
        if (operationName != null) {
            startOptions.setAttribute(MESSAGING_OPERATION_ATTRIBUTE_NAME, (Object)operationName.toString());
        }
        return startOptions;
    }

    private <T> Mono<T> traceMonoWithLink(String spanName, OperationName operationName, Mono<T> publisher, ServiceBusMessage message, Context messageContext) {
        if (this.isEnabled()) {
            return Mono.defer(() -> {
                StartSpanOptions startSpanOptions = this.createStartOption(SpanKind.CLIENT, operationName);
                if (message != null) {
                    this.reportMessageSpan(message);
                    startSpanOptions.addLink(this.createLink(message.getApplicationProperties(), null, messageContext));
                }
                Context span = this.tracer.start(spanName, startSpanOptions, Context.NONE);
                return publisher.doOnEach(signal -> {
                    if (signal.isOnComplete() || signal.isOnError()) {
                        this.endSpan(signal.getThrowable(), span, null);
                    }
                }).doOnCancel(() -> this.cancelSpan(span));
            });
        }
        return publisher;
    }

    private <T> Mono<T> traceMono(String spanName, Mono<T> publisher, Context parent) {
        if (this.isEnabled()) {
            return Mono.defer(() -> {
                Context span = this.tracer.start(spanName, this.createStartOption(SpanKind.CLIENT, null), parent);
                return publisher.doOnEach(signal -> {
                    if (signal.isOnComplete() || signal.isOnError()) {
                        this.endSpan(signal.getThrowable(), span, null);
                    }
                }).doOnCancel(() -> this.cancelSpan(span));
            });
        }
        return publisher;
    }

    void cancelSpan(Context span) {
        this.tracer.end("cancelled", null, span);
    }

    public static enum OperationName {
        PUBLISH("publish"),
        RECEIVE("receive"),
        SETTLE("settle"),
        PROCESS("process");

        private final String operationName;

        private OperationName(String operationName) {
            this.operationName = operationName;
        }

        public String toString() {
            return this.operationName;
        }
    }
}

