/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation.instrumentation;

import com.azure.core.util.Context;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.tracing.Tracer;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.instrumentation.ReceiverKind;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusMeter;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.time.Instant;
import reactor.core.publisher.Mono;

public final class ServiceBusReceiverInstrumentation {
    private final ServiceBusMeter meter;
    private final ServiceBusTracer tracer;
    private final ReceiverKind receiverKind;

    public ServiceBusReceiverInstrumentation(Tracer tracer, Meter meter, String fullyQualifiedName, String entityPath, String subscriptionName, ReceiverKind receiverKind) {
        this.tracer = new ServiceBusTracer(tracer, fullyQualifiedName, entityPath);
        this.meter = new ServiceBusMeter(meter, fullyQualifiedName, entityPath, subscriptionName);
        this.receiverKind = receiverKind;
    }

    public AutoCloseable startTrackingSettlementSequenceNumber() {
        return this.meter.isSettlementEnabled() ? this.meter.trackSettlementSequenceNumber() : null;
    }

    public boolean isProcessorInstrumentation() {
        return this.receiverKind == ReceiverKind.PROCESSOR;
    }

    public Context instrumentProcess(String name, ServiceBusReceivedMessage message, Context parent) {
        if (message == null || !this.tracer.isEnabled() && !this.meter.isConsumerLagEnabled()) {
            return parent;
        }
        Context span = this.tracer.isEnabled() && this.receiverKind != ReceiverKind.SYNC_RECEIVER ? this.tracer.startProcessSpan(name, message, parent) : parent;
        this.meter.reportConsumerLag(message.getEnqueuedTime(), span);
        return span;
    }

    public <T> Mono<T> instrumentSettlement(Mono<T> publisher, ServiceBusReceivedMessage message, Context messageContext, DispositionStatus status) {
        if (this.tracer.isEnabled() || this.meter.isSettlementEnabled()) {
            return Mono.defer(() -> {
                long startTime = Instant.now().toEpochMilli();
                Context span = this.tracer.startSpanWithLink(ServiceBusReceiverInstrumentation.getSettlementSpanName(status), ServiceBusTracer.OperationName.SETTLE, message, messageContext);
                return publisher.doOnEach(signal -> {
                    this.meter.reportSettlement(startTime, message.getSequenceNumber(), status, signal.getThrowable(), false, span);
                    this.tracer.endSpan(signal.getThrowable(), span, null);
                }).doOnCancel(() -> {
                    this.meter.reportSettlement(startTime, message.getSequenceNumber(), status, null, true, span);
                    this.tracer.cancelSpan(span);
                });
            });
        }
        return publisher;
    }

    public ServiceBusTracer getTracer() {
        return this.tracer;
    }

    private static String getSettlementSpanName(DispositionStatus status) {
        switch (status) {
            case COMPLETED: {
                return "ServiceBus.complete";
            }
            case ABANDONED: {
                return "ServiceBus.abandon";
            }
            case DEFERRED: {
                return "ServiceBus.defer";
            }
            case SUSPENDED: {
                return "ServiceBus.deadLetter";
            }
            case RELEASED: {
                return "ServiceBus.release";
            }
        }
        return "ServiceBus.unknown";
    }
}

