/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.util.logging.ClientLogger;

final class MessagePumpTerminatedException
extends RuntimeException {
    private final long pumpId;
    private final String fullyQualifiedNamespace;
    private final String entityPath;

    MessagePumpTerminatedException(long pumpId, String fullyQualifiedNamespace, String entityPath, String detectedAt) {
        super(detectedAt);
        this.pumpId = pumpId;
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.entityPath = entityPath;
    }

    MessagePumpTerminatedException(long pumpId, String fullyQualifiedNamespace, String entityPath, String detectedAt, Throwable terminationCause) {
        super(detectedAt, terminationCause);
        this.pumpId = pumpId;
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.entityPath = entityPath;
    }

    static MessagePumpTerminatedException forCompletion(long pumpId, String fullyQualifiedNamespace, String entityPath) {
        return new MessagePumpTerminatedException(pumpId, fullyQualifiedNamespace, entityPath, "pumping#reached-completion");
    }

    void log(ClientLogger logger, String message, boolean logError) {
        if (logError) {
            MessagePumpTerminatedException error = this;
            logger.atInfo().addKeyValue("pumpId", this.pumpId).addKeyValue("namespace", this.fullyQualifiedNamespace).addKeyValue("entityPath", this.entityPath).log(message, new Object[]{error});
        } else {
            logger.atInfo().addKeyValue("pumpId", this.pumpId).addKeyValue("namespace", this.fullyQualifiedNamespace).addKeyValue("entityPath", this.entityPath).log(message);
        }
    }
}

