/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.AdministrationModelConverter;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.RulesImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyImpl;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntryImpl;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeedImpl;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.QueueRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.administration.models.TopicRuntimeProperties;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

@ServiceClient(builder=ServiceBusAdministrationClientBuilder.class)
public final class ServiceBusAdministrationClient {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusAdministrationClient.class);
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private final ServiceBusManagementClientImpl managementClient;
    private final EntitiesImpl entityClient;
    private final RulesImpl rulesClient;
    private final AdministrationModelConverter converter;

    ServiceBusAdministrationClient(ServiceBusManagementClientImpl managementClient, ServiceBusManagementSerializer serializer) {
        Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        this.managementClient = Objects.requireNonNull(managementClient, "'managementClient' cannot be null.");
        this.entityClient = managementClient.getEntities();
        this.rulesClient = managementClient.getRules();
        this.converter = new AdministrationModelConverter(LOGGER, managementClient.getEndpoint(), serializer);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName) {
        return this.createQueue(queueName, new CreateQueueOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName, CreateQueueOptions queueOptions) {
        return (QueueProperties)this.createQueueWithResponse(queueName, queueOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> createQueueWithResponse(String queueName, CreateQueueOptions queueOptions, Context context) {
        this.converter.validateQueueName(queueName);
        if (queueOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'queueOptions' cannot be null."));
        }
        Context contextWithHeaders = this.enableSyncContext(context);
        CreateQueueBodyImpl createEntity = this.converter.getCreateQueueBody(queueOptions, contextWithHeaders);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.putWithResponse(queueName, createEntity, null, contextWithHeaders));
        return this.converter.deserializeQueue(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String subscriptionName, String ruleName) {
        return this.createRule(topicName, ruleName, subscriptionName, new CreateRuleOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String ruleName, String subscriptionName, CreateRuleOptions ruleOptions) {
        return (RuleProperties)this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        this.converter.validateTopicName(topicName);
        this.converter.validateSubscriptionName(subscriptionName);
        this.converter.validateRuleName(ruleName);
        if (ruleOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'ruleOptions' cannot be null."));
        }
        CreateRuleBodyImpl createEntity = this.converter.getCreateRuleBody(ruleName, ruleOptions);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getRules().putWithResponse(topicName, subscriptionName, ruleName, createEntity, null, this.enableSyncContext(context)));
        return this.converter.getRulePropertiesSimpleResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName) {
        return this.createSubscription(topicName, subscriptionName, new CreateSubscriptionOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return (SubscriptionProperties)this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions) {
        return (SubscriptionProperties)this.createSubscriptionWithResponse(topicName, subscriptionName, ruleName, subscriptionOptions, ruleOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions, Context context) {
        return this.createSubscriptionWithResponse(topicName, subscriptionName, null, subscriptionOptions, null, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> createSubscriptionWithResponse(String topicName, String subscriptionName, String ruleName, CreateSubscriptionOptions subscriptionOptions, CreateRuleOptions ruleOptions, Context context) {
        this.converter.validateTopicName(topicName);
        this.converter.validateSubscriptionName(subscriptionName);
        if (subscriptionOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'subscriptionOptions' cannot be null."));
        }
        Context contextWithHeaders = this.converter.getContext(context);
        CreateSubscriptionBodyImpl createEntity = this.converter.getCreateSubscriptionBody(subscriptionOptions, ruleName, ruleOptions, contextWithHeaders);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getSubscriptions().putWithResponse(topicName, subscriptionName, createEntity, null, contextWithHeaders));
        return this.converter.getSubscriptionPropertiesSimpleResponse(topicName, response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName) {
        return this.createTopic(topicName, new CreateTopicOptions());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName, CreateTopicOptions topicOptions) {
        return (TopicProperties)this.createTopicWithResponse(topicName, topicOptions, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions, Context context) {
        this.converter.validateTopicName(topicName);
        if (topicOptions == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'topicOptions' cannot be null."));
        }
        CreateTopicBodyImpl createEntity = this.converter.getCreateTopicBody(EntityHelper.getTopicDescription(topicOptions));
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.putWithResponse(topicName, createEntity, null, this.enableSyncContext(context)));
        return this.converter.deserializeTopic(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteQueue(String queueName) {
        this.deleteQueueWithResponse(queueName, null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteQueueWithResponse(String queueName, Context context) {
        this.converter.validateQueueName(queueName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.deleteWithResponse(queueName, this.enableSyncContext(context)));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRule(String topicName, String subscriptionName, String ruleName) {
        this.deleteRuleWithResponse(topicName, subscriptionName, ruleName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        this.converter.validateTopicName(topicName);
        this.converter.validateSubscriptionName(subscriptionName);
        this.converter.validateRuleName(ruleName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.rulesClient.deleteWithResponse(topicName, subscriptionName, ruleName, this.enableSyncContext(context)));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubscription(String topicName, String subscriptionName) {
        this.deleteSubscriptionWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        this.converter.validateSubscriptionName(subscriptionName);
        this.converter.validateTopicName(topicName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getSubscriptions().deleteWithResponse(topicName, subscriptionName, this.enableSyncContext(context)));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTopic(String topicName) {
        this.deleteTopicWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTopicWithResponse(String topicName, Context context) {
        this.converter.validateTopicName(topicName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.deleteWithResponse(topicName, this.enableSyncContext(context)));
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties getQueue(String queueName) {
        return (QueueProperties)this.getQueueWithResponse(queueName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> getQueueWithResponse(String queueName, Context context) {
        Response<QueueProperties> response = this.getQueueInternal(queueName, context);
        if (response.getValue() == null) {
            AdministrationModelConverter.EntityNotFoundHttpResponse<QueueProperties> notFoundResponse = new AdministrationModelConverter.EntityNotFoundHttpResponse<QueueProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Queue '%s' does not exist.", queueName), notFoundResponse));
        }
        return response;
    }

    private Response<QueueProperties> getQueueInternal(String queueName, Context context) {
        this.converter.validateQueueName(queueName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.getWithResponse(queueName, true, this.enableSyncContext(context)));
        return this.converter.deserializeQueue(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getQueueExists(String queueName) {
        Boolean exists = (Boolean)this.getQueueExistsWithResponse(queueName, null).getValue();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getQueueExistsWithResponse(String queueName, Context context) {
        return this.getEntityExistsWithResponse(() -> this.getQueueInternal(queueName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueRuntimeProperties getQueueRuntimeProperties(String queueName) {
        return (QueueRuntimeProperties)this.getQueueRuntimePropertiesWithResponse(queueName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueRuntimeProperties> getQueueRuntimePropertiesWithResponse(String queueName, Context context) {
        Response<QueueProperties> response = this.getQueueWithResponse(queueName, context);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new QueueRuntimeProperties((QueueProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceProperties getNamespaceProperties() {
        return (NamespaceProperties)this.getNamespacePropertiesWithResponse(null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceProperties> getNamespacePropertiesWithResponse(Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getNamespaces().getWithResponse(this.enableSyncContext(context)));
        NamespacePropertiesEntryImpl entry = (NamespacePropertiesEntryImpl)response.getValue();
        if (entry == null || entry.getContent() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("There was no content inside namespace response. Entry: " + response));
        }
        NamespaceProperties namespaceProperties = entry.getContent().getNamespaceProperties();
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)namespaceProperties);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties getRule(String topicName, String subscriptionName, String ruleName) {
        return (RuleProperties)this.getRuleWithResponse(topicName, subscriptionName, ruleName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> getRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.rulesClient.getWithResponse(topicName, subscriptionName, ruleName, true, this.enableSyncContext(context)));
        return this.converter.getRulePropertiesSimpleResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties getSubscription(String topicName, String subscriptionName) {
        return (SubscriptionProperties)this.getSubscriptionWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> getSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        return this.getSubscriptionInternal(topicName, subscriptionName, context);
    }

    private Response<SubscriptionProperties> getSubscriptionInternal(String topicName, String subscriptionName, Context context) {
        this.converter.validateTopicName(topicName);
        this.converter.validateSubscriptionName(subscriptionName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getSubscriptions().getWithResponse(topicName, subscriptionName, true, this.enableSyncContext(context)));
        return this.converter.getSubscriptionPropertiesSimpleResponse(topicName, response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getSubscriptionExists(String topicName, String subscriptionName) {
        return (Boolean)this.getSubscriptionExistsWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getSubscriptionExistsWithResponse(String topicName, String subscriptionName, Context context) {
        return this.getEntityExistsWithResponse(() -> this.getSubscriptionInternal(topicName, subscriptionName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionRuntimeProperties getSubscriptionRuntimeProperties(String topicName, String subscriptionName) {
        return (SubscriptionRuntimeProperties)this.getSubscriptionRuntimePropertiesWithResponse(topicName, subscriptionName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionRuntimeProperties> getSubscriptionRuntimePropertiesWithResponse(String topicName, String subscriptionName, Context context) {
        Response<SubscriptionProperties> response = this.getSubscriptionWithResponse(topicName, subscriptionName, context);
        if (response.getValue() == null) {
            AdministrationModelConverter.EntityNotFoundHttpResponse<SubscriptionProperties> notFoundResponse = new AdministrationModelConverter.EntityNotFoundHttpResponse<SubscriptionProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Subscription '%s' in topic '%s' does not exist.", topicName, subscriptionName), notFoundResponse));
        }
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new SubscriptionRuntimeProperties((SubscriptionProperties)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties getTopic(String topicName) {
        return (TopicProperties)this.getTopicWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> getTopicWithResponse(String topicName, Context context) {
        Response<TopicProperties> response = this.getTopicInternal(topicName, context);
        if (response.getValue() == null) {
            AdministrationModelConverter.EntityNotFoundHttpResponse<TopicProperties> notFoundResponse = new AdministrationModelConverter.EntityNotFoundHttpResponse<TopicProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
        }
        return response;
    }

    private Response<TopicProperties> getTopicInternal(String topicName, Context context) {
        this.converter.validateTopicName(topicName);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.getWithResponse(topicName, true, this.enableSyncContext(context)));
        return this.converter.deserializeTopic(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getTopicExists(String topicName) {
        Boolean exists = (Boolean)this.getTopicExistsWithResponse(topicName, null).getValue();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getTopicExistsWithResponse(String topicName, Context context) {
        return this.getEntityExistsWithResponse(() -> this.getTopicInternal(topicName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicRuntimeProperties getTopicRuntimeProperties(String topicName) {
        return (TopicRuntimeProperties)this.getTopicRuntimePropertiesWithResponse(topicName, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicRuntimeProperties> getTopicRuntimePropertiesWithResponse(String topicName, Context context) {
        Response<TopicProperties> response = this.getTopicWithResponse(topicName, context);
        if (response.getValue() == null) {
            AdministrationModelConverter.EntityNotFoundHttpResponse<TopicProperties> notFoundResponse = new AdministrationModelConverter.EntityNotFoundHttpResponse<TopicProperties>(response);
            throw LOGGER.logExceptionAsError((RuntimeException)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
        }
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)new TopicRuntimeProperties((TopicProperties)response.getValue()));
    }

    private <T> Response<Boolean> getEntityExistsWithResponse(Supplier<Response<T>> supplier) {
        try {
            Response<T> getEntityOperation = supplier.get();
            boolean exists = getEntityOperation.getValue() != null;
            return new SimpleResponse(getEntityOperation.getRequest(), getEntityOperation.getStatusCode(), getEntityOperation.getHeaders(), (Object)exists);
        }
        catch (ResourceNotFoundException exception) {
            HttpResponse response = exception.getResponse();
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues() {
        return this.listQueues(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues(Context context) {
        return new PagedIterable(() -> this.listQueues(0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listQueues(skip, context);
        });
    }

    private PagedResponse<QueueProperties> listQueues(int skip, Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.listEntitiesWithResponse("queues", skip, 100, this.enableSyncContext(context)));
        Response<QueueDescriptionFeedImpl> feedResponse = this.converter.deserialize(response, QueueDescriptionFeedImpl.class);
        QueueDescriptionFeedImpl feed = (QueueDescriptionFeedImpl)feedResponse.getValue();
        if (feed == null) {
            LOGGER.warning("Could not deserialize QueueDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<QueueProperties> entities = this.converter.getQueues(feed);
        try {
            return this.converter.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleProperties> listRules(String topicName, String subscriptionName) {
        return this.listRules(topicName, subscriptionName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleProperties> listRules(String topicName, String subscriptionName, Context context) {
        return new PagedIterable(() -> this.listRules(topicName, subscriptionName, 0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listRules(topicName, subscriptionName, skip, context);
        });
    }

    private PagedResponse<RuleProperties> listRules(String topicName, String subscriptionName, int skip, Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.listRulesWithResponse(topicName, subscriptionName, skip, 100, this.enableSyncContext(context)));
        RuleDescriptionFeedImpl feed = (RuleDescriptionFeedImpl)response.getValue();
        if (feed == null) {
            LOGGER.warning("Could not deserialize RuleDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<RuleProperties> entities = this.converter.getRules(feed);
        try {
            return this.converter.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName) {
        return this.listSubscriptions(topicName, null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName, Context context) {
        return new PagedIterable(() -> this.listSubscriptions(topicName, 0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listSubscriptions(topicName, skip, context);
        });
    }

    private PagedResponse<SubscriptionProperties> listSubscriptions(String topicName, int skip, Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.listSubscriptionsWithResponse(topicName, skip, 100, this.enableSyncContext(context)));
        SubscriptionDescriptionFeedImpl feed = (SubscriptionDescriptionFeedImpl)response.getValue();
        if (feed == null) {
            LOGGER.warning("Could not deserialize SubscriptionDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<SubscriptionProperties> entities = this.converter.getSubscriptions(topicName, feed);
        try {
            return this.converter.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<SubscriptionDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics() {
        return this.listTopics(null);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics(Context context) {
        return new PagedIterable(() -> this.listTopics(0, context), continuationToken -> {
            if (continuationToken == null || continuationToken.isEmpty()) {
                return null;
            }
            int skip = Integer.parseInt(continuationToken);
            return this.listTopics(skip, context);
        });
    }

    private PagedResponse<TopicProperties> listTopics(int skip, Context context) {
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.listEntitiesWithResponse("topics", skip, 100, this.enableSyncContext(context)));
        Response<TopicDescriptionFeedImpl> feedResponse = this.converter.deserialize(response, TopicDescriptionFeedImpl.class);
        TopicDescriptionFeedImpl feed = (TopicDescriptionFeedImpl)feedResponse.getValue();
        if (feed == null) {
            LOGGER.warning("Could not deserialize TopicDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
            return null;
        }
        List<TopicProperties> entities = this.converter.getTopics(feed);
        try {
            return this.converter.extractPage(response, entities, feed.getLink());
        }
        catch (UnsupportedEncodingException | MalformedURLException error) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Could not parse response into FeedPage<TopicDescription>", error));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties updateQueue(QueueProperties queue) {
        return (QueueProperties)this.updateQueueWithResponse(queue, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> updateQueueWithResponse(QueueProperties queue, Context context) {
        if (queue == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        Context contextWithHeaders = this.enableSyncContext(context);
        CreateQueueBodyImpl createEntity = this.converter.getUpdateQueueBody(queue, contextWithHeaders);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.putWithResponse(queue.getName(), createEntity, "*", contextWithHeaders));
        return this.converter.deserializeQueue(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties updateRule(String topicName, String subscriptionName, RuleProperties rule) {
        return (RuleProperties)this.updateRuleWithResponse(topicName, subscriptionName, rule, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule, Context context) {
        if (rule == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'rule' cannot be null"));
        }
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getRules().putWithResponse(topicName, subscriptionName, rule.getName(), this.converter.getUpdateRuleBody(rule), "*", this.enableSyncContext(context)));
        return this.converter.getRulePropertiesSimpleResponse(response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties updateSubscription(SubscriptionProperties subscription) {
        return (SubscriptionProperties)this.updateSubscriptionWithResponse(subscription, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> updateSubscriptionWithResponse(SubscriptionProperties subscription, Context context) {
        if (subscription == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'subscription' cannot be null"));
        }
        Context contextWithHeaders = this.enableSyncContext(context);
        String topicName = subscription.getTopicName();
        CreateSubscriptionBodyImpl createEntity = this.converter.getUpdateSubscriptionBody(subscription, contextWithHeaders);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.managementClient.getSubscriptions().putWithResponse(topicName, subscription.getSubscriptionName(), createEntity, "*", contextWithHeaders));
        return this.converter.getSubscriptionPropertiesSimpleResponse(topicName, response);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties updateTopic(TopicProperties topic) {
        return (TopicProperties)this.updateTopicWithResponse(topic, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> updateTopicWithResponse(TopicProperties topic, Context context) {
        if (topic == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'topic' cannot be null"));
        }
        CreateTopicBodyImpl createEntity = this.converter.getUpdateTopicBody(topic);
        Response response = ServiceBusAdministrationClient.executeAndThrowException(() -> this.entityClient.putWithResponse(topic.getName(), createEntity, "*", this.enableSyncContext(context)));
        return this.converter.deserializeTopic(response);
    }

    private Context enableSyncContext(Context context) {
        return this.converter.getContext(context).addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    private static <T> Response<T> executeAndThrowException(Supplier<Response<T>> serviceCall) {
        try {
            return serviceCall.get();
        }
        catch (ServiceBusManagementErrorException error) {
            throw AdministrationModelConverter.mapException(error);
        }
    }
}

