/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpMessageConstant;
import com.azure.core.amqp.models.AmqpAddress;
import com.azure.core.amqp.models.AmqpAnnotatedMessage;
import com.azure.core.amqp.models.AmqpMessageBody;
import com.azure.core.amqp.models.AmqpMessageBodyType;
import com.azure.core.amqp.models.AmqpMessageHeader;
import com.azure.core.amqp.models.AmqpMessageId;
import com.azure.core.amqp.models.AmqpMessageProperties;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.implementation.instrumentation.ContextAccessor;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServiceBusMessage {
    private static final int MAX_MESSAGE_ID_LENGTH = 128;
    private static final int MAX_PARTITION_KEY_LENGTH = 128;
    private static final int MAX_SESSION_ID_LENGTH = 128;
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusMessage.class);
    private final AmqpAnnotatedMessage amqpAnnotatedMessage;
    private Context context;

    public ServiceBusMessage(byte[] body) {
        this(BinaryData.fromBytes((byte[])Objects.requireNonNull(body, "'body' cannot be null.")));
    }

    public ServiceBusMessage(String body) {
        this(BinaryData.fromString((String)Objects.requireNonNull(body, "'body' cannot be null.")));
    }

    public ServiceBusMessage(BinaryData body) {
        Objects.requireNonNull(body, "'body' cannot be null.");
        this.context = Context.NONE;
        this.amqpAnnotatedMessage = new AmqpAnnotatedMessage(AmqpMessageBody.fromData((byte[])body.toBytes()));
    }

    public ServiceBusMessage(AmqpMessageBody amqpMessageBody) {
        Objects.requireNonNull(amqpMessageBody, "'body' cannot be null.");
        this.context = Context.NONE;
        this.amqpAnnotatedMessage = new AmqpAnnotatedMessage(amqpMessageBody);
    }

    public ServiceBusMessage(ServiceBusReceivedMessage receivedMessage) {
        AmqpMessageBody amqpMessageBody;
        Objects.requireNonNull(receivedMessage, "'receivedMessage' cannot be null.");
        AmqpMessageBodyType bodyType = receivedMessage.getRawAmqpMessage().getBody().getBodyType();
        switch (bodyType) {
            case DATA: {
                amqpMessageBody = AmqpMessageBody.fromData((byte[])receivedMessage.getRawAmqpMessage().getBody().getFirstData());
                break;
            }
            case SEQUENCE: {
                amqpMessageBody = AmqpMessageBody.fromSequence((List)receivedMessage.getRawAmqpMessage().getBody().getSequence());
                break;
            }
            case VALUE: {
                amqpMessageBody = AmqpMessageBody.fromValue((Object)receivedMessage.getRawAmqpMessage().getBody().getValue());
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Body type not valid " + bodyType));
            }
        }
        this.amqpAnnotatedMessage = new AmqpAnnotatedMessage(amqpMessageBody);
        AmqpMessageProperties receivedProperties = receivedMessage.getRawAmqpMessage().getProperties();
        AmqpMessageProperties newProperties = this.amqpAnnotatedMessage.getProperties();
        newProperties.setMessageId(receivedProperties.getMessageId());
        newProperties.setUserId(receivedProperties.getUserId());
        newProperties.setTo(receivedProperties.getTo());
        newProperties.setSubject(receivedProperties.getSubject());
        newProperties.setReplyTo(receivedProperties.getReplyTo());
        newProperties.setCorrelationId(receivedProperties.getCorrelationId());
        newProperties.setContentType(receivedProperties.getContentType());
        newProperties.setContentEncoding(receivedProperties.getContentEncoding());
        newProperties.setAbsoluteExpiryTime(receivedProperties.getAbsoluteExpiryTime());
        newProperties.setCreationTime(receivedProperties.getCreationTime());
        newProperties.setGroupId(receivedProperties.getGroupId());
        newProperties.setGroupSequence(receivedProperties.getGroupSequence());
        newProperties.setReplyToGroupId(receivedProperties.getReplyToGroupId());
        AmqpMessageHeader receivedHeader = receivedMessage.getRawAmqpMessage().getHeader();
        AmqpMessageHeader newHeader = this.amqpAnnotatedMessage.getHeader();
        newHeader.setPriority(receivedHeader.getPriority());
        newHeader.setTimeToLive(receivedHeader.getTimeToLive());
        newHeader.setDurable(receivedHeader.isDurable());
        newHeader.setFirstAcquirer(receivedHeader.isFirstAcquirer());
        Map receivedAnnotations = receivedMessage.getRawAmqpMessage().getMessageAnnotations();
        Map newAnnotations = this.amqpAnnotatedMessage.getMessageAnnotations();
        for (Map.Entry entry : receivedAnnotations.entrySet()) {
            if (AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.LOCKED_UNTIL_KEY_ANNOTATION_NAME || AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.SEQUENCE_NUMBER_ANNOTATION_NAME || AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.DEAD_LETTER_SOURCE_KEY_ANNOTATION_NAME || AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.ENQUEUED_SEQUENCE_NUMBER_ANNOTATION_NAME || AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.ENQUEUED_TIME_UTC_ANNOTATION_NAME) continue;
            newAnnotations.put((String)entry.getKey(), entry.getValue());
        }
        Map receivedDelivery = receivedMessage.getRawAmqpMessage().getDeliveryAnnotations();
        Map newDelivery = this.amqpAnnotatedMessage.getDeliveryAnnotations();
        for (Map.Entry entry : receivedDelivery.entrySet()) {
            newDelivery.put((String)entry.getKey(), entry.getValue());
        }
        Map receivedFooter = receivedMessage.getRawAmqpMessage().getFooter();
        Map newFooter = this.amqpAnnotatedMessage.getFooter();
        for (Map.Entry entry : receivedFooter.entrySet()) {
            newFooter.put((String)entry.getKey(), entry.getValue());
        }
        Map receivedApplicationProperties = receivedMessage.getRawAmqpMessage().getApplicationProperties();
        Map newApplicationProperties = this.amqpAnnotatedMessage.getApplicationProperties();
        for (Map.Entry entry : receivedApplicationProperties.entrySet()) {
            if (AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.DEAD_LETTER_DESCRIPTION_ANNOTATION_NAME || AmqpMessageConstant.fromString((String)((String)entry.getKey())) == AmqpMessageConstant.DEAD_LETTER_REASON_ANNOTATION_NAME) continue;
            newApplicationProperties.put((String)entry.getKey(), entry.getValue());
        }
        this.context = Context.NONE;
    }

    public Map<String, Object> getApplicationProperties() {
        return this.amqpAnnotatedMessage.getApplicationProperties();
    }

    public BinaryData getBody() {
        AmqpMessageBodyType type = this.amqpAnnotatedMessage.getBody().getBodyType();
        switch (type) {
            case DATA: {
                return BinaryData.fromBytes((byte[])this.amqpAnnotatedMessage.getBody().getFirstData());
            }
            case SEQUENCE: 
            case VALUE: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Message  body type is not DATA, instead it is: " + type));
            }
        }
        throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown AmqpBodyType: " + type));
    }

    public String getContentType() {
        return this.amqpAnnotatedMessage.getProperties().getContentType();
    }

    public ServiceBusMessage setContentType(String contentType) {
        this.amqpAnnotatedMessage.getProperties().setContentType(contentType);
        return this;
    }

    public String getCorrelationId() {
        String correlationId = null;
        AmqpMessageId amqpCorrelationId = this.amqpAnnotatedMessage.getProperties().getCorrelationId();
        if (amqpCorrelationId != null) {
            correlationId = amqpCorrelationId.toString();
        }
        return correlationId;
    }

    public ServiceBusMessage setCorrelationId(String correlationId) {
        AmqpMessageId id = null;
        if (correlationId != null) {
            id = new AmqpMessageId(correlationId);
        }
        this.amqpAnnotatedMessage.getProperties().setCorrelationId(id);
        return this;
    }

    public String getSubject() {
        return this.amqpAnnotatedMessage.getProperties().getSubject();
    }

    public ServiceBusMessage setSubject(String subject) {
        this.amqpAnnotatedMessage.getProperties().setSubject(subject);
        return this;
    }

    public String getMessageId() {
        String messageId = null;
        AmqpMessageId amqpMessageId = this.amqpAnnotatedMessage.getProperties().getMessageId();
        if (amqpMessageId != null) {
            messageId = amqpMessageId.toString();
        }
        return messageId;
    }

    public ServiceBusMessage setMessageId(String messageId) {
        this.checkIdLength("messageId", messageId, 128);
        AmqpMessageId id = null;
        if (messageId != null) {
            id = new AmqpMessageId(messageId);
        }
        this.amqpAnnotatedMessage.getProperties().setMessageId(id);
        return this;
    }

    public String getPartitionKey() {
        return (String)this.amqpAnnotatedMessage.getMessageAnnotations().get(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue());
    }

    public ServiceBusMessage setPartitionKey(String partitionKey) {
        this.checkIdLength("partitionKey", partitionKey, 128);
        this.checkPartitionKey(partitionKey);
        this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.PARTITION_KEY_ANNOTATION_NAME.getValue(), partitionKey);
        return this;
    }

    public AmqpAnnotatedMessage getRawAmqpMessage() {
        return this.amqpAnnotatedMessage;
    }

    public String getReplyTo() {
        String replyTo = null;
        AmqpAddress amqpAddress = this.amqpAnnotatedMessage.getProperties().getReplyTo();
        if (amqpAddress != null) {
            replyTo = amqpAddress.toString();
        }
        return replyTo;
    }

    public ServiceBusMessage setReplyTo(String replyTo) {
        AmqpAddress replyToAddress = null;
        if (replyTo != null) {
            replyToAddress = new AmqpAddress(replyTo);
        }
        this.amqpAnnotatedMessage.getProperties().setReplyTo(replyToAddress);
        return this;
    }

    public String getTo() {
        String to = null;
        AmqpAddress amqpAddress = this.amqpAnnotatedMessage.getProperties().getTo();
        if (amqpAddress != null) {
            to = amqpAddress.toString();
        }
        return to;
    }

    public ServiceBusMessage setTo(String to) {
        AmqpAddress toAddress = null;
        if (to != null) {
            toAddress = new AmqpAddress(to);
        }
        this.amqpAnnotatedMessage.getProperties().setTo(toAddress);
        return this;
    }

    public Duration getTimeToLive() {
        return this.amqpAnnotatedMessage.getHeader().getTimeToLive();
    }

    public ServiceBusMessage setTimeToLive(Duration timeToLive) {
        this.amqpAnnotatedMessage.getHeader().setTimeToLive(timeToLive);
        return this;
    }

    public OffsetDateTime getScheduledEnqueueTime() {
        Object value = this.amqpAnnotatedMessage.getMessageAnnotations().get(AmqpMessageConstant.SCHEDULED_ENQUEUE_UTC_TIME_NAME.getValue());
        return value != null ? ((OffsetDateTime)value).toInstant().atOffset(ZoneOffset.UTC) : null;
    }

    public ServiceBusMessage setScheduledEnqueueTime(OffsetDateTime scheduledEnqueueTime) {
        if (scheduledEnqueueTime != null) {
            this.amqpAnnotatedMessage.getMessageAnnotations().put(AmqpMessageConstant.SCHEDULED_ENQUEUE_UTC_TIME_NAME.getValue(), scheduledEnqueueTime);
        }
        return this;
    }

    public String getReplyToSessionId() {
        return this.amqpAnnotatedMessage.getProperties().getReplyToGroupId();
    }

    public ServiceBusMessage setReplyToSessionId(String replyToSessionId) {
        this.amqpAnnotatedMessage.getProperties().setReplyToGroupId(replyToSessionId);
        return this;
    }

    public String getSessionId() {
        return this.amqpAnnotatedMessage.getProperties().getGroupId();
    }

    public ServiceBusMessage setSessionId(String sessionId) {
        this.checkIdLength("sessionId", sessionId, 128);
        this.checkSessionId(sessionId);
        this.amqpAnnotatedMessage.getProperties().setGroupId(sessionId);
        return this;
    }

    Context getContext() {
        return this.context;
    }

    public ServiceBusMessage addContext(String key, Object value) {
        Objects.requireNonNull(key, "The 'key' parameter cannot be null.");
        Objects.requireNonNull(value, "The 'value' parameter cannot be null.");
        this.context = this.context.addData((Object)key, value);
        return this;
    }

    private void checkIdLength(String fieldName, String value, int maxLength) {
        if (value != null && value.length() > maxLength) {
            String message = String.format("%s cannot be longer than %d characters.", fieldName, maxLength);
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(message));
        }
    }

    private void checkSessionId(String proposedSessionId) {
        if (proposedSessionId == null) {
            return;
        }
        if (this.getPartitionKey() != null && this.getPartitionKey().compareTo(proposedSessionId) != 0) {
            String message = String.format("sessionId:%s cannot be set to a different value than partitionKey:%s.", proposedSessionId, this.getPartitionKey());
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(message));
        }
    }

    private void checkPartitionKey(String proposedPartitionKey) {
        if (proposedPartitionKey == null) {
            return;
        }
        if (this.getSessionId() != null && this.getSessionId().compareTo(proposedPartitionKey) != 0) {
            String message = String.format("partitionKey:%s cannot be set to a different value than sessionId:%s.", proposedPartitionKey, this.getSessionId());
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(message));
        }
    }

    static {
        ContextAccessor.setSendMessageContextAccessor(message -> message.getContext());
    }
}

