/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.messaging.servicebus.ServiceBusServiceVersion;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationAsyncClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import com.azure.messaging.servicebus.administration.ServiceBusSupplementaryAuthHeaderPolicy;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementClientImplBuilder;
import com.azure.messaging.servicebus.administration.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import com.azure.messaging.servicebus.implementation.ServiceBusTokenCredentialHttpPolicy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={ServiceBusAdministrationClient.class, ServiceBusAdministrationAsyncClient.class})
public final class ServiceBusAdministrationClientBuilder
implements TokenCredentialTrait<ServiceBusAdministrationClientBuilder>,
AzureSasCredentialTrait<ServiceBusAdministrationClientBuilder>,
ConnectionStringTrait<ServiceBusAdministrationClientBuilder>,
HttpTrait<ServiceBusAdministrationClientBuilder>,
ConfigurationTrait<ServiceBusAdministrationClientBuilder>,
EndpointTrait<ServiceBusAdministrationClientBuilder> {
    private static final String CLIENT_NAME;
    private static final String CLIENT_VERSION;
    private static final ClientLogger LOGGER;
    private final ServiceBusManagementSerializer serializer = new ServiceBusManagementSerializer();
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private Configuration configuration;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline pipeline;
    private HttpPipelinePolicy retryPolicy;
    private RetryOptions retryOptions;
    private TokenCredential tokenCredential;
    private ServiceBusServiceVersion serviceVersion;
    private ClientOptions clientOptions;

    public ServiceBusAdministrationAsyncClient buildAsyncClient() {
        ServiceBusManagementClientImpl client = this.getServiceBusManagementClient();
        return new ServiceBusAdministrationAsyncClient(client, this.serializer);
    }

    private ServiceBusManagementClientImpl getServiceBusManagementClient() {
        if (this.endpoint == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new NullPointerException("'endpoint' cannot be null."));
        }
        ServiceBusServiceVersion apiVersion = this.serviceVersion == null ? ServiceBusServiceVersion.getLatest() : this.serviceVersion;
        HttpPipeline httpPipeline = this.createPipeline();
        ServiceBusManagementClientImpl client = new ServiceBusManagementClientImplBuilder().pipeline(httpPipeline).serializerAdapter(this.serializer).endpoint(this.endpoint).apiVersion(apiVersion.getVersion()).buildClient();
        return client;
    }

    public ServiceBusAdministrationClient buildClient() {
        return new ServiceBusAdministrationClient(this.getServiceBusManagementClient(), this.serializer);
    }

    public ServiceBusAdministrationClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public ServiceBusAdministrationClientBuilder endpoint(String endpoint) {
        URL url;
        try {
            url = new URL(Objects.requireNonNull(endpoint, "'endpoint' cannot be null."));
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL", ex));
        }
        this.endpoint = url.getHost();
        return this;
    }

    public ServiceBusAdministrationClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ServiceBusAdministrationClientBuilder connectionString(String connectionString) {
        ServiceBusSharedKeyCredential tokenCredential;
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        ConnectionStringProperties properties = new ConnectionStringProperties(connectionString);
        try {
            tokenCredential = new ServiceBusSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ServiceBusConstants.TOKEN_VALIDITY);
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Could not create the ServiceBusSharedKeyCredential.", (Throwable)e));
        }
        this.endpoint = properties.getEndpoint().getHost();
        if (properties.getEntityPath() != null && !properties.getEntityPath().isEmpty()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' cannot contain an EntityPath. It should be a namespace connection string."));
        }
        return this.credential(properties.getEndpoint().getHost(), tokenCredential);
    }

    public ServiceBusAdministrationClientBuilder credential(String fullyQualifiedNamespace, TokenCredential credential) {
        this.endpoint = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    public ServiceBusAdministrationClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public ServiceBusAdministrationClientBuilder credential(AzureSasCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.tokenCredential = new ServiceBusSharedKeyCredential(credential.getSignature());
        return this;
    }

    public ServiceBusAdministrationClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            LOGGER.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public ServiceBusAdministrationClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public ServiceBusAdministrationClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ServiceBusAdministrationClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            LOGGER.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public ServiceBusAdministrationClientBuilder retryPolicy(HttpPipelinePolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public ServiceBusAdministrationClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public ServiceBusAdministrationClientBuilder serviceVersion(ServiceBusServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    private HttpPipeline createPipeline() {
        if (this.pipeline != null) {
            return this.pipeline;
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        ArrayList<Object> httpPolicies = new ArrayList<Object>();
        String applicationId = CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions);
        httpPolicies.add(new UserAgentPolicy(applicationId, CLIENT_NAME, CLIENT_VERSION, buildConfiguration));
        httpPolicies.add(new ServiceBusTokenCredentialHttpPolicy(this.tokenCredential));
        httpPolicies.add(new AddHeadersFromContextPolicy());
        httpPolicies.add(new ServiceBusSupplementaryAuthHeaderPolicy(this.tokenCredential));
        httpPolicies.addAll(this.perCallPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(httpPolicies);
        httpPolicies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions));
        httpPolicies.addAll(this.perRetryPolicies);
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(h -> httpHeaderList.add(new HttpHeader(h.getName(), h.getValue())));
            if (!httpHeaderList.isEmpty()) {
                httpPolicies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
            }
        }
        httpPolicies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPolicyProviders.addAfterRetryPolicies(httpPolicies);
        return new HttpPipelineBuilder().policies(httpPolicies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).tracer(this.createTracer()).build();
    }

    private Tracer createTracer() {
        return TracerProvider.getDefaultProvider().createTracer(CLIENT_NAME, CLIENT_VERSION, "Microsoft.ServiceBus", this.clientOptions == null ? null : this.clientOptions.getTracingOptions());
    }

    static {
        Map properties = CoreUtils.getProperties((String)"azure-messaging-servicebus.properties");
        CLIENT_NAME = properties.getOrDefault("name", "UnknownName");
        CLIENT_VERSION = properties.getOrDefault("version", "UnknownVersion");
        LOGGER = new ClientLogger(ServiceBusAdministrationClientBuilder.class);
    }
}

