/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.amqp.implementation.AmqpReceiveLink;
import com.azure.core.util.AsyncCloseable;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import reactor.core.publisher.Mono;

public interface ServiceBusReceiveLink
extends AmqpReceiveLink,
AsyncCloseable {
    public Mono<String> getSessionId();

    public Mono<OffsetDateTime> getSessionLockedUntil();

    public Mono<SessionProperties> getSessionProperties();

    public Mono<Void> updateDisposition(String var1, DeliveryState var2);

    public static class SessionProperties {
        private final String id;
        private final OffsetDateTime lockedUntil;

        public SessionProperties(String sessionId, OffsetDateTime sessionLockedUntil) {
            this.id = Objects.requireNonNull(sessionId, "sessionId cannot be null.");
            this.lockedUntil = Objects.requireNonNull(sessionLockedUntil, "sessionLockedUntil cannot be null");
        }

        public String getId() {
            return this.id;
        }

        public OffsetDateTime getLockedUntil() {
            return this.lockedUntil;
        }
    }
}

