/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.CoreToCodegenBridgeUtils;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatusImpl;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueDescriptionImpl
implements XmlSerializable<QueueDescriptionImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private Duration lockDuration;
    private Long maxSizeInMegabytes;
    private Boolean requiresDuplicateDetection;
    private Boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private Boolean deadLetteringOnMessageExpiration;
    private Duration duplicateDetectionHistoryTimeWindow;
    private Integer maxDeliveryCount;
    private Boolean enableBatchedOperations;
    private Long sizeInBytes;
    private Integer messageCount;
    private Boolean isAnonymousAccessible;
    private List<AuthorizationRuleImpl> authorizationRules;
    private EntityStatus status;
    private String forwardTo;
    private String userMetadata;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private Boolean supportOrdering;
    private MessageCountDetailsImpl messageCountDetails;
    private Duration autoDeleteOnIdle;
    private Boolean enablePartitioning;
    private EntityAvailabilityStatusImpl entityAvailabilityStatus;
    private String forwardDeadLetteredMessagesTo;
    private Boolean enableExpress;
    private Long maxMessageSizeInKilobytes;

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public QueueDescriptionImpl setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public QueueDescriptionImpl setMaxSizeInMegabytes(Long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Boolean isRequiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public QueueDescriptionImpl setRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Boolean isRequiresSession() {
        return this.requiresSession;
    }

    public QueueDescriptionImpl setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public QueueDescriptionImpl setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public QueueDescriptionImpl setDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public QueueDescriptionImpl setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public QueueDescriptionImpl setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public QueueDescriptionImpl setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public QueueDescriptionImpl setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public Integer getMessageCount() {
        return this.messageCount;
    }

    public QueueDescriptionImpl setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public Boolean isAnonymousAccessible() {
        return this.isAnonymousAccessible;
    }

    public QueueDescriptionImpl setIsAnonymousAccessible(Boolean isAnonymousAccessible) {
        this.isAnonymousAccessible = isAnonymousAccessible;
        return this;
    }

    public List<AuthorizationRuleImpl> getAuthorizationRules() {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRuleImpl>();
        }
        return this.authorizationRules;
    }

    public QueueDescriptionImpl setAuthorizationRules(List<AuthorizationRuleImpl> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public QueueDescriptionImpl setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public QueueDescriptionImpl setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public QueueDescriptionImpl setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public QueueDescriptionImpl setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public QueueDescriptionImpl setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public QueueDescriptionImpl setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    public Boolean isSupportOrdering() {
        return this.supportOrdering;
    }

    public QueueDescriptionImpl setSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public MessageCountDetailsImpl getMessageCountDetails() {
        return this.messageCountDetails;
    }

    public QueueDescriptionImpl setMessageCountDetails(MessageCountDetailsImpl messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public QueueDescriptionImpl setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Boolean isEnablePartitioning() {
        return this.enablePartitioning;
    }

    public QueueDescriptionImpl setEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public EntityAvailabilityStatusImpl getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public QueueDescriptionImpl setEntityAvailabilityStatus(EntityAvailabilityStatusImpl entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public QueueDescriptionImpl setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Boolean isEnableExpress() {
        return this.enableExpress;
    }

    public QueueDescriptionImpl setEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public Long getMaxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public QueueDescriptionImpl setMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "LockDuration", CoreToCodegenBridgeUtils.durationToStringWithDays(this.lockDuration));
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxSizeInMegabytes", (Number)this.maxSizeInMegabytes);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresDuplicateDetection", this.requiresDuplicateDetection);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresSession", this.requiresSession);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive", CoreToCodegenBridgeUtils.durationToStringWithDays(this.defaultMessageTimeToLive));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnMessageExpiration", this.deadLetteringOnMessageExpiration);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DuplicateDetectionHistoryTimeWindow", CoreToCodegenBridgeUtils.durationToStringWithDays(this.duplicateDetectionHistoryTimeWindow));
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxDeliveryCount", (Number)this.maxDeliveryCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations", this.enableBatchedOperations);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SizeInBytes", (Number)this.sizeInBytes);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageCount", (Number)this.messageCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "IsAnonymousAccessible", this.isAnonymousAccessible);
        if (this.authorizationRules != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AuthorizationRules");
            for (AuthorizationRuleImpl element : this.authorizationRules) {
                xmlWriter.writeXml((XmlSerializable)element, "AuthorizationRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardTo", this.forwardTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt", this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt", this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SupportOrdering", this.supportOrdering);
        xmlWriter.writeXml((XmlSerializable)this.messageCountDetails, "CountDetails");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle", CoreToCodegenBridgeUtils.durationToStringWithDays(this.autoDeleteOnIdle));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnablePartitioning", this.enablePartitioning);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus", this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardDeadLetteredMessagesTo", this.forwardDeadLetteredMessagesTo);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableExpress", this.enableExpress);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxMessageSizeInKilobytes", (Number)this.maxMessageSizeInKilobytes);
        return xmlWriter.writeEndElement();
    }

    public static QueueDescriptionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueDescriptionImpl.fromXml(xmlReader, null);
    }

    public static QueueDescriptionImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueDescription" : rootElementName;
        return (QueueDescriptionImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            QueueDescriptionImpl deserializedQueueDescription = new QueueDescriptionImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("LockDuration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.lockDuration = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("MaxSizeInMegabytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxSizeInMegabytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("RequiresDuplicateDetection".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.requiresDuplicateDetection = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("RequiresSession".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.requiresSession = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.defaultMessageTimeToLive = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("DeadLetteringOnMessageExpiration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.deadLetteringOnMessageExpiration = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DuplicateDetectionHistoryTimeWindow".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.duplicateDetectionHistoryTimeWindow = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("MaxDeliveryCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxDeliveryCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("EnableBatchedOperations".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enableBatchedOperations = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("SizeInBytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.sizeInBytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("MessageCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.messageCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("IsAnonymousAccessible".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.isAnonymousAccessible = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("AuthorizationRules".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AuthorizationRule".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedQueueDescription.authorizationRules == null) {
                                deserializedQueueDescription.authorizationRules = new ArrayList<AuthorizationRuleImpl>();
                            }
                            deserializedQueueDescription.authorizationRules.add(AuthorizationRuleImpl.fromXml(reader, "AuthorizationRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("Status".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.status = EntityStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("ForwardTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.forwardTo = reader.getStringElement();
                    continue;
                }
                if ("UserMetadata".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.userMetadata = reader.getStringElement();
                    continue;
                }
                if ("CreatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.createdAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("UpdatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.updatedAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("AccessedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.accessedAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("SupportOrdering".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.supportOrdering = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("CountDetails".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.messageCountDetails = MessageCountDetailsImpl.fromXml(reader, "CountDetails");
                    continue;
                }
                if ("AutoDeleteOnIdle".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.autoDeleteOnIdle = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("EnablePartitioning".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enablePartitioning = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("EntityAvailabilityStatus".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.entityAvailabilityStatus = EntityAvailabilityStatusImpl.fromString(reader.getStringElement());
                    continue;
                }
                if ("ForwardDeadLetteredMessagesTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.forwardDeadLetteredMessagesTo = reader.getStringElement();
                    continue;
                }
                if ("EnableExpress".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.enableExpress = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("MaxMessageSizeInKilobytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescription.maxMessageSizeInKilobytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueueDescription;
        });
    }
}

