/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.CoreToCodegenBridgeUtils;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatusImpl;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionImpl;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SubscriptionDescriptionImpl
implements XmlSerializable<SubscriptionDescriptionImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private Duration lockDuration;
    private Boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private Boolean deadLetteringOnMessageExpiration;
    private Boolean deadLetteringOnFilterEvaluationExceptions;
    private Integer messageCount;
    private Integer maxDeliveryCount;
    private Boolean enableBatchedOperations;
    private EntityStatus status;
    private String forwardTo;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private MessageCountDetailsImpl messageCountDetails;
    private String userMetadata;
    private String forwardDeadLetteredMessagesTo;
    private Duration autoDeleteOnIdle;
    private EntityAvailabilityStatusImpl entityAvailabilityStatus;
    private RuleDescriptionImpl defaultRuleDescription;

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public SubscriptionDescriptionImpl setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public Boolean isRequiresSession() {
        return this.requiresSession;
    }

    public SubscriptionDescriptionImpl setRequiresSession(Boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SubscriptionDescriptionImpl setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SubscriptionDescriptionImpl setDeadLetteringOnMessageExpiration(Boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SubscriptionDescriptionImpl setDeadLetteringOnFilterEvaluationExceptions(Boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    public Integer getMessageCount() {
        return this.messageCount;
    }

    public SubscriptionDescriptionImpl setMessageCount(Integer messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public Integer getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SubscriptionDescriptionImpl setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public SubscriptionDescriptionImpl setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public SubscriptionDescriptionImpl setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public SubscriptionDescriptionImpl setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public SubscriptionDescriptionImpl setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public SubscriptionDescriptionImpl setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public SubscriptionDescriptionImpl setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    public MessageCountDetailsImpl getMessageCountDetails() {
        return this.messageCountDetails;
    }

    public SubscriptionDescriptionImpl setMessageCountDetails(MessageCountDetailsImpl messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public SubscriptionDescriptionImpl setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SubscriptionDescriptionImpl setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SubscriptionDescriptionImpl setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public EntityAvailabilityStatusImpl getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public SubscriptionDescriptionImpl setEntityAvailabilityStatus(EntityAvailabilityStatusImpl entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public RuleDescriptionImpl getDefaultRuleDescription() {
        return this.defaultRuleDescription;
    }

    public SubscriptionDescriptionImpl setDefaultRuleDescription(RuleDescriptionImpl defaultRuleDescription) {
        this.defaultRuleDescription = defaultRuleDescription;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SubscriptionDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "LockDuration", CoreToCodegenBridgeUtils.durationToStringWithDays(this.lockDuration));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresSession", this.requiresSession);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive", CoreToCodegenBridgeUtils.durationToStringWithDays(this.defaultMessageTimeToLive));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnMessageExpiration", this.deadLetteringOnMessageExpiration);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DeadLetteringOnFilterEvaluationExceptions", this.deadLetteringOnFilterEvaluationExceptions);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageCount", (Number)this.messageCount);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxDeliveryCount", (Number)this.maxDeliveryCount);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations", this.enableBatchedOperations);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardTo", this.forwardTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt", this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt", this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeXml((XmlSerializable)this.messageCountDetails, "CountDetails");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ForwardDeadLetteredMessagesTo", this.forwardDeadLetteredMessagesTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle", CoreToCodegenBridgeUtils.durationToStringWithDays(this.autoDeleteOnIdle));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus", this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        xmlWriter.writeXml((XmlSerializable)this.defaultRuleDescription, "DefaultRuleDescription");
        return xmlWriter.writeEndElement();
    }

    public static SubscriptionDescriptionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SubscriptionDescriptionImpl.fromXml(xmlReader, null);
    }

    public static SubscriptionDescriptionImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SubscriptionDescription" : rootElementName;
        return (SubscriptionDescriptionImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SubscriptionDescriptionImpl deserializedSubscriptionDescription = new SubscriptionDescriptionImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("LockDuration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.lockDuration = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("RequiresSession".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.requiresSession = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultMessageTimeToLive = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("DeadLetteringOnMessageExpiration".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnMessageExpiration = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DeadLetteringOnFilterEvaluationExceptions".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.deadLetteringOnFilterEvaluationExceptions = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("MessageCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("MaxDeliveryCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.maxDeliveryCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("EnableBatchedOperations".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.enableBatchedOperations = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("Status".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.status = EntityStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("ForwardTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardTo = reader.getStringElement();
                    continue;
                }
                if ("CreatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.createdAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("UpdatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.updatedAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("AccessedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.accessedAt = (OffsetDateTime)reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                    continue;
                }
                if ("CountDetails".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.messageCountDetails = MessageCountDetailsImpl.fromXml(reader, "CountDetails");
                    continue;
                }
                if ("UserMetadata".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.userMetadata = reader.getStringElement();
                    continue;
                }
                if ("ForwardDeadLetteredMessagesTo".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.forwardDeadLetteredMessagesTo = reader.getStringElement();
                    continue;
                }
                if ("AutoDeleteOnIdle".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.autoDeleteOnIdle = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("EntityAvailabilityStatus".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.entityAvailabilityStatus = EntityAvailabilityStatusImpl.fromString(reader.getStringElement());
                    continue;
                }
                if ("DefaultRuleDescription".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescription.defaultRuleDescription = RuleDescriptionImpl.fromXml(reader, "DefaultRuleDescription");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSubscriptionDescription;
        });
    }
}

