/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.NamespacePropertiesEntryContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseAuthorImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLinkImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TitleImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class NamespacePropertiesEntryImpl
implements XmlSerializable<NamespacePropertiesEntryImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private TitleImpl title;
    private OffsetDateTime updated;
    private ResponseAuthorImpl author;
    private ResponseLinkImpl link;
    private NamespacePropertiesEntryContentImpl content;

    public String getId() {
        return this.id;
    }

    public NamespacePropertiesEntryImpl setId(String id) {
        this.id = id;
        return this;
    }

    public TitleImpl getTitle() {
        return this.title;
    }

    public NamespacePropertiesEntryImpl setTitle(TitleImpl title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public NamespacePropertiesEntryImpl setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseAuthorImpl getAuthor() {
        return this.author;
    }

    public NamespacePropertiesEntryImpl setAuthor(ResponseAuthorImpl author) {
        this.author = author;
        return this;
    }

    public ResponseLinkImpl getLink() {
        return this.link;
    }

    public NamespacePropertiesEntryImpl setLink(ResponseLinkImpl link) {
        this.link = link;
        return this;
    }

    public NamespacePropertiesEntryContentImpl getContent() {
        return this.content;
    }

    public NamespacePropertiesEntryImpl setContent(NamespacePropertiesEntryContentImpl content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.author, "author");
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static NamespacePropertiesEntryImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return NamespacePropertiesEntryImpl.fromXml(xmlReader, null);
    }

    public static NamespacePropertiesEntryImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        return (NamespacePropertiesEntryImpl)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            NamespacePropertiesEntryImpl deserializedNamespacePropertiesEntry = new NamespacePropertiesEntryImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.title = TitleImpl.fromXml(reader, "title");
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("author".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.author = ResponseAuthorImpl.fromXml(reader, "author");
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.link = ResponseLinkImpl.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntry.content = NamespacePropertiesEntryContentImpl.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedNamespacePropertiesEntry;
        });
    }
}

