/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class TopicRuntimeProperties {
    private final String name;
    private final int subscriptionCount;
    private final long sizeInBytes;
    private final OffsetDateTime accessedAt;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final int scheduledMessageCount;

    public TopicRuntimeProperties(TopicProperties topicProperties) {
        Objects.requireNonNull(topicProperties, "'topicDescription' cannot be null.");
        this.name = topicProperties.getName();
        this.subscriptionCount = topicProperties.getSubscriptionCount();
        this.sizeInBytes = topicProperties.getSizeInBytes();
        this.accessedAt = topicProperties.getAccessedAt();
        this.createdAt = topicProperties.getCreatedAt();
        this.updatedAt = topicProperties.getUpdatedAt();
        MessageCountDetailsImpl details = topicProperties.getMessageCountDetails();
        this.scheduledMessageCount = details != null ? details.getScheduledMessageCount() : 0;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getName() {
        return this.name;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public int getScheduledMessageCount() {
        return this.scheduledMessageCount;
    }

    public int getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }
}

