// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.models.AccessRights;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Authorization rule of an entity.
 */
@Fluent
public final class AuthorizationRuleImpl implements XmlSerializable<AuthorizationRuleImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE
        = "http://www.w3.org/2001/XMLSchema-instance";

    /*
     * The authorization type.
     */
    private String type;

    /*
     * The claim type.
     */
    private String claimType;

    /*
     * The claim value.
     */
    private String claimValue;

    /*
     * Access rights of the entity. Values are 'Send', 'Listen', or 'Manage'
     */
    private List<AccessRights> rights;

    /*
     * The date and time when the authorization rule was created.
     */
    private OffsetDateTime createdTime;

    /*
     * The date and time when the authorization rule was modified.
     */
    private OffsetDateTime modifiedTime;

    /*
     * The authorization rule key name
     */
    private String keyName;

    /*
     * The primary key of the authorization rule
     */
    private String primaryKey;

    /*
     * The primary key of the authorization rule
     */
    private String secondaryKey;

    /**
     * Creates an instance of AuthorizationRule class.
     */
    public AuthorizationRuleImpl() {
    }

    /**
     * Get the type property: The authorization type.
     * 
     * @return the type value.
     */
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: The authorization type.
     * 
     * @param type the type value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the claimType property: The claim type.
     * 
     * @return the claimType value.
     */
    public String getClaimType() {
        return this.claimType;
    }

    /**
     * Set the claimType property: The claim type.
     * 
     * @param claimType the claimType value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setClaimType(String claimType) {
        this.claimType = claimType;
        return this;
    }

    /**
     * Get the claimValue property: The claim value.
     * 
     * @return the claimValue value.
     */
    public String getClaimValue() {
        return this.claimValue;
    }

    /**
     * Set the claimValue property: The claim value.
     * 
     * @param claimValue the claimValue value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setClaimValue(String claimValue) {
        this.claimValue = claimValue;
        return this;
    }

    /**
     * Get the rights property: Access rights of the entity. Values are 'Send', 'Listen', or 'Manage'.
     * 
     * @return the rights value.
     */
    public List<AccessRights> getRights() {
        if (this.rights == null) {
            this.rights = new ArrayList<>();
        }
        return this.rights;
    }

    /**
     * Set the rights property: Access rights of the entity. Values are 'Send', 'Listen', or 'Manage'.
     * 
     * @param rights the rights value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setRights(List<AccessRights> rights) {
        this.rights = rights;
        return this;
    }

    /**
     * Get the createdTime property: The date and time when the authorization rule was created.
     * 
     * @return the createdTime value.
     */
    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    /**
     * Set the createdTime property: The date and time when the authorization rule was created.
     * 
     * @param createdTime the createdTime value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setCreatedTime(OffsetDateTime createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    /**
     * Get the modifiedTime property: The date and time when the authorization rule was modified.
     * 
     * @return the modifiedTime value.
     */
    public OffsetDateTime getModifiedTime() {
        return this.modifiedTime;
    }

    /**
     * Set the modifiedTime property: The date and time when the authorization rule was modified.
     * 
     * @param modifiedTime the modifiedTime value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setModifiedTime(OffsetDateTime modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    /**
     * Get the keyName property: The authorization rule key name.
     * 
     * @return the keyName value.
     */
    public String getKeyName() {
        return this.keyName;
    }

    /**
     * Set the keyName property: The authorization rule key name.
     * 
     * @param keyName the keyName value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    /**
     * Get the primaryKey property: The primary key of the authorization rule.
     * 
     * @return the primaryKey value.
     */
    public String getPrimaryKey() {
        return this.primaryKey;
    }

    /**
     * Set the primaryKey property: The primary key of the authorization rule.
     * 
     * @param primaryKey the primaryKey value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    /**
     * Get the secondaryKey property: The primary key of the authorization rule.
     * 
     * @return the secondaryKey value.
     */
    public String getSecondaryKey() {
        return this.secondaryKey;
    }

    /**
     * Set the secondaryKey property: The primary key of the authorization rule.
     * 
     * @param secondaryKey the secondaryKey value to set.
     * @return the AuthorizationRule object itself.
     */
    public AuthorizationRuleImpl setSecondaryKey(String secondaryKey) {
        this.secondaryKey = secondaryKey;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "AuthorizationRule" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("i", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ClaimType", this.claimType);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ClaimValue", this.claimValue);
        if (this.rights != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Rights");
            for (AccessRights element : this.rights) {
                xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessRights",
                    element == null ? null : element.toString());
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedTime",
            this.createdTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ModifiedTime",
            this.modifiedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.modifiedTime));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "KeyName", this.keyName);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "PrimaryKey", this.primaryKey);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SecondaryKey", this.secondaryKey);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of AuthorizationRule from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of AuthorizationRule if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the AuthorizationRule.
     */
    public static AuthorizationRuleImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of AuthorizationRule from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of AuthorizationRule if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the AuthorizationRule.
     */
    public static AuthorizationRuleImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "AuthorizationRule" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            AuthorizationRuleImpl deserializedAuthorizationRule = new AuthorizationRuleImpl();
            deserializedAuthorizationRule.type
                = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("ClaimType".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.claimType = reader.getStringElement();
                } else if ("ClaimValue".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.claimValue = reader.getStringElement();
                } else if ("Rights".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AccessRights".equals(elementName.getLocalPart())
                            && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedAuthorizationRule.rights == null) {
                                deserializedAuthorizationRule.rights = new ArrayList<>();
                            }
                            deserializedAuthorizationRule.rights
                                .add(AccessRights.fromString(reader.getStringElement()));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("CreatedTime".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.createdTime
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("ModifiedTime".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.modifiedTime
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("KeyName".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.keyName = reader.getStringElement();
                } else if ("PrimaryKey".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.primaryKey = reader.getStringElement();
                } else if ("SecondaryKey".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedAuthorizationRule.secondaryKey = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedAuthorizationRule;
        });
    }
}
