/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLinkImpl;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntryContentImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TitleImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SubscriptionDescriptionEntryImpl
implements XmlSerializable<SubscriptionDescriptionEntryImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String id;
    private TitleImpl title;
    private OffsetDateTime published;
    private OffsetDateTime updated;
    private ResponseLinkImpl link;
    private SubscriptionDescriptionEntryContentImpl content;

    public String getId() {
        return this.id;
    }

    public SubscriptionDescriptionEntryImpl setId(String id) {
        this.id = id;
        return this;
    }

    public TitleImpl getTitle() {
        return this.title;
    }

    public SubscriptionDescriptionEntryImpl setTitle(TitleImpl title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getPublished() {
        return this.published;
    }

    public SubscriptionDescriptionEntryImpl setPublished(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public SubscriptionDescriptionEntryImpl setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseLinkImpl getLink() {
        return this.link;
    }

    public SubscriptionDescriptionEntryImpl setLink(ResponseLinkImpl link) {
        this.link = link;
        return this;
    }

    public SubscriptionDescriptionEntryContentImpl getContent() {
        return this.content;
    }

    public SubscriptionDescriptionEntryImpl setContent(SubscriptionDescriptionEntryContentImpl content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "published", this.published == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.published));
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static SubscriptionDescriptionEntryImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SubscriptionDescriptionEntryImpl.fromXml(xmlReader, null);
    }

    public static SubscriptionDescriptionEntryImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        return (SubscriptionDescriptionEntryImpl)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            SubscriptionDescriptionEntryImpl deserializedSubscriptionDescriptionEntry = new SubscriptionDescriptionEntryImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.title = TitleImpl.fromXml(reader, "title");
                    continue;
                }
                if ("published".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.published = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.link = ResponseLinkImpl.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedSubscriptionDescriptionEntry.content = SubscriptionDescriptionEntryContentImpl.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedSubscriptionDescriptionEntry;
        });
    }
}

