/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseAuthorImpl;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLinkImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TitleImpl;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntryContentImpl;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TopicDescriptionEntryImpl
implements XmlSerializable<TopicDescriptionEntryImpl> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";
    private String base;
    private String id;
    private TitleImpl title;
    private OffsetDateTime published;
    private OffsetDateTime updated;
    private ResponseAuthorImpl author;
    private ResponseLinkImpl link;
    private TopicDescriptionEntryContentImpl content;

    public String getBase() {
        return this.base;
    }

    public TopicDescriptionEntryImpl setBase(String base) {
        this.base = base;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public TopicDescriptionEntryImpl setId(String id) {
        this.id = id;
        return this;
    }

    public TitleImpl getTitle() {
        return this.title;
    }

    public TopicDescriptionEntryImpl setTitle(TitleImpl title) {
        this.title = title;
        return this;
    }

    public OffsetDateTime getPublished() {
        return this.published;
    }

    public TopicDescriptionEntryImpl setPublished(OffsetDateTime published) {
        this.published = published;
        return this;
    }

    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    public TopicDescriptionEntryImpl setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    public ResponseAuthorImpl getAuthor() {
        return this.author;
    }

    public TopicDescriptionEntryImpl setAuthor(ResponseAuthorImpl author) {
        this.author = author;
        return this;
    }

    public ResponseLinkImpl getLink() {
        return this.link;
    }

    public TopicDescriptionEntryImpl setLink(ResponseLinkImpl link) {
        this.link = link;
        return this;
    }

    public TopicDescriptionEntryContentImpl getContent() {
        return this.content;
    }

    public TopicDescriptionEntryImpl setContent(TopicDescriptionEntryContentImpl content) {
        this.content = content;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("base", this.base);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml((XmlSerializable)this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "published", this.published == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.published));
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated", this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        xmlWriter.writeXml((XmlSerializable)this.author, "author");
        xmlWriter.writeXml((XmlSerializable)this.link, "link");
        xmlWriter.writeXml((XmlSerializable)this.content, "content");
        return xmlWriter.writeEndElement();
    }

    public static TopicDescriptionEntryImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TopicDescriptionEntryImpl.fromXml(xmlReader, null);
    }

    public static TopicDescriptionEntryImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "entry" : rootElementName;
        return (TopicDescriptionEntryImpl)xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            TopicDescriptionEntryImpl deserializedTopicDescriptionEntry = new TopicDescriptionEntryImpl();
            deserializedTopicDescriptionEntry.base = reader.getStringAttribute(null, "base");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("id".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.id = reader.getStringElement();
                    continue;
                }
                if ("title".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.title = TitleImpl.fromXml(reader, "title");
                    continue;
                }
                if ("published".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.published = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("updated".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.updated = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("author".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.author = ResponseAuthorImpl.fromXml(reader, "author");
                    continue;
                }
                if ("link".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.link = ResponseLinkImpl.fromXml(reader, "link");
                    continue;
                }
                if ("content".equals(elementName.getLocalPart()) && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntry.content = TopicDescriptionEntryContentImpl.fromXml(reader, "content");
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTopicDescriptionEntry;
        });
    }
}

