/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.messaging.servicebus.administration.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.administration.implementation.models.EntityAvailabilityStatusImpl;
import com.azure.messaging.servicebus.administration.implementation.models.MessageCountDetailsImpl;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class TopicDescriptionImpl
implements XmlSerializable<TopicDescriptionImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";
    private Duration defaultMessageTimeToLive;
    private Long maxSizeInMegabytes;
    private Boolean requiresDuplicateDetection;
    private Duration duplicateDetectionHistoryTimeWindow;
    private Boolean enableBatchedOperations;
    private Long sizeInBytes;
    private Boolean filteringMessagesBeforePublishing;
    private Boolean isAnonymousAccessible;
    private List<AuthorizationRuleImpl> authorizationRules;
    private EntityStatus status;
    private OffsetDateTime createdAt;
    private OffsetDateTime updatedAt;
    private OffsetDateTime accessedAt;
    private Boolean supportOrdering;
    private MessageCountDetailsImpl messageCountDetails;
    private Integer subscriptionCount;
    private Duration autoDeleteOnIdle;
    private Boolean enablePartitioning;
    private EntityAvailabilityStatusImpl entityAvailabilityStatus;
    private Boolean enableSubscriptionPartitioning;
    private Boolean enableExpress;
    private String userMetadata;
    private Long maxMessageSizeInKilobytes;

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public TopicDescriptionImpl setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public Long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public TopicDescriptionImpl setMaxSizeInMegabytes(Long maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes;
        return this;
    }

    public Boolean isRequiresDuplicateDetection() {
        return this.requiresDuplicateDetection;
    }

    public TopicDescriptionImpl setRequiresDuplicateDetection(Boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public TopicDescriptionImpl setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public Boolean isEnableBatchedOperations() {
        return this.enableBatchedOperations;
    }

    public TopicDescriptionImpl setEnableBatchedOperations(Boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public Long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public TopicDescriptionImpl setSizeInBytes(Long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    public Boolean isFilteringMessagesBeforePublishing() {
        return this.filteringMessagesBeforePublishing;
    }

    public TopicDescriptionImpl setFilteringMessagesBeforePublishing(Boolean filteringMessagesBeforePublishing) {
        this.filteringMessagesBeforePublishing = filteringMessagesBeforePublishing;
        return this;
    }

    public Boolean isAnonymousAccessible() {
        return this.isAnonymousAccessible;
    }

    public TopicDescriptionImpl setIsAnonymousAccessible(Boolean isAnonymousAccessible) {
        this.isAnonymousAccessible = isAnonymousAccessible;
        return this;
    }

    public List<AuthorizationRuleImpl> getAuthorizationRules() {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRuleImpl>();
        }
        return this.authorizationRules;
    }

    public TopicDescriptionImpl setAuthorizationRules(List<AuthorizationRuleImpl> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public TopicDescriptionImpl setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public TopicDescriptionImpl setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public TopicDescriptionImpl setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    public TopicDescriptionImpl setAccessedAt(OffsetDateTime accessedAt) {
        this.accessedAt = accessedAt;
        return this;
    }

    public Boolean isSupportOrdering() {
        return this.supportOrdering;
    }

    public TopicDescriptionImpl setSupportOrdering(Boolean supportOrdering) {
        this.supportOrdering = supportOrdering;
        return this;
    }

    public MessageCountDetailsImpl getMessageCountDetails() {
        return this.messageCountDetails;
    }

    public TopicDescriptionImpl setMessageCountDetails(MessageCountDetailsImpl messageCountDetails) {
        this.messageCountDetails = messageCountDetails;
        return this;
    }

    public Integer getSubscriptionCount() {
        return this.subscriptionCount;
    }

    public TopicDescriptionImpl setSubscriptionCount(Integer subscriptionCount) {
        this.subscriptionCount = subscriptionCount;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public TopicDescriptionImpl setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public Boolean isEnablePartitioning() {
        return this.enablePartitioning;
    }

    public TopicDescriptionImpl setEnablePartitioning(Boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    public EntityAvailabilityStatusImpl getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    public TopicDescriptionImpl setEntityAvailabilityStatus(EntityAvailabilityStatusImpl entityAvailabilityStatus) {
        this.entityAvailabilityStatus = entityAvailabilityStatus;
        return this;
    }

    public Boolean isEnableSubscriptionPartitioning() {
        return this.enableSubscriptionPartitioning;
    }

    public TopicDescriptionImpl setEnableSubscriptionPartitioning(Boolean enableSubscriptionPartitioning) {
        this.enableSubscriptionPartitioning = enableSubscriptionPartitioning;
        return this;
    }

    public Boolean isEnableExpress() {
        return this.enableExpress;
    }

    public TopicDescriptionImpl setEnableExpress(Boolean enableExpress) {
        this.enableExpress = enableExpress;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public TopicDescriptionImpl setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public Long getMaxMessageSizeInKilobytes() {
        return this.maxMessageSizeInKilobytes;
    }

    public TopicDescriptionImpl setMaxMessageSizeInKilobytes(Long maxMessageSizeInKilobytes) {
        this.maxMessageSizeInKilobytes = maxMessageSizeInKilobytes;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "TopicDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DefaultMessageTimeToLive", CoreUtils.durationToStringWithDays((Duration)this.defaultMessageTimeToLive));
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxSizeInMegabytes", (Number)this.maxSizeInMegabytes);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresDuplicateDetection", this.requiresDuplicateDetection);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "DuplicateDetectionHistoryTimeWindow", CoreUtils.durationToStringWithDays((Duration)this.duplicateDetectionHistoryTimeWindow));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableBatchedOperations", this.enableBatchedOperations);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SizeInBytes", (Number)this.sizeInBytes);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "FilteringMessagesBeforePublishing", this.filteringMessagesBeforePublishing);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "IsAnonymousAccessible", this.isAnonymousAccessible);
        if (this.authorizationRules != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AuthorizationRules");
            for (AuthorizationRuleImpl element : this.authorizationRules) {
                xmlWriter.writeXml((XmlSerializable)element, "AuthorizationRule");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Status", this.status == null ? null : this.status.toString());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt", this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UpdatedAt", this.updatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updatedAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AccessedAt", this.accessedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.accessedAt));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SupportOrdering", this.supportOrdering);
        xmlWriter.writeXml((XmlSerializable)this.messageCountDetails, "CountDetails");
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SubscriptionCount", (Number)this.subscriptionCount);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "AutoDeleteOnIdle", CoreUtils.durationToStringWithDays((Duration)this.autoDeleteOnIdle));
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnablePartitioning", this.enablePartitioning);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EntityAvailabilityStatus", this.entityAvailabilityStatus == null ? null : this.entityAvailabilityStatus.toString());
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableSubscriptionPartitioning", this.enableSubscriptionPartitioning);
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "EnableExpress", this.enableExpress);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "UserMetadata", this.userMetadata);
        xmlWriter.writeNumberElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MaxMessageSizeInKilobytes", (Number)this.maxMessageSizeInKilobytes);
        return xmlWriter.writeEndElement();
    }

    public static TopicDescriptionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return TopicDescriptionImpl.fromXml(xmlReader, null);
    }

    public static TopicDescriptionImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "TopicDescription" : rootElementName;
        return (TopicDescriptionImpl)xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            TopicDescriptionImpl deserializedTopicDescription = new TopicDescriptionImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("DefaultMessageTimeToLive".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.defaultMessageTimeToLive = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("MaxSizeInMegabytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.maxSizeInMegabytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("RequiresDuplicateDetection".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.requiresDuplicateDetection = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("DuplicateDetectionHistoryTimeWindow".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.duplicateDetectionHistoryTimeWindow = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("EnableBatchedOperations".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.enableBatchedOperations = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("SizeInBytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.sizeInBytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                if ("FilteringMessagesBeforePublishing".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.filteringMessagesBeforePublishing = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("IsAnonymousAccessible".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.isAnonymousAccessible = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("AuthorizationRules".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("AuthorizationRule".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedTopicDescription.authorizationRules == null) {
                                deserializedTopicDescription.authorizationRules = new ArrayList<AuthorizationRuleImpl>();
                            }
                            deserializedTopicDescription.authorizationRules.add(AuthorizationRuleImpl.fromXml(reader, "AuthorizationRule"));
                            continue;
                        }
                        reader.skipElement();
                    }
                    continue;
                }
                if ("Status".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.status = EntityStatus.fromString(reader.getStringElement());
                    continue;
                }
                if ("CreatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.createdAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("UpdatedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.updatedAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("AccessedAt".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.accessedAt = (OffsetDateTime)reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime((String)dateString));
                    continue;
                }
                if ("SupportOrdering".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.supportOrdering = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("CountDetails".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.messageCountDetails = MessageCountDetailsImpl.fromXml(reader, "CountDetails");
                    continue;
                }
                if ("SubscriptionCount".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.subscriptionCount = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("AutoDeleteOnIdle".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.autoDeleteOnIdle = (Duration)reader.getNullableElement(Duration::parse);
                    continue;
                }
                if ("EnablePartitioning".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.enablePartitioning = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("EntityAvailabilityStatus".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.entityAvailabilityStatus = EntityAvailabilityStatusImpl.fromString(reader.getStringElement());
                    continue;
                }
                if ("EnableSubscriptionPartitioning".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.enableSubscriptionPartitioning = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("EnableExpress".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.enableExpress = (Boolean)reader.getNullableElement(Boolean::parseBoolean);
                    continue;
                }
                if ("UserMetadata".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.userMetadata = reader.getStringElement();
                    continue;
                }
                if ("MaxMessageSizeInKilobytes".equals(elementName.getLocalPart()) && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescription.maxMessageSizeInKilobytes = (Long)reader.getNullableElement(Long::parseLong);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedTopicDescription;
        });
    }
}

