// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The SqlRuleAction model.
 */
@Fluent
public final class SqlRuleAction extends RuleAction {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE
        = "http://www.w3.org/2001/XMLSchema-instance";

    /*
     * The type property.
     */
    @Generated
    private String type = "SqlRuleAction";

    /*
     * The sqlExpression property.
     */
    @Generated
    private String sqlExpression;

    /*
     * The compatibilityLevel property.
     */
    @Generated
    private String compatibilityLevel;

    /*
     * The parameters property.
     */
    @Generated
    private List<KeyValue> parameters;

    /*
     * The requiresPreprocessing property.
     */
    @Generated
    private Boolean requiresPreprocessing;

    /**
     * Creates an instance of SqlRuleAction class.
     */
    @Generated
    public SqlRuleAction() {
    }

    /**
     * Get the type property: The type property.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the sqlExpression property: The sqlExpression property.
     * 
     * @return the sqlExpression value.
     */
    @Generated
    public String getSqlExpression() {
        return this.sqlExpression;
    }

    /**
     * Set the sqlExpression property: The sqlExpression property.
     * 
     * @param sqlExpression the sqlExpression value to set.
     * @return the SqlRuleAction object itself.
     */
    @Generated
    public SqlRuleAction setSqlExpression(String sqlExpression) {
        this.sqlExpression = sqlExpression;
        return this;
    }

    /**
     * Get the compatibilityLevel property: The compatibilityLevel property.
     * 
     * @return the compatibilityLevel value.
     */
    @Generated
    public String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    /**
     * Set the compatibilityLevel property: The compatibilityLevel property.
     * 
     * @param compatibilityLevel the compatibilityLevel value to set.
     * @return the SqlRuleAction object itself.
     */
    @Generated
    public SqlRuleAction setCompatibilityLevel(String compatibilityLevel) {
        this.compatibilityLevel = compatibilityLevel;
        return this;
    }

    /**
     * Get the parameters property: The parameters property.
     * 
     * @return the parameters value.
     */
    @Generated
    public List<KeyValue> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<>();
        }
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters property.
     * 
     * @param parameters the parameters value to set.
     * @return the SqlRuleAction object itself.
     */
    @Generated
    public SqlRuleAction setParameters(List<KeyValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the requiresPreprocessing property: The requiresPreprocessing property.
     * 
     * @return the requiresPreprocessing value.
     */
    @Generated
    public Boolean isRequiresPreprocessing() {
        return this.requiresPreprocessing;
    }

    /**
     * Set the requiresPreprocessing property: The requiresPreprocessing property.
     * 
     * @param requiresPreprocessing the requiresPreprocessing value to set.
     * @return the SqlRuleAction object itself.
     */
    @Generated
    public SqlRuleAction setRequiresPreprocessing(Boolean requiresPreprocessing) {
        this.requiresPreprocessing = requiresPreprocessing;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "Action" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", this.sqlExpression);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel",
            this.compatibilityLevel);
        if (this.parameters != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValue element : this.parameters) {
                xmlWriter.writeXml(element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing",
            this.requiresPreprocessing);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of SqlRuleAction from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of SqlRuleAction if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the SqlRuleAction.
     */
    @Generated
    public static SqlRuleAction fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of SqlRuleAction from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of SqlRuleAction if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the SqlRuleAction.
     */
    @Generated
    public static SqlRuleAction fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "Action" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            SqlRuleAction deserializedSqlRuleAction = new SqlRuleAction();
            String discriminatorValue
                = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"SqlRuleAction".equals(discriminatorValue)) {
                throw new IllegalStateException(
                    "'type' was expected to be non-null and equal to 'SqlRuleAction'. The found 'type' was '"
                        + discriminatorValue + "'.");
            }
            deserializedSqlRuleAction.type = discriminatorValue;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SqlExpression".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.sqlExpression = reader.getStringElement();
                } else if ("CompatibilityLevel".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.compatibilityLevel = reader.getStringElement();
                } else if ("Parameters".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart())
                            && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedSqlRuleAction.parameters == null) {
                                deserializedSqlRuleAction.parameters = new ArrayList<>();
                            }
                            deserializedSqlRuleAction.parameters
                                .add(KeyValue.fromXml(reader, "KeyValueOfstringanyType"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("RequiresPreprocessing".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedSqlRuleAction.requiresPreprocessing = reader.getNullableElement(Boolean::parseBoolean);
                } else {
                    reader.skipElement();
                }
            }

            return deserializedSqlRuleAction;
        });
    }
}
