// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The TopicDescription.
 */
@Fluent
public final class TopicDescriptionEntryContent implements XmlSerializable<TopicDescriptionEntryContent> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * Type of content in topic response
     */
    @Generated
    private String type;

    /*
     * Description of a Service Bus topic resource.
     */
    @Generated
    private TopicDescription topicDescription;

    /**
     * Creates an instance of TopicDescriptionEntryContent class.
     */
    @Generated
    public TopicDescriptionEntryContent() {
    }

    /**
     * Get the type property: Type of content in topic response.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of content in topic response.
     * 
     * @param type the type value to set.
     * @return the TopicDescriptionEntryContent object itself.
     */
    @Generated
    public TopicDescriptionEntryContent setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the topicDescription property: Description of a Service Bus topic resource.
     * 
     * @return the topicDescription value.
     */
    @Generated
    public TopicDescription getTopicDescription() {
        return this.topicDescription;
    }

    /**
     * Set the topicDescription property: Description of a Service Bus topic resource.
     * 
     * @param topicDescription the topicDescription value to set.
     * @return the TopicDescriptionEntryContent object itself.
     */
    @Generated
    public TopicDescriptionEntryContent setTopicDescription(TopicDescription topicDescription) {
        this.topicDescription = topicDescription;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "TopicDescriptionEntryContent" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.topicDescription, "TopicDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of TopicDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of TopicDescriptionEntryContent if the XmlReader was pointing to an instance of it, or null
     * if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TopicDescriptionEntryContent.
     */
    @Generated
    public static TopicDescriptionEntryContent fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of TopicDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of TopicDescriptionEntryContent if the XmlReader was pointing to an instance of it, or null
     * if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the TopicDescriptionEntryContent.
     */
    @Generated
    public static TopicDescriptionEntryContent fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "TopicDescriptionEntryContent" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            TopicDescriptionEntryContent deserializedTopicDescriptionEntryContent = new TopicDescriptionEntryContent();
            deserializedTopicDescriptionEntryContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("TopicDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedTopicDescriptionEntryContent.topicDescription
                        = TopicDescription.fromXml(reader, "TopicDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedTopicDescriptionEntryContent;
        });
    }
}
