// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Response from listing Service Bus queues.
 */
@Fluent
public final class QueueDescriptionFeed implements XmlSerializable<QueueDescriptionFeed> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    /*
     * URL of the list queues query.
     */
    @Generated
    private String id;

    /*
     * The entity type for the feed.
     */
    @Generated
    private Title title;

    /*
     * Datetime of the query.
     */
    @Generated
    private OffsetDateTime updated;

    /*
     * Links to paginated response.
     */
    @Generated
    private List<ResponseLink> link = new ArrayList<>();

    /*
     * Queue entries.
     */
    @Generated
    private List<QueueDescriptionEntry> entry = new ArrayList<>();

    /**
     * Creates an instance of QueueDescriptionFeed class.
     */
    @Generated
    public QueueDescriptionFeed() {
    }

    /**
     * Get the id property: URL of the list queues query.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: URL of the list queues query.
     * 
     * @param id the id value to set.
     * @return the QueueDescriptionFeed object itself.
     */
    @Generated
    public QueueDescriptionFeed setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the title property: The entity type for the feed.
     * 
     * @return the title value.
     */
    @Generated
    public Title getTitle() {
        return this.title;
    }

    /**
     * Set the title property: The entity type for the feed.
     * 
     * @param title the title value to set.
     * @return the QueueDescriptionFeed object itself.
     */
    @Generated
    public QueueDescriptionFeed setTitle(Title title) {
        this.title = title;
        return this;
    }

    /**
     * Get the updated property: Datetime of the query.
     * 
     * @return the updated value.
     */
    @Generated
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    /**
     * Set the updated property: Datetime of the query.
     * 
     * @param updated the updated value to set.
     * @return the QueueDescriptionFeed object itself.
     */
    @Generated
    public QueueDescriptionFeed setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    /**
     * Get the link property: Links to paginated response.
     * 
     * @return the link value.
     */
    @Generated
    public List<ResponseLink> getLink() {
        return this.link;
    }

    /**
     * Set the link property: Links to paginated response.
     * 
     * @param link the link value to set.
     * @return the QueueDescriptionFeed object itself.
     */
    @Generated
    public QueueDescriptionFeed setLink(List<ResponseLink> link) {
        this.link = link;
        return this;
    }

    /**
     * Get the entry property: Queue entries.
     * 
     * @return the entry value.
     */
    @Generated
    public List<QueueDescriptionEntry> getEntry() {
        return this.entry;
    }

    /**
     * Set the entry property: Queue entries.
     * 
     * @param entry the entry value to set.
     * @return the QueueDescriptionFeed object itself.
     */
    @Generated
    public QueueDescriptionFeed setEntry(List<QueueDescriptionEntry> entry) {
        this.entry = entry;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "id", this.id);
        xmlWriter.writeXml(this.title, "title");
        xmlWriter.writeStringElement(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, "updated",
            this.updated == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.updated));
        if (this.link != null) {
            for (ResponseLink element : this.link) {
                xmlWriter.writeXml(element, "link");
            }
        }
        if (this.entry != null) {
            for (QueueDescriptionEntry element : this.entry) {
                xmlWriter.writeXml(element, "entry");
            }
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of QueueDescriptionFeed from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of QueueDescriptionFeed if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueDescriptionFeed.
     */
    @Generated
    public static QueueDescriptionFeed fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of QueueDescriptionFeed from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of QueueDescriptionFeed if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the QueueDescriptionFeed.
     */
    @Generated
    public static QueueDescriptionFeed fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty() ? "feed" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            QueueDescriptionFeed deserializedQueueDescriptionFeed = new QueueDescriptionFeed();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("id".equals(elementName.getLocalPart())
                    && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescriptionFeed.id = reader.getStringElement();
                } else if ("title".equals(elementName.getLocalPart())
                    && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescriptionFeed.title = Title.fromXml(reader, "title");
                } else if ("updated".equals(elementName.getLocalPart())
                    && WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM.equals(elementName.getNamespaceURI())) {
                    deserializedQueueDescriptionFeed.updated
                        = reader.getNullableElement(dateString -> CoreUtils.parseBestOffsetDateTime(dateString));
                } else if ("link".equals(elementName.getLocalPart())) {
                    deserializedQueueDescriptionFeed.link.add(ResponseLink.fromXml(reader, "link"));
                } else if ("entry".equals(elementName.getLocalPart())) {
                    deserializedQueueDescriptionFeed.entry.add(QueueDescriptionEntry.fromXml(reader, "entry"));
                } else {
                    reader.skipElement();
                }
            }

            return deserializedQueueDescriptionFeed;
        });
    }
}
