// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The RuleDescription.
 */
@Fluent
public final class RuleDescriptionEntryContent implements XmlSerializable<RuleDescriptionEntryContent> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * Type of content in rule response
     */
    @Generated
    private String type;

    /*
     * The RuleDescription property.
     */
    @Generated
    private RuleDescription ruleDescription;

    /**
     * Creates an instance of RuleDescriptionEntryContent class.
     */
    @Generated
    public RuleDescriptionEntryContent() {
    }

    /**
     * Get the type property: Type of content in rule response.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of content in rule response.
     * 
     * @param type the type value to set.
     * @return the RuleDescriptionEntryContent object itself.
     */
    @Generated
    public RuleDescriptionEntryContent setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the ruleDescription property: The RuleDescription property.
     * 
     * @return the ruleDescription value.
     */
    @Generated
    public RuleDescription getRuleDescription() {
        return this.ruleDescription;
    }

    /**
     * Set the ruleDescription property: The RuleDescription property.
     * 
     * @param ruleDescription the ruleDescription value to set.
     * @return the RuleDescriptionEntryContent object itself.
     */
    @Generated
    public RuleDescriptionEntryContent setRuleDescription(RuleDescription ruleDescription) {
        this.ruleDescription = ruleDescription;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "RuleDescriptionEntryContent" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.ruleDescription, "RuleDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of RuleDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of RuleDescriptionEntryContent if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the RuleDescriptionEntryContent.
     */
    @Generated
    public static RuleDescriptionEntryContent fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of RuleDescriptionEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of RuleDescriptionEntryContent if the XmlReader was pointing to an instance of it, or null if
     * it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the RuleDescriptionEntryContent.
     */
    @Generated
    public static RuleDescriptionEntryContent fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "RuleDescriptionEntryContent" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            RuleDescriptionEntryContent deserializedRuleDescriptionEntryContent = new RuleDescriptionEntryContent();
            deserializedRuleDescriptionEntryContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("RuleDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescriptionEntryContent.ruleDescription
                        = RuleDescription.fromXml(reader, "RuleDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedRuleDescriptionEntryContent;
        });
    }
}
