/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.IterableStream;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.implementation.EntityHelper;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateQueueBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateRuleBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateSubscriptionBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBody;
import com.azure.messaging.servicebus.administration.implementation.models.CreateTopicBodyContent;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.administration.implementation.models.RuleAction;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.RuleFilter;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementError;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescription;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescription;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.administration.implementation.models.TopicDescriptionFeed;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class AdministrationModelConverter {
    static final String CONTENT_TYPE = "application/xml";
    private final ClientLogger logger;
    private final String serviceBusNamespace;

    AdministrationModelConverter(ClientLogger logger, String serviceBusNamespace) {
        this.logger = logger;
        this.serviceBusNamespace = serviceBusNamespace;
    }

    void addSupplementaryAuthHeader(HttpHeaderName headerName, String entity, Context context) {
        context.getData((Object)"azure-http-headers-key").ifPresent(headers -> {
            if (headers instanceof HttpHeaders) {
                HttpHeaders customHttpHeaders = (HttpHeaders)headers;
                customHttpHeaders.add(headerName, entity);
            }
        });
    }

    CreateQueueBody getCreateQueueBody(QueueDescription queueDescription) {
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(queueDescription);
        return new CreateQueueBody().setContent(content);
    }

    CreateQueueBody getCreateQueueBody(CreateQueueOptions createQueueOptions, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(createQueueOptions.getForwardTo(), context);
        if (forwardTo != null) {
            createQueueOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(createQueueOptions.getForwardDeadLetteredMessagesTo(), context)) != null) {
            createQueueOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        return this.getCreateQueueBody(EntityHelper.getQueueDescription(createQueueOptions));
    }

    CreateRuleBody getCreateRuleBody(String ruleName, CreateRuleOptions ruleOptions) {
        RuleAction action = ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null;
        RuleFilter filter = ruleOptions.getFilter() != null ? EntityHelper.toImplementation(ruleOptions.getFilter()) : null;
        RuleDescription rule = new RuleDescription().setAction(action).setFilter(filter).setName(ruleName);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(rule);
        return new CreateRuleBody().setContent(content);
    }

    CreateSubscriptionBody getCreateSubscriptionBody(SubscriptionDescription subscriptionDescription) {
        CreateSubscriptionBodyContent content = new CreateSubscriptionBodyContent().setType(CONTENT_TYPE).setSubscriptionDescription(subscriptionDescription);
        return new CreateSubscriptionBody().setContent(content);
    }

    CreateSubscriptionBody getCreateSubscriptionBody(CreateSubscriptionOptions subscriptionOptions, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(subscriptionOptions.getForwardTo(), context);
        if (forwardTo != null) {
            subscriptionOptions.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscriptionOptions.getForwardDeadLetteredMessagesTo(), context)) != null) {
            subscriptionOptions.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        if (ruleOptions != null) {
            if (ruleOptions.getFilter() == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'RuleFilter' cannot be null."));
            }
            RuleDescription rule = new RuleDescription().setAction(ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null).setFilter(EntityHelper.toImplementation(ruleOptions.getFilter())).setName(ruleName);
            subscriptionOptions.setDefaultRule(EntityHelper.toModel(rule));
        }
        return this.getCreateSubscriptionBody(EntityHelper.getSubscriptionDescription(subscriptionOptions));
    }

    CreateTopicBody getCreateTopicBody(TopicDescription topicOptions) {
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(topicOptions);
        return new CreateTopicBody().setContent(content);
    }

    CreateQueueBody getUpdateQueueBody(QueueProperties queue, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(queue.getForwardTo(), context);
        if (forwardTo != null) {
            queue.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(queue.getForwardDeadLetteredMessagesTo(), context)) != null) {
            queue.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        return this.getCreateQueueBody(EntityHelper.toImplementation(queue));
    }

    CreateRuleBody getUpdateRuleBody(RuleProperties rule) {
        RuleDescription implementation = EntityHelper.toImplementation(rule);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(implementation);
        return new CreateRuleBody().setContent(content);
    }

    CreateSubscriptionBody getUpdateSubscriptionBody(SubscriptionProperties subscription, Context context) {
        String forwardDlq;
        String forwardTo = this.getForwardToEntity(subscription.getForwardTo(), context);
        if (forwardTo != null) {
            subscription.setForwardTo(forwardTo);
        }
        if ((forwardDlq = this.getForwardDlqEntity(subscription.getForwardDeadLetteredMessagesTo(), context)) != null) {
            subscription.setForwardDeadLetteredMessagesTo(forwardDlq);
        }
        SubscriptionDescription implementation = EntityHelper.toImplementation(subscription).setDefaultMessageTimeToLive(null).setMessageCount(null).setCreatedAt(null).setUpdatedAt(null).setAccessedAt(null).setMessageCountDetails(null).setEntityAvailabilityStatus(null);
        return this.getCreateSubscriptionBody(implementation);
    }

    CreateTopicBody getUpdateTopicBody(TopicProperties topic) {
        TopicDescription implementation = EntityHelper.toImplementation(topic);
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(implementation);
        return new CreateTopicBody().setContent(content);
    }

    List<TopicProperties> getTopics(TopicDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getTopicDescription() != null).map(e -> this.getTopicProperties((TopicDescriptionEntry)e)).collect(Collectors.toList());
    }

    List<QueueProperties> getQueues(QueueDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getQueueDescription() != null).map(e -> this.getQueueProperties((QueueDescriptionEntry)e)).collect(Collectors.toList());
    }

    List<RuleProperties> getRules(RuleDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getRuleDescription() != null).map(e -> EntityHelper.toModel(e.getContent().getRuleDescription())).collect(Collectors.toList());
    }

    List<SubscriptionProperties> getSubscriptions(String topicName, SubscriptionDescriptionFeed feed) {
        return feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getSubscriptionDescription() != null).map(e -> this.getSubscriptionProperties(topicName, (SubscriptionDescriptionEntry)e)).collect(Collectors.toList());
    }

    QueueProperties getQueueProperties(QueueDescriptionEntry e) {
        String queueName = e.getTitle().getContent();
        QueueProperties queueProperties = EntityHelper.toModel(e.getContent().getQueueDescription());
        EntityHelper.setQueueName(queueProperties, queueName);
        return queueProperties;
    }

    SubscriptionProperties getSubscriptionProperties(String topicName, SubscriptionDescriptionEntry entry) {
        SubscriptionProperties subscription = EntityHelper.toModel(entry.getContent().getSubscriptionDescription());
        String subscriptionName = entry.getTitle().getContent();
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return subscription;
    }

    TopicProperties getTopicProperties(TopicDescriptionEntry entry) {
        TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
        String topicName = entry.getTitle().getContent();
        EntityHelper.setTopicName(result, topicName);
        return result;
    }

    SimpleResponse<SubscriptionProperties> getSubscriptionPropertiesSimpleResponse(String topicName, Response<SubscriptionDescriptionEntry> response) {
        SubscriptionDescriptionEntry entry = (SubscriptionDescriptionEntry)response.getValue();
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        SubscriptionProperties subscription = this.getSubscriptionProperties(topicName, entry);
        String subscriptionName = entry.getTitle().getContent();
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)subscription);
    }

    SimpleResponse<RuleProperties> getRulePropertiesSimpleResponse(Response<RuleDescriptionEntry> response) {
        RuleDescriptionEntry entry = (RuleDescriptionEntry)response.getValue();
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        RuleDescription description = entry.getContent().getRuleDescription();
        RuleProperties result = EntityHelper.toModel(description);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    void validateQueueName(String queueName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)queueName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'queueName' cannot be null or empty."));
        }
    }

    void validateRuleName(String ruleName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)ruleName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'ruleName' cannot be null or empty."));
        }
    }

    void validateTopicName(String topicName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)topicName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'topicName' cannot be null or empty."));
        }
    }

    void validateSubscriptionName(String subscriptionName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)subscriptionName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be null or empty."));
        }
    }

    Response<QueueProperties> deserializeQueue(Response<Object> response) {
        return EntityHelper.deserializeQueue(response, this.logger);
    }

    Response<QueueDescriptionFeed> deserializeQueueFeed(Response<Object> response) {
        return EntityHelper.deserializeQueueFeed(response, this.logger);
    }

    Response<TopicProperties> deserializeTopic(Response<Object> response) {
        return EntityHelper.deserializeTopic(response, this.logger);
    }

    Response<TopicDescriptionFeed> deserializeTopicFeed(Response<Object> response) {
        return EntityHelper.deserializeTopicFeed(response, this.logger);
    }

    Context getContext(Context context) {
        context = context == null ? Context.NONE : context;
        return context.addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
    }

    String getAbsoluteUrlFromEntity(String entity) {
        try {
            URL url = new URL(entity);
            return url.toString();
        }
        catch (MalformedURLException url) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setHost(this.serviceBusNamespace);
            urlBuilder.setPath(entity);
            try {
                URL url2 = urlBuilder.toUrl();
                return url2.toString();
            }
            catch (MalformedURLException ex) {
                this.logger.error("Failed to construct URL using the endpoint:'{}' and entity:'{}'", new Object[]{this.serviceBusNamespace, entity});
                this.logger.logThrowableAsError((Throwable)ex);
                return null;
            }
        }
    }

    private String getForwardDlqEntity(String forwardDlqToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardDlqToEntity)) {
            this.addSupplementaryAuthHeader(ServiceBusConstants.SERVICE_BUS_DLQ_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, forwardDlqToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardDlqToEntity);
        }
        return null;
    }

    private String getForwardToEntity(String forwardToEntity, Context contextWithHeaders) {
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader(ServiceBusConstants.SERVICE_BUS_SUPPLEMENTARY_AUTHORIZATION_HEADER_NAME, forwardToEntity, contextWithHeaders);
            return this.getAbsoluteUrlFromEntity(forwardToEntity);
        }
        return null;
    }

    static Throwable mapException(Throwable exception) {
        if (!(exception instanceof ServiceBusManagementErrorException)) {
            return exception;
        }
        return AdministrationModelConverter.mapException((ServiceBusManagementErrorException)((Object)exception));
    }

    static RuntimeException mapException(ServiceBusManagementErrorException exception) {
        ServiceBusManagementError error = exception.getValue();
        HttpResponse errorHttpResponse = exception.getResponse();
        int statusCode = error != null && error.getCode() != null ? error.getCode().intValue() : errorHttpResponse.getStatusCode();
        String errorDetail = error != null && error.getDetail() != null ? error.getDetail() : exception.getMessage();
        switch (statusCode) {
            case 401: {
                return new ClientAuthenticationException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 404: {
                return new ResourceNotFoundException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 409: {
                return new ResourceExistsException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
            case 412: {
                return new ResourceModifiedException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
            }
        }
        return new HttpResponseException(errorDetail, errorHttpResponse, (Throwable)((Object)exception));
    }

    <TResult, TFeed> FeedPage<TResult> extractPage(Response<TFeed> response, List<TResult> entities, List<ResponseLink> responseLinks) throws MalformedURLException, UnsupportedEncodingException {
        Optional<ResponseLink> nextLink = responseLinks.stream().filter(link -> link.getRel().equalsIgnoreCase("next")).findFirst();
        if (!nextLink.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
        }
        URL url = new URL(nextLink.get().getHref());
        String decode = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.toString());
        Optional<Integer> skipParameter = Arrays.stream(decode.split("&amp;|&")).map(part -> part.split("=", 2)).filter(parts -> parts[0].equalsIgnoreCase("$skip") && ((String[])parts).length == 2).map(parts -> Integer.valueOf(parts[1])).findFirst();
        if (skipParameter.isPresent()) {
            return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities, skipParameter.get());
        }
        this.logger.warning("There should have been a skip parameter for the next page.");
        return new FeedPage<TResult>(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
    }

    static final class FeedPage<T>
    implements PagedResponse<T> {
        private final int statusCode;
        private final HttpHeaders header;
        private final HttpRequest request;
        private final IterableStream<T> entries;
        private final String continuationToken;

        FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = null;
        }

        FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries, int skip) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = String.valueOf(skip);
        }

        public IterableStream<T> getElements() {
            return this.entries;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.header;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void close() {
        }
    }

    static final class EntityNotFoundHttpResponse<T>
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;

        EntityNotFoundHttpResponse(Response<T> response) {
            super(response.getRequest());
            this.headers = response.getHeaders();
            this.statusCode = response.getStatusCode();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    }
}

