// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * QueueDescription for the new queue.
 */
@Fluent
public final class CreateQueueBodyContent implements XmlSerializable<CreateQueueBodyContent> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * MIME type of content.
     */
    @Generated
    private String type;

    /*
     * Properties of the new queue.
     */
    @Generated
    private QueueDescription queueDescription;

    /**
     * Creates an instance of CreateQueueBodyContent class.
     */
    @Generated
    public CreateQueueBodyContent() {
    }

    /**
     * Get the type property: MIME type of content.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: MIME type of content.
     * 
     * @param type the type value to set.
     * @return the CreateQueueBodyContent object itself.
     */
    @Generated
    public CreateQueueBodyContent setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the queueDescription property: Properties of the new queue.
     * 
     * @return the queueDescription value.
     */
    @Generated
    public QueueDescription getQueueDescription() {
        return this.queueDescription;
    }

    /**
     * Set the queueDescription property: Properties of the new queue.
     * 
     * @param queueDescription the queueDescription value to set.
     * @return the CreateQueueBodyContent object itself.
     */
    @Generated
    public CreateQueueBodyContent setQueueDescription(QueueDescription queueDescription) {
        this.queueDescription = queueDescription;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "CreateQueueBodyContent" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.queueDescription, "QueueDescription");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of CreateQueueBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of CreateQueueBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateQueueBodyContent.
     */
    @Generated
    public static CreateQueueBodyContent fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of CreateQueueBodyContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of CreateQueueBodyContent if the XmlReader was pointing to an instance of it, or null if it
     * was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the CreateQueueBodyContent.
     */
    @Generated
    public static CreateQueueBodyContent fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName
            = rootElementName == null || rootElementName.isEmpty() ? "CreateQueueBodyContent" : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            CreateQueueBodyContent deserializedCreateQueueBodyContent = new CreateQueueBodyContent();
            deserializedCreateQueueBodyContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("QueueDescription".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCreateQueueBodyContent.queueDescription
                        = QueueDescription.fromXml(reader, "QueueDescription");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedCreateQueueBodyContent;
        });
    }
}
