// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Information about the namespace.
 */
@Fluent
public final class NamespacePropertiesEntryContent implements XmlSerializable<NamespacePropertiesEntryContent> {
    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM = "http://www.w3.org/2005/Atom";

    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * Type of content in namespace info response
     */
    @Generated
    private String type;

    /*
     * The metadata related to a Service Bus namespace.
     */
    @Generated
    private NamespaceProperties namespaceProperties;

    /**
     * Creates an instance of NamespacePropertiesEntryContent class.
     */
    @Generated
    public NamespacePropertiesEntryContent() {
    }

    /**
     * Get the type property: Type of content in namespace info response.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Set the type property: Type of content in namespace info response.
     * 
     * @param type the type value to set.
     * @return the NamespacePropertiesEntryContent object itself.
     */
    @Generated
    public NamespacePropertiesEntryContent setType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the namespaceProperties property: The metadata related to a Service Bus namespace.
     * 
     * @return the namespaceProperties value.
     */
    @Generated
    public NamespaceProperties getNamespaceProperties() {
        return this.namespaceProperties;
    }

    /**
     * Set the namespaceProperties property: The metadata related to a Service Bus namespace.
     * 
     * @param namespaceProperties the namespaceProperties value to set.
     * @return the NamespacePropertiesEntryContent object itself.
     */
    @Generated
    public NamespacePropertiesEntryContent setNamespaceProperties(NamespaceProperties namespaceProperties) {
        this.namespaceProperties = namespaceProperties;
        return this;
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Generated
    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = rootElementName == null || rootElementName.isEmpty()
            ? "NamespacePropertiesEntryContent"
            : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM);
        xmlWriter.writeStringAttribute("type", this.type);
        xmlWriter.writeXml(this.namespaceProperties, "NamespaceInfo");
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of NamespacePropertiesEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of NamespacePropertiesEntryContent if the XmlReader was pointing to an instance of it, or
     * null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the NamespacePropertiesEntryContent.
     */
    @Generated
    public static NamespacePropertiesEntryContent fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of NamespacePropertiesEntryContent from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of NamespacePropertiesEntryContent if the XmlReader was pointing to an instance of it, or
     * null if it was pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the NamespacePropertiesEntryContent.
     */
    @Generated
    public static NamespacePropertiesEntryContent fromXml(XmlReader xmlReader, String rootElementName)
        throws XMLStreamException {
        String finalRootElementName = rootElementName == null || rootElementName.isEmpty()
            ? "NamespacePropertiesEntryContent"
            : rootElementName;
        return xmlReader.readObject(WWW_W3_ORG_TWO_ZERO_ZERO_FIVE_ATOM, finalRootElementName, reader -> {
            NamespacePropertiesEntryContent deserializedNamespacePropertiesEntryContent
                = new NamespacePropertiesEntryContent();
            deserializedNamespacePropertiesEntryContent.type = reader.getStringAttribute(null, "type");
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("NamespaceInfo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedNamespacePropertiesEntryContent.namespaceProperties
                        = NamespaceProperties.fromXml(reader, "NamespaceInfo");
                } else {
                    reader.skipElement();
                }
            }

            return deserializedNamespacePropertiesEntryContent;
        });
    }
}
