/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import java.time.Duration;

final class ReceiverOptions {
    private final ServiceBusReceiveMode receiveMode;
    private final int prefetchCount;
    private final boolean enableAutoComplete;
    private final String sessionId;
    private final Integer maxConcurrentSessions;
    private final Duration maxLockRenewDuration;
    private final Duration sessionIdleTimeout;

    static ReceiverOptions createNonSessionOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete) {
        return new ReceiverOptions(receiveMode, prefetchCount, maxLockRenewDuration, enableAutoComplete, null, null, null);
    }

    static ReceiverOptions createNamedSessionOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete, String sessionId) {
        return new ReceiverOptions(receiveMode, prefetchCount, maxLockRenewDuration, enableAutoComplete, sessionId, null, null);
    }

    static ReceiverOptions createUnnamedSessionOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete, Integer maxConcurrentSessions, Duration sessionIdleTimeout) {
        return new ReceiverOptions(receiveMode, prefetchCount, maxLockRenewDuration, enableAutoComplete, null, maxConcurrentSessions, sessionIdleTimeout);
    }

    private ReceiverOptions(ServiceBusReceiveMode receiveMode, int prefetchCount, Duration maxLockRenewDuration, boolean enableAutoComplete, String sessionId, Integer maxConcurrentSessions, Duration sessionIdleTimeout) {
        this.receiveMode = receiveMode;
        this.prefetchCount = prefetchCount;
        this.enableAutoComplete = enableAutoComplete;
        this.sessionId = sessionId;
        this.maxConcurrentSessions = maxConcurrentSessions;
        this.maxLockRenewDuration = maxLockRenewDuration;
        this.sessionIdleTimeout = sessionIdleTimeout;
    }

    Duration getMaxLockRenewDuration() {
        return this.maxLockRenewDuration;
    }

    ServiceBusReceiveMode getReceiveMode() {
        return this.receiveMode;
    }

    String getSessionId() {
        return this.sessionId;
    }

    int getPrefetchCount() {
        return this.prefetchCount;
    }

    boolean isAutoLockRenewEnabled() {
        return this.maxLockRenewDuration != null && !this.maxLockRenewDuration.isZero() && !this.maxLockRenewDuration.isNegative();
    }

    public boolean isRollingSessionReceiver() {
        return this.maxConcurrentSessions != null && this.maxConcurrentSessions > 0 && this.sessionId == null;
    }

    public Integer getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    Duration getSessionIdleTimeout() {
        return this.sessionIdleTimeout;
    }

    public boolean isEnableAutoComplete() {
        return this.enableAutoComplete;
    }
}

