/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.AmqpClientOptions;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpRetryPolicy;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.amqp.ProxyOptions;
import com.azure.core.amqp.client.traits.AmqpTrait;
import com.azure.core.amqp.implementation.AzureTokenManagerProvider;
import com.azure.core.amqp.implementation.ConnectionOptions;
import com.azure.core.amqp.implementation.ConnectionStringProperties;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.amqp.implementation.ReactorConnectionCache;
import com.azure.core.amqp.implementation.ReactorHandlerProvider;
import com.azure.core.amqp.implementation.ReactorProvider;
import com.azure.core.amqp.implementation.RetryUtil;
import com.azure.core.amqp.implementation.StringUtil;
import com.azure.core.amqp.implementation.TokenManagerProvider;
import com.azure.core.amqp.models.CbsAuthorizationType;
import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.annotation.ServiceClientProtocol;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.exception.AzureException;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.ConfigurationProperty;
import com.azure.core.util.ConfigurationPropertyBuilder;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracerProvider;
import com.azure.messaging.servicebus.ConnectionCacheWrapper;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusErrorContext;
import com.azure.messaging.servicebus.ServiceBusMessageSerializer;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.messaging.servicebus.ServiceBusReceivedMessageContext;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusRuleManagerAsyncClient;
import com.azure.messaging.servicebus.ServiceBusRuleManagerClient;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.messaging.servicebus.ServiceBusSessionAcquirer;
import com.azure.messaging.servicebus.ServiceBusSessionManager;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.messaging.servicebus.SessionsMessagePump;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusAmqpLinkProvider;
import com.azure.messaging.servicebus.implementation.ServiceBusConnectionProcessor;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusProcessorClientOptions;
import com.azure.messaging.servicebus.implementation.ServiceBusReactorAmqpConnection;
import com.azure.messaging.servicebus.implementation.ServiceBusSharedKeyCredential;
import com.azure.messaging.servicebus.implementation.instrumentation.ReceiverKind;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusReceiverInstrumentation;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusSenderInstrumentation;
import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.qpid.proton.engine.SslDomain;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@ServiceClientBuilder(serviceClients={ServiceBusReceiverAsyncClient.class, ServiceBusSenderAsyncClient.class, ServiceBusSenderClient.class, ServiceBusReceiverClient.class, ServiceBusProcessorClient.class}, protocol=ServiceClientProtocol.AMQP)
public final class ServiceBusClientBuilder
implements TokenCredentialTrait<ServiceBusClientBuilder>,
AzureNamedKeyCredentialTrait<ServiceBusClientBuilder>,
ConnectionStringTrait<ServiceBusClientBuilder>,
AzureSasCredentialTrait<ServiceBusClientBuilder>,
AmqpTrait<ServiceBusClientBuilder>,
ConfigurationTrait<ServiceBusClientBuilder> {
    private static final AmqpRetryOptions DEFAULT_RETRY = new AmqpRetryOptions().setTryTimeout(ServiceBusConstants.OPERATION_TIMEOUT);
    private static final String SERVICE_BUS_PROPERTIES_FILE = "azure-messaging-servicebus.properties";
    private static final String SUBSCRIPTION_ENTITY_PATH_FORMAT = "%s/subscriptions/%s";
    private static final String DEAD_LETTER_QUEUE_NAME_SUFFIX = "/$deadletterqueue";
    private static final String TRANSFER_DEAD_LETTER_QUEUE_NAME_SUFFIX = "/$Transfer/$deadletterqueue";
    private static final int DEFAULT_PREFETCH_COUNT = 0;
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "version";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String LIBRARY_NAME;
    private static final String LIBRARY_VERSION;
    private static final Duration MAX_LOCK_RENEW_DEFAULT_DURATION;
    private static final ClientLogger LOGGER;
    private final Object connectionLock = new Object();
    private final MessageSerializer messageSerializer = new ServiceBusMessageSerializer();
    private ClientOptions clientOptions;
    private Configuration configuration;
    private ServiceBusConnectionProcessor sharedConnection;
    private ConnectionStringProperties connectionStringProperties;
    private String connectionStringEntityName;
    private TokenCredential credentials;
    private String fullyQualifiedNamespace;
    private ProxyOptions proxyOptions;
    private AmqpRetryOptions retryOptions;
    private Scheduler scheduler;
    private AmqpTransportType transport = AmqpTransportType.AMQP;
    private SslDomain.VerifyMode verifyMode;
    private boolean crossEntityTransactions;
    private URL customEndpointAddress;
    private final V2StackSupport v2StackSupport = new V2StackSupport();
    private final AtomicInteger openClients = new AtomicInteger();

    public ServiceBusClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public ServiceBusClientBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    private String getAndValidateFullyQualifiedNamespace() {
        if (CoreUtils.isNullOrEmpty((CharSequence)this.fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this.fullyQualifiedNamespace;
    }

    public ServiceBusClientBuilder customEndpointAddress(String customEndpointAddress) {
        if (customEndpointAddress == null) {
            this.customEndpointAddress = null;
            return this;
        }
        try {
            this.customEndpointAddress = new URL(customEndpointAddress);
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("(%s) : is not a valid URL,", customEndpointAddress), e));
        }
        return this;
    }

    public ServiceBusClientBuilder connectionString(String connectionString) {
        TokenCredential tokenCredential;
        ConnectionStringProperties properties;
        this.connectionStringProperties = properties = new ConnectionStringProperties(connectionString);
        try {
            tokenCredential = this.getTokenCredential(properties);
        }
        catch (Exception e) {
            throw LOGGER.logExceptionAsError((RuntimeException)new AzureException("Could not create the ServiceBusSharedKeyCredential.", (Throwable)e));
        }
        this.fullyQualifiedNamespace = properties.getEndpoint().getHost();
        String entityPath = properties.getEntityPath();
        if (!CoreUtils.isNullOrEmpty((CharSequence)entityPath)) {
            LOGGER.atInfo().addKeyValue("entityPath", entityPath).log("Setting entity from connection string.");
            this.connectionStringEntityName = entityPath;
        }
        return this.credential(properties.getEndpoint().getHost(), tokenCredential);
    }

    public ServiceBusClientBuilder enableCrossEntityTransactions() {
        this.crossEntityTransactions = true;
        return this;
    }

    private TokenCredential getTokenCredential(ConnectionStringProperties properties) {
        ServiceBusSharedKeyCredential tokenCredential = properties.getSharedAccessSignature() == null ? new ServiceBusSharedKeyCredential(properties.getSharedAccessKeyName(), properties.getSharedAccessKey(), ServiceBusConstants.TOKEN_VALIDITY) : new ServiceBusSharedKeyCredential(properties.getSharedAccessSignature());
        return tokenCredential;
    }

    public ServiceBusClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, TokenCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        return this;
    }

    public ServiceBusClientBuilder credential(TokenCredential credential) {
        this.credentials = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, AzureNamedKeyCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        this.credentials = new ServiceBusSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ServiceBusConstants.TOKEN_VALIDITY);
        return this;
    }

    public ServiceBusClientBuilder credential(AzureNamedKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new ServiceBusSharedKeyCredential(credential.getAzureNamedKey().getName(), credential.getAzureNamedKey().getKey(), ServiceBusConstants.TOKEN_VALIDITY);
        return this;
    }

    public ServiceBusClientBuilder credential(String fullyQualifiedNamespace, AzureSasCredential credential) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        if (CoreUtils.isNullOrEmpty((CharSequence)fullyQualifiedNamespace)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        this.credentials = new ServiceBusSharedKeyCredential(credential.getSignature());
        return this;
    }

    public ServiceBusClientBuilder credential(AzureSasCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        this.credentials = new ServiceBusSharedKeyCredential(credential.getSignature());
        return this;
    }

    public ServiceBusClientBuilder proxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    ServiceBusClientBuilder verifyMode(SslDomain.VerifyMode verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public ServiceBusClientBuilder retryOptions(AmqpRetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    ServiceBusClientBuilder scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ServiceBusClientBuilder transportType(AmqpTransportType transportType) {
        this.transport = transportType;
        return this;
    }

    public ServiceBusSenderClientBuilder sender() {
        return new ServiceBusSenderClientBuilder();
    }

    public ServiceBusReceiverClientBuilder receiver() {
        return new ServiceBusReceiverClientBuilder();
    }

    public ServiceBusSessionReceiverClientBuilder sessionReceiver() {
        return new ServiceBusSessionReceiverClientBuilder();
    }

    public ServiceBusProcessorClientBuilder processor() {
        return new ServiceBusProcessorClientBuilder();
    }

    public ServiceBusSessionProcessorClientBuilder sessionProcessor() {
        return new ServiceBusSessionProcessorClientBuilder();
    }

    public ServiceBusRuleManagerBuilder ruleManager() {
        return new ServiceBusRuleManagerBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onClientClose() {
        Object object = this.connectionLock;
        synchronized (object) {
            int numberOfOpenClients = this.openClients.decrementAndGet();
            LOGGER.atInfo().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("Closing a dependent client.");
            if (numberOfOpenClients > 0) {
                return;
            }
            if (numberOfOpenClients < 0) {
                LOGGER.atWarning().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("There should not be less than 0 clients.");
            }
            LOGGER.info("No more open clients, closing shared connection.");
            if (this.sharedConnection != null) {
                this.sharedConnection.dispose();
                this.sharedConnection = null;
            } else {
                LOGGER.warning("Shared ServiceBusConnectionProcessor was already disposed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceBusConnectionProcessor getOrCreateConnectionProcessor(MessageSerializer serializer, Meter meter) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.sharedConnection == null) {
                ConnectionOptions connectionOptions = this.getConnectionOptions();
                Flux connectionFlux = Mono.fromCallable(() -> {
                    String connectionId = StringUtil.getRandomString((String)"MF");
                    ReactorProvider provider = new ReactorProvider();
                    ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider, meter);
                    AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getAuthorizationScope());
                    ServiceBusAmqpLinkProvider linkProvider = new ServiceBusAmqpLinkProvider();
                    boolean isV2 = false;
                    boolean useSessionChannelCache = false;
                    return new ServiceBusReactorAmqpConnection(connectionId, connectionOptions, provider, handlerProvider, linkProvider, (TokenManagerProvider)tokenManagerProvider, serializer, this.crossEntityTransactions, false, false);
                }).repeat();
                this.sharedConnection = (ServiceBusConnectionProcessor)connectionFlux.subscribeWith((Subscriber)new ServiceBusConnectionProcessor(connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getRetry()));
            }
        }
        int numberOfOpenClients = this.openClients.incrementAndGet();
        LOGGER.info("# of open clients with shared connection: {}", new Object[]{numberOfOpenClients});
        return this.sharedConnection;
    }

    private ConnectionOptions getConnectionOptions() {
        int port;
        String hostname;
        boolean usingDevelopmentEmulator;
        Configuration configuration = this.configuration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        if (this.retryOptions == null) {
            this.retryOptions = DEFAULT_RETRY;
        }
        if (this.scheduler == null) {
            this.scheduler = Schedulers.boundedElastic();
        }
        if (this.credentials == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Credentials have not been set. They can be set using: connectionString(String), connectionString(String, String), or credentials(String, String, TokenCredential)"));
        }
        if (this.proxyOptions != null && this.proxyOptions.isProxyAddressConfigured() && this.transport != AmqpTransportType.AMQP_WEB_SOCKETS) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Cannot use a proxy when TransportType is not AMQP Web Sockets. Use the setter 'transportType(AmqpTransportType.AMQP_WEB_SOCKETS)' to enable Web Sockets mode."));
        }
        if (this.proxyOptions == null) {
            this.proxyOptions = ProxyOptions.fromConfiguration((Configuration)this.configuration);
        }
        CbsAuthorizationType authorizationType = this.credentials instanceof ServiceBusSharedKeyCredential ? CbsAuthorizationType.SHARED_ACCESS_SIGNATURE : CbsAuthorizationType.JSON_WEB_TOKEN;
        SslDomain.VerifyMode verificationMode = this.verifyMode != null ? this.verifyMode : SslDomain.VerifyMode.VERIFY_PEER_NAME;
        boolean bl = usingDevelopmentEmulator = this.connectionStringProperties != null && this.connectionStringProperties.useDevelopmentEmulator();
        if (usingDevelopmentEmulator) {
            verificationMode = SslDomain.VerifyMode.ANONYMOUS_PEER;
        }
        ClientOptions options = this.clientOptions != null ? this.clientOptions : new ClientOptions();
        String fullyQualifiedNamespace = this.getAndValidateFullyQualifiedNamespace();
        if (this.customEndpointAddress != null) {
            hostname = this.customEndpointAddress.getHost();
            port = this.customEndpointAddress.getPort();
        } else if (this.connectionStringProperties != null) {
            URI endpoint = this.connectionStringProperties.getEndpoint();
            hostname = endpoint.getHost();
            port = endpoint.getPort();
        } else {
            hostname = fullyQualifiedNamespace;
            port = -1;
        }
        int portToUse = port != -1 ? port : ServiceBusClientBuilder.getPort(this.transport, usingDevelopmentEmulator);
        boolean enableSsl = !usingDevelopmentEmulator;
        return new ConnectionOptions(fullyQualifiedNamespace, this.credentials, authorizationType, "https://servicebus.azure.net/.default", this.transport, this.retryOptions, this.proxyOptions, this.scheduler, options, verificationMode, LIBRARY_NAME, LIBRARY_VERSION, hostname, portToUse, enableSsl);
    }

    private ReactorConnectionCache<ServiceBusReactorAmqpConnection> getOrCreateConnectionCache(MessageSerializer serializer, Meter meter, boolean useSessionChannelCache) {
        return this.v2StackSupport.getOrCreateConnectionCache(this.getConnectionOptions(), serializer, this.crossEntityTransactions, meter, useSessionChannelCache);
    }

    private static boolean isNullOrEmpty(String item) {
        return item == null || item.isEmpty();
    }

    private static MessagingEntityType validateEntityPaths(String connectionStringEntityName, String topicName, String queueName) {
        MessagingEntityType entityType;
        boolean hasConnectionStringEntity;
        boolean hasTopicName = !ServiceBusClientBuilder.isNullOrEmpty(topicName);
        boolean hasQueueName = !ServiceBusClientBuilder.isNullOrEmpty(queueName);
        boolean bl = hasConnectionStringEntity = !ServiceBusClientBuilder.isNullOrEmpty(connectionStringEntityName);
        if (!(hasConnectionStringEntity || hasQueueName || hasTopicName)) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot build client without setting either a queueName or topicName."));
        }
        if (hasQueueName && hasTopicName) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("Cannot build client with both queueName (%s) and topicName (%s) set.", queueName, topicName)));
        }
        if (hasQueueName) {
            if (hasConnectionStringEntity && !queueName.equals(connectionStringEntityName)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("queueName (%s) is different than the connectionString's EntityPath (%s).", queueName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.QUEUE;
        } else if (hasTopicName) {
            if (hasConnectionStringEntity && !topicName.equals(connectionStringEntityName)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) is different than the connectionString's EntityPath (%s).", topicName, connectionStringEntityName)));
            }
            entityType = MessagingEntityType.SUBSCRIPTION;
        } else {
            entityType = MessagingEntityType.UNKNOWN;
        }
        return entityType;
    }

    private static String getEntityPath(MessagingEntityType entityType, String queueName, String topicName, String subscriptionName, SubQueue subQueue) {
        String entityPath;
        switch (entityType) {
            case QUEUE: {
                entityPath = queueName;
                break;
            }
            case SUBSCRIPTION: {
                if (ServiceBusClientBuilder.isNullOrEmpty(subscriptionName)) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format("topicName (%s) must have a subscriptionName associated with it.", topicName)));
                }
                entityPath = String.format(Locale.ROOT, SUBSCRIPTION_ENTITY_PATH_FORMAT, topicName, subscriptionName);
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
            }
        }
        if (subQueue == null) {
            return entityPath;
        }
        switch (subQueue) {
            case NONE: {
                break;
            }
            case TRANSFER_DEAD_LETTER_QUEUE: {
                entityPath = entityPath + TRANSFER_DEAD_LETTER_QUEUE_NAME_SUFFIX;
                break;
            }
            case DEAD_LETTER_QUEUE: {
                entityPath = entityPath + DEAD_LETTER_QUEUE_NAME_SUFFIX;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unsupported value of subqueue type: " + (Object)((Object)subQueue)));
            }
        }
        return entityPath;
    }

    private static int getPort(AmqpTransportType transport, boolean useDevelopmentEmulator) {
        if (useDevelopmentEmulator) {
            return 5672;
        }
        switch (transport) {
            case AMQP: {
                return 5671;
            }
            case AMQP_WEB_SOCKETS: {
                return 443;
            }
        }
        throw (IllegalArgumentException)LOGGER.logThrowableAsError((Throwable)new IllegalArgumentException("Transport Type is not supported: " + transport));
    }

    private void validateAndThrow(int prefetchCount) {
        if (prefetchCount < 0) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("prefetchCount (%s) cannot be less than 0.", prefetchCount)));
        }
    }

    private void validateAndThrow(Duration maxLockRenewalDuration, String parameterName) {
        if (maxLockRenewalDuration != null && maxLockRenewalDuration.isNegative()) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' cannot be negative.", parameterName)));
        }
    }

    private static Meter createMeter(ClientOptions clientOptions) {
        return MeterProvider.getDefaultProvider().createMeter(LIBRARY_NAME, LIBRARY_VERSION, clientOptions == null ? null : clientOptions.getMetricsOptions());
    }

    private static Tracer createTracer(ClientOptions clientOptions) {
        return TracerProvider.getDefaultProvider().createTracer(LIBRARY_NAME, LIBRARY_VERSION, "Microsoft.ServiceBus", clientOptions == null ? null : clientOptions.getTracingOptions());
    }

    static /* synthetic */ Duration access$2600() {
        return MAX_LOCK_RENEW_DEFAULT_DURATION;
    }

    static {
        MAX_LOCK_RENEW_DEFAULT_DURATION = Duration.ofMinutes(5L);
        LOGGER = new ClientLogger(ServiceBusClientBuilder.class);
        Map properties = CoreUtils.getProperties((String)SERVICE_BUS_PROPERTIES_FILE);
        LIBRARY_NAME = properties.getOrDefault(NAME_KEY, UNKNOWN);
        LIBRARY_VERSION = properties.getOrDefault(VERSION_KEY, UNKNOWN);
    }

    private static final class V2StackSupport {
        private static final String NON_SESSION_ASYNC_RECEIVE_KEY = "com.azure.messaging.servicebus.nonSession.asyncReceive.v2";
        private static final ConfigurationProperty<Boolean> NON_SESSION_ASYNC_RECEIVE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.nonSession.asyncReceive.v2").environmentVariableName("com.azure.messaging.servicebus.nonSession.asyncReceive.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> nonSessionAsyncReceiveFlag = new AtomicReference();
        private static final String NON_SESSION_SYNC_RECEIVE_KEY = "com.azure.messaging.servicebus.nonSession.syncReceive.v2";
        private static final ConfigurationProperty<Boolean> NON_SESSION_SYNC_RECEIVE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.nonSession.syncReceive.v2").environmentVariableName("com.azure.messaging.servicebus.nonSession.syncReceive.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> nonSessionSyncReceiveFlag = new AtomicReference();
        private static final String SEND_MANAGE_RULES_KEY = "com.azure.messaging.servicebus.sendAndManageRules.v2";
        private static final ConfigurationProperty<Boolean> SEND_MANAGE_RULES_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.sendAndManageRules.v2").environmentVariableName("com.azure.messaging.servicebus.sendAndManageRules.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> sendManageFlag = new AtomicReference();
        private static final String SESSION_PROCESSOR_ASYNC_RECEIVE_KEY = "com.azure.messaging.servicebus.session.processor.asyncReceive.v2";
        private static final ConfigurationProperty<Boolean> SESSION_PROCESSOR_ASYNC_RECEIVE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.session.processor.asyncReceive.v2").environmentVariableName("com.azure.messaging.servicebus.session.processor.asyncReceive.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> sessionProcessorAsyncReceiveFlag = new AtomicReference();
        private static final String SESSION_REACTOR_ASYNC_RECEIVE_KEY = "com.azure.messaging.servicebus.session.reactor.asyncReceive.v2";
        private static final ConfigurationProperty<Boolean> SESSION_REACTOR_ASYNC_RECEIVE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.session.reactor.asyncReceive.v2").environmentVariableName("com.azure.messaging.servicebus.session.reactor.asyncReceive.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> sessionReactorAsyncReceiveFlag = new AtomicReference();
        private static final String SESSION_SYNC_RECEIVE_KEY = "com.azure.messaging.servicebus.session.syncReceive.v2";
        private static final ConfigurationProperty<Boolean> SESSION_SYNC_RECEIVE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.messaging.servicebus.session.syncReceive.v2").environmentVariableName("com.azure.messaging.servicebus.session.syncReceive.v2").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> sessionSyncReceiveFlag = new AtomicReference();
        private static final String SESSION_CHANNEL_CACHE_KEY = "com.azure.core.amqp.cache";
        private static final ConfigurationProperty<Boolean> SESSION_CHANNEL_CACHE_PROPERTY = ConfigurationPropertyBuilder.ofBoolean((String)"com.azure.core.amqp.cache").environmentVariableName("com.azure.core.amqp.cache").defaultValue((Object)true).shared(true).build();
        private final AtomicReference<Boolean> sessionChannelCacheFlag = new AtomicReference();
        private final Object connectionLock = new Object();
        private ReactorConnectionCache<ServiceBusReactorAmqpConnection> sharedConnectionCache;
        private final AtomicInteger openClients = new AtomicInteger();

        private V2StackSupport() {
        }

        boolean isNonSessionAsyncReceiveEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, NON_SESSION_ASYNC_RECEIVE_PROPERTY, this.nonSessionAsyncReceiveFlag);
        }

        boolean isNonSessionSyncReceiveEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, NON_SESSION_SYNC_RECEIVE_PROPERTY, this.nonSessionSyncReceiveFlag);
        }

        boolean isSenderAndManageRulesEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, SEND_MANAGE_RULES_PROPERTY, this.sendManageFlag);
        }

        boolean isSessionProcessorAsyncReceiveEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, SESSION_PROCESSOR_ASYNC_RECEIVE_PROPERTY, this.sessionProcessorAsyncReceiveFlag);
        }

        boolean isSessionReactorAsyncReceiveEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, SESSION_REACTOR_ASYNC_RECEIVE_PROPERTY, this.sessionReactorAsyncReceiveFlag);
        }

        boolean isSessionSyncReceiveEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, SESSION_SYNC_RECEIVE_PROPERTY, this.sessionSyncReceiveFlag);
        }

        boolean isSessionChannelCacheEnabled(Configuration configuration) {
            return !this.isOptedOut(configuration, SESSION_CHANNEL_CACHE_PROPERTY, this.sessionChannelCacheFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReactorConnectionCache<ServiceBusReactorAmqpConnection> getOrCreateConnectionCache(ConnectionOptions connectionOptions, MessageSerializer serializer, boolean crossEntityTransactions, Meter meter, boolean useSessionChannelCache) {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.sharedConnectionCache == null) {
                    this.sharedConnectionCache = V2StackSupport.createConnectionCache(connectionOptions, serializer, crossEntityTransactions, meter, useSessionChannelCache);
                }
            }
            int numberOfOpenClients = this.openClients.incrementAndGet();
            LOGGER.info("# of open clients using shared connection cache: {}", new Object[]{numberOfOpenClients});
            return this.sharedConnectionCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onClientClose() {
            Object object = this.connectionLock;
            synchronized (object) {
                int numberOfOpenClients = this.openClients.decrementAndGet();
                LOGGER.atInfo().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("Closing a client using shared connection cache.");
                if (numberOfOpenClients > 0) {
                    return;
                }
                if (numberOfOpenClients < 0) {
                    LOGGER.atWarning().addKeyValue("numberOfOpenClients", (long)numberOfOpenClients).log("There should not be less than 0 clients.");
                }
                LOGGER.info("No more open clients, closing shared connection cache.");
                if (this.sharedConnectionCache != null) {
                    this.sharedConnectionCache.dispose();
                    this.sharedConnectionCache = null;
                } else {
                    LOGGER.warning("Shared ReactorConnectionCache was already disposed.");
                }
            }
        }

        private boolean isOptedOut(Configuration configuration, ConfigurationProperty<Boolean> configProperty, AtomicReference<Boolean> choiceFlag) {
            boolean isOptedOut;
            Boolean flag = choiceFlag.get();
            if (flag != null) {
                return flag;
            }
            String propName = configProperty.getName();
            if (configuration != null) {
                isOptedOut = (Boolean)configuration.get(configProperty) == false;
            } else {
                assert (!CoreUtils.isNullOrEmpty((CharSequence)propName));
                isOptedOut = !CoreUtils.isNullOrEmpty((CharSequence)System.getenv(propName)) ? "false".equalsIgnoreCase(System.getenv(propName)) : (!CoreUtils.isNullOrEmpty((CharSequence)System.getProperty(propName)) ? "false".equalsIgnoreCase(System.getProperty(propName)) : false);
            }
            if (choiceFlag.compareAndSet(null, isOptedOut)) {
                LOGGER.verbose("Selected configuration {}={}", new Object[]{propName, isOptedOut});
                if (isOptedOut) {
                    String logMessage = "If your application fails to work without explicitly setting {} configuration to 'false', please file an urgent issue at https://github.com/Azure/azure-sdk-for-java/issues/new/choose";
                    LOGGER.info("If your application fails to work without explicitly setting {} configuration to 'false', please file an urgent issue at https://github.com/Azure/azure-sdk-for-java/issues/new/choose", new Object[]{propName});
                }
            }
            return choiceFlag.get();
        }

        private static ReactorConnectionCache<ServiceBusReactorAmqpConnection> createConnectionCache(ConnectionOptions connectionOptions, MessageSerializer serializer, boolean crossEntityTransactions, Meter meter, boolean useSessionChannelCache) {
            Supplier<ServiceBusReactorAmqpConnection> connectionSupplier = () -> {
                String connectionId = StringUtil.getRandomString((String)"MF");
                ReactorProvider provider = new ReactorProvider();
                ReactorHandlerProvider handlerProvider = new ReactorHandlerProvider(provider, meter);
                AzureTokenManagerProvider tokenManagerProvider = new AzureTokenManagerProvider(connectionOptions.getAuthorizationType(), connectionOptions.getFullyQualifiedNamespace(), connectionOptions.getAuthorizationScope());
                ServiceBusAmqpLinkProvider linkProvider = new ServiceBusAmqpLinkProvider();
                boolean isV2 = true;
                return new ServiceBusReactorAmqpConnection(connectionId, connectionOptions, provider, handlerProvider, linkProvider, (TokenManagerProvider)tokenManagerProvider, serializer, crossEntityTransactions, true, useSessionChannelCache);
            };
            String fullyQualifiedNamespace = connectionOptions.getFullyQualifiedNamespace();
            String entityPath = "N/A";
            AmqpRetryPolicy retryPolicy = RetryUtil.getRetryPolicy((AmqpRetryOptions)connectionOptions.getRetry());
            Map<String, String> loggingContext = Collections.singletonMap("entityPath", "N/A");
            return new ReactorConnectionCache(connectionSupplier, fullyQualifiedNamespace, "N/A", retryPolicy, loggingContext);
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusSenderClient.class, ServiceBusSenderAsyncClient.class})
    public final class ServiceBusSenderClientBuilder {
        private String queueName;
        private String topicName;

        private ServiceBusSenderClientBuilder() {
        }

        public ServiceBusSenderClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSenderClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusSenderAsyncClient buildAsyncClient() {
            String clientOptionIdentifier;
            String entityName;
            Runnable onClientClose;
            ConnectionCacheWrapper connectionCacheWrapper;
            boolean isSenderOnV2 = ServiceBusClientBuilder.this.v2StackSupport.isSenderAndManageRulesEnabled(ServiceBusClientBuilder.this.configuration);
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            if (isSenderOnV2) {
                boolean useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
                connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
                onClientClose = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
            } else {
                connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
                onClientClose = ServiceBusClientBuilder.this::onClientClose;
            }
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            switch (entityType) {
                case QUEUE: {
                    entityName = this.queueName;
                    break;
                }
                case SUBSCRIPTION: {
                    entityName = this.topicName;
                    break;
                }
                case UNKNOWN: {
                    entityName = ServiceBusClientBuilder.this.connectionStringEntityName;
                    break;
                }
                default: {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unknown entity type: " + (Object)((Object)entityType)));
                }
            }
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusSenderInstrumentation instrumentation = new ServiceBusSenderInstrumentation(ServiceBusClientBuilder.createTracer(ServiceBusClientBuilder.this.clientOptions), meter, connectionCacheWrapper.getFullyQualifiedNamespace(), entityName);
            return new ServiceBusSenderAsyncClient(entityName, entityType, connectionCacheWrapper, ServiceBusClientBuilder.this.retryOptions, instrumentation, ServiceBusClientBuilder.this.messageSerializer, onClientClose, null, clientIdentifier);
        }

        public ServiceBusSenderClient buildClient() {
            return new ServiceBusSenderClient(this.buildAsyncClient(), MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusReceiverClientBuilder {
        private boolean enableAutoComplete = true;
        private int prefetchCount = 0;
        private String queueName;
        private SubQueue subQueue;
        private ServiceBusReceiveMode receiveMode = ServiceBusReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewDuration = ServiceBusClientBuilder.access$2600();

        private ServiceBusReceiverClientBuilder() {
        }

        public ServiceBusReceiverClientBuilder disableAutoComplete() {
            this.enableAutoComplete = false;
            return this;
        }

        public ServiceBusReceiverClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration, "maxAutoLockRenewDuration");
            this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
            return this;
        }

        public ServiceBusReceiverClientBuilder prefetchCount(int prefetchCount) {
            ServiceBusClientBuilder.this.validateAndThrow(prefetchCount);
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusReceiverClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusReceiverClientBuilder subQueue(SubQueue subQueue) {
            this.subQueue = subQueue;
            return this;
        }

        public ServiceBusReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusReceiverAsyncClient buildAsyncClient() {
            return this.buildAsyncClient(true, ReceiverKind.ASYNC_RECEIVER);
        }

        public ServiceBusReceiverClient buildClient() {
            boolean isPrefetchDisabled = this.prefetchCount == 0;
            return new ServiceBusReceiverClient(this.buildAsyncClient(false, ReceiverKind.SYNC_RECEIVER), isPrefetchDisabled, MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }

        ServiceBusReceiverAsyncClient buildAsyncClientForProcessor() {
            return this.buildAsyncClient(true, ReceiverKind.PROCESSOR);
        }

        ServiceBusReceiverAsyncClient buildAsyncClient(boolean isAutoCompleteAllowed, ReceiverKind receiverKind) {
            String clientOptionIdentifier;
            Runnable onClientClose;
            ConnectionCacheWrapper connectionCacheWrapper;
            boolean useSessionChannelCache;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, this.subQueue);
            if (!isAutoCompleteAllowed && this.enableAutoComplete) {
                LOGGER.warning("'enableAutoComplete' is not supported in synchronous client except through callback receive.");
                this.enableAutoComplete = false;
            } else if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            if (receiverKind == ReceiverKind.SYNC_RECEIVER) {
                boolean syncReceiveOnV2 = ServiceBusClientBuilder.this.v2StackSupport.isNonSessionSyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
                if (syncReceiveOnV2) {
                    useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
                    connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
                    onClientClose = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
                } else {
                    connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
                    onClientClose = ServiceBusClientBuilder.this::onClientClose;
                }
            } else {
                boolean asyncReceiveOnV2 = ServiceBusClientBuilder.this.v2StackSupport.isNonSessionAsyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
                if (asyncReceiveOnV2) {
                    useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
                    connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
                    onClientClose = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
                } else {
                    connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
                    onClientClose = ServiceBusClientBuilder.this::onClientClose;
                }
            }
            ReceiverOptions receiverOptions = ReceiverOptions.createNonSessionOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.createTracer(ServiceBusClientBuilder.this.clientOptions), meter, connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, receiverKind);
            return new ServiceBusReceiverAsyncClient(connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionCacheWrapper, ServiceBusConstants.OPERATION_TIMEOUT, instrumentation, ServiceBusClientBuilder.this.messageSerializer, onClientClose, clientIdentifier);
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusReceiverClient.class, ServiceBusReceiverAsyncClient.class})
    public final class ServiceBusSessionReceiverClientBuilder {
        private boolean enableAutoComplete = true;
        private Integer maxConcurrentSessions = null;
        private int prefetchCount = 0;
        private String queueName;
        private ServiceBusReceiveMode receiveMode = ServiceBusReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private String topicName;
        private Duration maxAutoLockRenewDuration = ServiceBusClientBuilder.access$2600();
        private Duration sessionIdleTimeout = null;
        private SubQueue subQueue = SubQueue.NONE;

        private ServiceBusSessionReceiverClientBuilder() {
        }

        public ServiceBusSessionReceiverClientBuilder disableAutoComplete() {
            this.enableAutoComplete = false;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration, "maxAutoLockRenewDuration");
            this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
            return this;
        }

        ServiceBusSessionReceiverClientBuilder sessionIdleTimeout(Duration sessionIdleTimeout) {
            ServiceBusClientBuilder.this.validateAndThrow(sessionIdleTimeout, "sessionIdleTimeout");
            this.sessionIdleTimeout = sessionIdleTimeout;
            return this;
        }

        ServiceBusSessionReceiverClientBuilder maxConcurrentSessions(int maxConcurrentSessions) {
            if (maxConcurrentSessions < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("maxConcurrentSessions cannot be less than 1."));
            }
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder prefetchCount(int prefetchCount) {
            ServiceBusClientBuilder.this.validateAndThrow(prefetchCount);
            this.prefetchCount = prefetchCount;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder subQueue(SubQueue subQueue) {
            this.subQueue = subQueue;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusSessionReceiverClientBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        ServiceBusReceiverAsyncClient buildAsyncClientForProcessor() {
            String clientOptionIdentifier;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, this.subQueue);
            if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            ConnectionCacheWrapper connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
            ReceiverOptions receiverOptions = ReceiverOptions.createUnnamedSessionOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete, this.maxConcurrentSessions, this.sessionIdleTimeout);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.createTracer(ServiceBusClientBuilder.this.clientOptions), meter, connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, ReceiverKind.PROCESSOR);
            ServiceBusSessionManager sessionManager = new ServiceBusSessionManager(entityPath, entityType, connectionCacheWrapper, ServiceBusClientBuilder.this.messageSerializer, receiverOptions, clientIdentifier, instrumentation.getTracer());
            return new ServiceBusReceiverAsyncClient(connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionCacheWrapper, ServiceBusConstants.OPERATION_TIMEOUT, instrumentation, ServiceBusClientBuilder.this.messageSerializer, ServiceBusClientBuilder.this::onClientClose, sessionManager);
        }

        SessionsMessagePump buildPumpForProcessor(ClientLogger logger, Consumer<ServiceBusReceivedMessageContext> processMessage, Consumer<ServiceBusErrorContext> processError, int concurrencyPerSession) {
            String clientOptionIdentifier;
            if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            AmqpRetryPolicy retryPolicy = RetryUtil.getRetryPolicy((AmqpRetryOptions)ServiceBusClientBuilder.this.retryOptions);
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, this.subQueue);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            boolean useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
            ConnectionCacheWrapper connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
            boolean timeoutRetryDisabled = false;
            ServiceBusSessionAcquirer sessionAcquirer = new ServiceBusSessionAcquirer(logger, clientIdentifier, entityPath, entityType, this.receiveMode, ServiceBusClientBuilder.this.retryOptions.getTryTimeout(), false, connectionCacheWrapper);
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.createTracer(ServiceBusClientBuilder.this.clientOptions), meter, connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, ReceiverKind.PROCESSOR);
            Runnable onTerminate = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
            return new SessionsMessagePump(clientIdentifier, connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, this.receiveMode, instrumentation, sessionAcquirer, this.maxAutoLockRenewDuration, this.sessionIdleTimeout, this.maxConcurrentSessions, concurrencyPerSession, this.prefetchCount, this.enableAutoComplete, ServiceBusClientBuilder.this.messageSerializer, retryPolicy, processMessage, processError, onTerminate);
        }

        public ServiceBusSessionReceiverAsyncClient buildAsyncClient() {
            boolean isV2 = ServiceBusClientBuilder.this.v2StackSupport.isSessionReactorAsyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
            return this.buildAsyncClient(false, isV2);
        }

        public ServiceBusSessionReceiverClient buildClient() {
            boolean isV2 = ServiceBusClientBuilder.this.v2StackSupport.isSessionSyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
            boolean isPrefetchDisabled = this.prefetchCount == 0;
            return new ServiceBusSessionReceiverClient(this.buildAsyncClient(true, isV2), isPrefetchDisabled, MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }

        private ServiceBusSessionReceiverAsyncClient buildAsyncClient(boolean isForSyncMode, boolean isV2) {
            String clientOptionIdentifier;
            Runnable onClientClose;
            ConnectionCacheWrapper connectionCacheWrapper;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, this.queueName);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, this.queueName, this.topicName, this.subscriptionName, SubQueue.NONE);
            if (isForSyncMode && this.enableAutoComplete) {
                LOGGER.warning("'enableAutoComplete' is not supported in synchronous client except through callback receive.");
                this.enableAutoComplete = false;
            } else if (this.enableAutoComplete && this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                LOGGER.warning("'enableAutoComplete' is not needed in for RECEIVE_AND_DELETE mode.");
                this.enableAutoComplete = false;
            }
            if (this.receiveMode == ServiceBusReceiveMode.RECEIVE_AND_DELETE) {
                this.maxAutoLockRenewDuration = Duration.ZERO;
            }
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            if (isV2) {
                boolean useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
                connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
                onClientClose = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
            } else {
                connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
                onClientClose = ServiceBusClientBuilder.this::onClientClose;
            }
            ReceiverOptions receiverOptions = ReceiverOptions.createUnnamedSessionOptions(this.receiveMode, this.prefetchCount, this.maxAutoLockRenewDuration, this.enableAutoComplete, this.maxConcurrentSessions, this.sessionIdleTimeout);
            String clientIdentifier = ServiceBusClientBuilder.this.clientOptions instanceof AmqpClientOptions ? (CoreUtils.isNullOrEmpty((CharSequence)(clientOptionIdentifier = ((AmqpClientOptions)ServiceBusClientBuilder.this.clientOptions).getIdentifier())) ? UUID.randomUUID().toString() : clientOptionIdentifier) : UUID.randomUUID().toString();
            boolean timeoutRetryDisabled = isV2 && isForSyncMode;
            ServiceBusReceiverInstrumentation instrumentation = new ServiceBusReceiverInstrumentation(ServiceBusClientBuilder.createTracer(ServiceBusClientBuilder.this.clientOptions), meter, connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, this.subscriptionName, ReceiverKind.ASYNC_RECEIVER);
            return new ServiceBusSessionReceiverAsyncClient(connectionCacheWrapper.getFullyQualifiedNamespace(), entityPath, entityType, receiverOptions, connectionCacheWrapper, instrumentation, ServiceBusClientBuilder.this.messageSerializer, onClientClose, clientIdentifier, timeoutRetryDisabled);
        }
    }

    public final class ServiceBusProcessorClientBuilder {
        private final ServiceBusReceiverClientBuilder serviceBusReceiverClientBuilder;
        private final ServiceBusProcessorClientOptions processorClientOptions;
        private Consumer<ServiceBusReceivedMessageContext> processMessage;
        private Consumer<ServiceBusErrorContext> processError;

        private ServiceBusProcessorClientBuilder() {
            this.serviceBusReceiverClientBuilder = new ServiceBusReceiverClientBuilder();
            this.processorClientOptions = new ServiceBusProcessorClientOptions().setMaxConcurrentCalls(1);
        }

        public ServiceBusProcessorClientBuilder prefetchCount(int prefetchCount) {
            this.serviceBusReceiverClientBuilder.prefetchCount(prefetchCount);
            return this;
        }

        public ServiceBusProcessorClientBuilder queueName(String queueName) {
            this.serviceBusReceiverClientBuilder.queueName(queueName);
            return this;
        }

        public ServiceBusProcessorClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.serviceBusReceiverClientBuilder.receiveMode(receiveMode);
            return this;
        }

        public ServiceBusProcessorClientBuilder subQueue(SubQueue subQueue) {
            this.serviceBusReceiverClientBuilder.subQueue(subQueue);
            return this;
        }

        public ServiceBusProcessorClientBuilder subscriptionName(String subscriptionName) {
            this.serviceBusReceiverClientBuilder.subscriptionName(subscriptionName);
            return this;
        }

        public ServiceBusProcessorClientBuilder topicName(String topicName) {
            this.serviceBusReceiverClientBuilder.topicName(topicName);
            return this;
        }

        public ServiceBusProcessorClientBuilder processMessage(Consumer<ServiceBusReceivedMessageContext> processMessage) {
            this.processMessage = processMessage;
            return this;
        }

        public ServiceBusProcessorClientBuilder processError(Consumer<ServiceBusErrorContext> processError) {
            this.processError = processError;
            return this;
        }

        public ServiceBusProcessorClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration, "maxAutoLockRenewDuration");
            this.serviceBusReceiverClientBuilder.maxAutoLockRenewDuration(maxAutoLockRenewDuration);
            return this;
        }

        public ServiceBusProcessorClientBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentCalls' cannot be less than 1"));
            }
            this.processorClientOptions.setMaxConcurrentCalls(maxConcurrentCalls);
            return this;
        }

        public ServiceBusProcessorClientBuilder disableAutoComplete() {
            this.serviceBusReceiverClientBuilder.disableAutoComplete();
            this.processorClientOptions.setDisableAutoComplete(true);
            return this;
        }

        public ServiceBusProcessorClient buildProcessorClient() {
            boolean isNonSessionProcessorV2 = ServiceBusClientBuilder.this.v2StackSupport.isNonSessionAsyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
            if (isNonSessionProcessorV2) {
                this.processorClientOptions.setV2(true);
                this.validateInputs();
            }
            return new ServiceBusProcessorClient(this.serviceBusReceiverClientBuilder, this.serviceBusReceiverClientBuilder.queueName, this.serviceBusReceiverClientBuilder.topicName, this.serviceBusReceiverClientBuilder.subscriptionName, Objects.requireNonNull(this.processMessage, "'processMessage' cannot be null"), Objects.requireNonNull(this.processError, "'processError' cannot be null"), this.processorClientOptions);
        }

        private void validateInputs() {
            ServiceBusReceiverClientBuilder builder = this.serviceBusReceiverClientBuilder;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, builder.topicName, builder.queueName);
            ServiceBusClientBuilder.getEntityPath(entityType, builder.queueName, builder.topicName, builder.subscriptionName, builder.subQueue);
            ServiceBusClientBuilder.this.getConnectionOptions();
        }
    }

    public final class ServiceBusSessionProcessorClientBuilder {
        private final ServiceBusProcessorClientOptions processorClientOptions;
        private final ServiceBusSessionReceiverClientBuilder sessionReceiverClientBuilder;
        private Consumer<ServiceBusReceivedMessageContext> processMessage;
        private Consumer<ServiceBusErrorContext> processError;

        private ServiceBusSessionProcessorClientBuilder() {
            this.sessionReceiverClientBuilder = new ServiceBusSessionReceiverClientBuilder();
            this.processorClientOptions = new ServiceBusProcessorClientOptions().setMaxConcurrentCalls(1);
            this.sessionReceiverClientBuilder.maxConcurrentSessions(1);
        }

        public ServiceBusSessionProcessorClientBuilder maxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            ServiceBusClientBuilder.this.validateAndThrow(maxAutoLockRenewDuration, "maxAutoLockRenewDuration");
            this.sessionReceiverClientBuilder.maxAutoLockRenewDuration(maxAutoLockRenewDuration);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder sessionIdleTimeout(Duration sessionIdleTimeout) {
            ServiceBusClientBuilder.this.validateAndThrow(sessionIdleTimeout, "sessionIdleTimeout");
            this.sessionReceiverClientBuilder.sessionIdleTimeout(sessionIdleTimeout);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder maxConcurrentSessions(int maxConcurrentSessions) {
            if (maxConcurrentSessions < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentSessions' cannot be less than 1"));
            }
            this.sessionReceiverClientBuilder.maxConcurrentSessions(maxConcurrentSessions);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder prefetchCount(int prefetchCount) {
            this.sessionReceiverClientBuilder.prefetchCount(prefetchCount);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder queueName(String queueName) {
            this.sessionReceiverClientBuilder.queueName(queueName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder receiveMode(ServiceBusReceiveMode receiveMode) {
            this.sessionReceiverClientBuilder.receiveMode(receiveMode);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder subQueue(SubQueue subQueue) {
            this.sessionReceiverClientBuilder.subQueue(subQueue);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder subscriptionName(String subscriptionName) {
            this.sessionReceiverClientBuilder.subscriptionName(subscriptionName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder topicName(String topicName) {
            this.sessionReceiverClientBuilder.topicName(topicName);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder processMessage(Consumer<ServiceBusReceivedMessageContext> processMessage) {
            this.processMessage = processMessage;
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder processError(Consumer<ServiceBusErrorContext> processError) {
            this.processError = processError;
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder maxConcurrentCalls(int maxConcurrentCalls) {
            if (maxConcurrentCalls < 1) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'maxConcurrentCalls' cannot be less than 1"));
            }
            this.processorClientOptions.setMaxConcurrentCalls(maxConcurrentCalls);
            return this;
        }

        public ServiceBusSessionProcessorClientBuilder disableAutoComplete() {
            this.sessionReceiverClientBuilder.disableAutoComplete();
            this.processorClientOptions.setDisableAutoComplete(true);
            return this;
        }

        public ServiceBusProcessorClient buildProcessorClient() {
            boolean isSessionProcessorOnV2 = ServiceBusClientBuilder.this.v2StackSupport.isSessionProcessorAsyncReceiveEnabled(ServiceBusClientBuilder.this.configuration);
            if (isSessionProcessorOnV2) {
                this.processorClientOptions.setV2(true);
                this.validateInputs();
            }
            return new ServiceBusProcessorClient(this.sessionReceiverClientBuilder, this.sessionReceiverClientBuilder.queueName, this.sessionReceiverClientBuilder.topicName, this.sessionReceiverClientBuilder.subscriptionName, Objects.requireNonNull(this.processMessage, "'processMessage' cannot be null"), Objects.requireNonNull(this.processError, "'processError' cannot be null"), this.processorClientOptions);
        }

        private void validateInputs() {
            ServiceBusSessionReceiverClientBuilder builder = this.sessionReceiverClientBuilder;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, builder.topicName, builder.queueName);
            ServiceBusClientBuilder.getEntityPath(entityType, builder.queueName, builder.topicName, builder.subscriptionName, builder.subQueue);
            ServiceBusClientBuilder.this.getConnectionOptions();
        }
    }

    @ServiceClientBuilder(serviceClients={ServiceBusRuleManagerAsyncClient.class, ServiceBusRuleManagerClient.class})
    public final class ServiceBusRuleManagerBuilder {
        private String subscriptionName;
        private String topicName;

        private ServiceBusRuleManagerBuilder() {
        }

        public ServiceBusRuleManagerBuilder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public ServiceBusRuleManagerBuilder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public ServiceBusRuleManagerAsyncClient buildAsyncClient() {
            Runnable onClientClose;
            ConnectionCacheWrapper connectionCacheWrapper;
            MessagingEntityType entityType = ServiceBusClientBuilder.validateEntityPaths(ServiceBusClientBuilder.this.connectionStringEntityName, this.topicName, null);
            String entityPath = ServiceBusClientBuilder.getEntityPath(entityType, null, this.topicName, this.subscriptionName, null);
            Meter meter = ServiceBusClientBuilder.createMeter(ServiceBusClientBuilder.this.clientOptions);
            boolean isManageRulesOnV2 = ServiceBusClientBuilder.this.v2StackSupport.isSenderAndManageRulesEnabled(ServiceBusClientBuilder.this.configuration);
            if (isManageRulesOnV2) {
                boolean useSessionChannelCache = ServiceBusClientBuilder.this.v2StackSupport.isSessionChannelCacheEnabled(ServiceBusClientBuilder.this.configuration);
                connectionCacheWrapper = new ConnectionCacheWrapper((ReactorConnectionCache<ServiceBusReactorAmqpConnection>)ServiceBusClientBuilder.this.getOrCreateConnectionCache(ServiceBusClientBuilder.this.messageSerializer, meter, useSessionChannelCache));
                onClientClose = ServiceBusClientBuilder.this.v2StackSupport::onClientClose;
            } else {
                connectionCacheWrapper = new ConnectionCacheWrapper(ServiceBusClientBuilder.this.getOrCreateConnectionProcessor(ServiceBusClientBuilder.this.messageSerializer, meter));
                onClientClose = ServiceBusClientBuilder.this::onClientClose;
            }
            return new ServiceBusRuleManagerAsyncClient(entityPath, entityType, connectionCacheWrapper, onClientClose);
        }

        public ServiceBusRuleManagerClient buildClient() {
            return new ServiceBusRuleManagerClient(this.buildAsyncClient(), MessageUtils.getTotalTimeout(ServiceBusClientBuilder.this.retryOptions));
        }
    }
}

