/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.administration.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.administration.implementation.NamespacesImpl;
import com.azure.messaging.servicebus.administration.implementation.RulesImpl;
import com.azure.messaging.servicebus.administration.implementation.SubscriptionsImpl;
import com.azure.messaging.servicebus.administration.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.administration.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.administration.implementation.models.SubscriptionDescriptionFeed;
import reactor.core.publisher.Mono;

public final class ServiceBusManagementClientImpl {
    private final ServiceBusManagementClientService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final EntitiesImpl entities;
    private final SubscriptionsImpl subscriptions;
    private final RulesImpl rules;
    private final NamespacesImpl namespaces;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public EntitiesImpl getEntities() {
        return this.entities;
    }

    public SubscriptionsImpl getSubscriptions() {
        return this.subscriptions;
    }

    public RulesImpl getRules() {
        return this.rules;
    }

    public NamespacesImpl getNamespaces() {
        return this.namespaces;
    }

    public ServiceBusManagementClientImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public ServiceBusManagementClientImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public ServiceBusManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.entities = new EntitiesImpl(this);
        this.subscriptions = new SubscriptionsImpl(this);
        this.rules = new RulesImpl(this);
        this.namespaces = new NamespacesImpl(this);
        this.service = (ServiceBusManagementClientService)RestProxy.create(ServiceBusManagementClientService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionDescriptionFeed>> listSubscriptionsWithResponseAsync(String topicName, Integer skip, Integer top) {
        return FluxUtil.withContext(context -> this.listSubscriptionsWithResponseAsync(topicName, skip, top, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionDescriptionFeed>> listSubscriptionsWithResponseAsync(String topicName, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listSubscriptions(this.getEndpoint(), topicName, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionDescriptionFeed> listSubscriptionsAsync(String topicName, Integer skip, Integer top) {
        return this.listSubscriptionsWithResponseAsync(topicName, skip, top).flatMap(res -> Mono.justOrEmpty((Object)((SubscriptionDescriptionFeed)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionDescriptionFeed> listSubscriptionsAsync(String topicName, Integer skip, Integer top, Context context) {
        return this.listSubscriptionsWithResponseAsync(topicName, skip, top, context).flatMap(res -> Mono.justOrEmpty((Object)((SubscriptionDescriptionFeed)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionDescriptionFeed> listSubscriptionsWithResponse(String topicName, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listSubscriptionsSync(this.getEndpoint(), topicName, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionDescriptionFeed listSubscriptions(String topicName, Integer skip, Integer top) {
        return (SubscriptionDescriptionFeed)this.listSubscriptionsWithResponse(topicName, skip, top, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionFeed>> listRulesWithResponseAsync(String topicName, String subscriptionName, Integer skip, Integer top) {
        return FluxUtil.withContext(context -> this.listRulesWithResponseAsync(topicName, subscriptionName, skip, top, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleDescriptionFeed>> listRulesWithResponseAsync(String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listRules(this.getEndpoint(), topicName, subscriptionName, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionFeed> listRulesAsync(String topicName, String subscriptionName, Integer skip, Integer top) {
        return this.listRulesWithResponseAsync(topicName, subscriptionName, skip, top).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionFeed)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleDescriptionFeed> listRulesAsync(String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        return this.listRulesWithResponseAsync(topicName, subscriptionName, skip, top, context).flatMap(res -> Mono.justOrEmpty((Object)((RuleDescriptionFeed)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleDescriptionFeed> listRulesWithResponse(String topicName, String subscriptionName, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listRulesSync(this.getEndpoint(), topicName, subscriptionName, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleDescriptionFeed listRules(String topicName, String subscriptionName, Integer skip, Integer top) {
        return (RuleDescriptionFeed)this.listRulesWithResponse(topicName, subscriptionName, skip, top, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> listEntitiesWithResponseAsync(String entityType, Integer skip, Integer top) {
        return FluxUtil.withContext(context -> this.listEntitiesWithResponseAsync(entityType, skip, top, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> listEntitiesWithResponseAsync(String entityType, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listEntities(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> listEntitiesAsync(String entityType, Integer skip, Integer top) {
        return this.listEntitiesWithResponseAsync(entityType, skip, top).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> listEntitiesAsync(String entityType, Integer skip, Integer top, Context context) {
        return this.listEntitiesWithResponseAsync(entityType, skip, top, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> listEntitiesWithResponse(String entityType, Integer skip, Integer top, Context context) {
        String accept = "application/xml, application/atom+xml";
        return this.service.listEntitiesSync(this.getEndpoint(), entityType, skip, top, this.getApiVersion(), "application/xml, application/atom+xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object listEntities(String entityType, Integer skip, Integer top) {
        return this.listEntitiesWithResponse(entityType, skip, top, Context.NONE).getValue();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagementClient")
    public static interface ServiceBusManagementClientService {
        @Get(value="/{topicName}/subscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<SubscriptionDescriptionFeed>> listSubscriptions(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{topicName}/subscriptions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<SubscriptionDescriptionFeed> listSubscriptionsSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<RuleDescriptionFeed>> listRules(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<RuleDescriptionFeed> listRulesSync(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/$Resources/{entityType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> listEntities(@HostParam(value="endpoint") String var1, @PathParam(value="entityType") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/$Resources/{entityType}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Response<Object> listEntitiesSync(@HostParam(value="endpoint") String var1, @PathParam(value="entityType") String var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

