// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The FalseFilter model.
 */
@Fluent
public final class FalseFilterImpl extends SqlFilterImpl {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE
        = "http://www.w3.org/2001/XMLSchema-instance";

    /*
     * The type property.
     */
    private String type = "FalseFilter";

    /**
     * Creates an instance of FalseFilter class.
     */
    public FalseFilterImpl() {
    }

    /**
     * Get the type property: The type property.
     * 
     * @return the type value.
     */
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FalseFilterImpl setSqlExpression(String sqlExpression) {
        super.setSqlExpression(sqlExpression);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FalseFilterImpl setCompatibilityLevel(String compatibilityLevel) {
        super.setCompatibilityLevel(compatibilityLevel);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FalseFilterImpl setParameters(List<KeyValueImpl> parameters) {
        super.setParameters(parameters);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public FalseFilterImpl setRequiresPreprocessing(Boolean requiresPreprocessing) {
        super.setRequiresPreprocessing(requiresPreprocessing);
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Filter" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SqlExpression", getSqlExpression());
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CompatibilityLevel",
            getCompatibilityLevel());
        if (getParameters() != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Parameters");
            for (KeyValueImpl element : getParameters()) {
                xmlWriter.writeXml(element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeBooleanElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "RequiresPreprocessing",
            isRequiresPreprocessing());
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of FalseFilter from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of FalseFilter if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the FalseFilter.
     */
    public static FalseFilterImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of FalseFilter from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of FalseFilter if the XmlReader was pointing to an instance of it, or null if it was pointing
     * to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the FalseFilter.
     */
    public static FalseFilterImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Filter" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            FalseFilterImpl deserializedFalseFilter = new FalseFilterImpl();
            String discriminatorValue
                = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"FalseFilter".equals(discriminatorValue)) {
                throw new IllegalStateException(
                    "'type' was expected to be non-null and equal to 'FalseFilter'. The found 'type' was '"
                        + discriminatorValue + "'.");
            }
            deserializedFalseFilter.type = discriminatorValue;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("SqlExpression".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedFalseFilter.setSqlExpression(reader.getStringElement());
                } else if ("CompatibilityLevel".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedFalseFilter.setCompatibilityLevel(reader.getStringElement());
                } else if ("Parameters".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart())
                            && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedFalseFilter.getParameters() == null) {
                                deserializedFalseFilter.setParameters(new ArrayList<>());
                            }
                            deserializedFalseFilter.getParameters()
                                .add(KeyValueImpl.fromXml(reader, "KeyValueOfstringanyType"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else if ("RequiresPreprocessing".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedFalseFilter.setRequiresPreprocessing(reader.getNullableElement(Boolean::parseBoolean));
                } else {
                    reader.skipElement();
                }
            }

            return deserializedFalseFilter;
        });
    }
}
