// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.messaging.servicebus.administration.implementation.EntityHelper;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The RuleDescription model.
 */
@Fluent
public final class RuleDescriptionImpl implements XmlSerializable<RuleDescriptionImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * The filter property.
     */
    private RuleFilterImpl filter;

    /*
     * The action property.
     */
    private RuleActionImpl action;

    /*
     * The exact time the rule was created.
     */
    private OffsetDateTime createdAt;

    /*
     * The name property.
     */
    private String name;

    /**
     * Creates an instance of RuleDescription class.
     */
    public RuleDescriptionImpl() {
    }

    /**
     * Get the filter property: The filter property.
     * 
     * @return the filter value.
     */
    public RuleFilterImpl getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The filter property.
     * 
     * @param filter the filter value to set.
     * @return the RuleDescription object itself.
     */
    public RuleDescriptionImpl setFilter(RuleFilterImpl filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the action property: The action property.
     * 
     * @return the action value.
     */
    public RuleActionImpl getAction() {
        return this.action;
    }

    /**
     * Set the action property: The action property.
     * 
     * @param action the action value to set.
     * @return the RuleDescription object itself.
     */
    public RuleDescriptionImpl setAction(RuleActionImpl action) {
        this.action = action;
        return this;
    }

    /**
     * Get the createdAt property: The exact time the rule was created.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    /**
     * Set the createdAt property: The exact time the rule was created.
     * 
     * @param createdAt the createdAt value to set.
     * @return the RuleDescription object itself.
     */
    public RuleDescriptionImpl setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Get the name property: The name property.
     * 
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Set the name property: The name property.
     * 
     * @param name the name value to set.
     * @return the RuleDescription object itself.
     */
    public RuleDescriptionImpl setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "RuleDescription" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeXml(this.filter, "Filter");
        xmlWriter.writeXml(this.action, "Action");
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CreatedAt",
            this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Name", this.name);
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of RuleDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of RuleDescription if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the RuleDescription.
     */
    public static RuleDescriptionImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of RuleDescription from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of RuleDescription if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws XMLStreamException If an error occurs while reading the RuleDescription.
     */
    public static RuleDescriptionImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "RuleDescription" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            RuleDescriptionImpl deserializedRuleDescription = new RuleDescriptionImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Filter".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.filter = RuleFilterImpl.fromXml(reader, "Filter");
                } else if ("Action".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.action = RuleActionImpl.fromXml(reader, "Action");
                } else if ("CreatedAt".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.createdAt
                        = reader.getNullableElement(dateString -> EntityHelper.parseOffsetDateTimeBest(dateString));
                } else if ("Name".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedRuleDescription.name = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedRuleDescription;
        });
    }
}
