// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * Key Values of custom properties.
 */
@Fluent
public final class KeyValueImpl implements XmlSerializable<KeyValueImpl> {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    /*
     * The key property.
     */
    private String key;

    /*
     * The value property.
     */
    private String value;

    /**
     * Creates an instance of KeyValue class.
     */
    public KeyValueImpl() {
    }

    /**
     * Get the key property: The key property.
     * 
     * @return the key value.
     */
    public String getKey() {
        return this.key;
    }

    /**
     * Set the key property: The key property.
     * 
     * @param key the key value to set.
     * @return the KeyValue object itself.
     */
    public KeyValueImpl setKey(String key) {
        this.key = key;
        return this;
    }

    /**
     * Get the value property: The value property.
     * 
     * @return the value value.
     */
    public String getValue() {
        return this.value;
    }

    /**
     * Set the value property: The value property.
     * 
     * @param value the value value to set.
     * @return the KeyValue object itself.
     */
    public KeyValueImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "KeyValueOfstringanyType" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Key", this.key);
        if (this.value != null) {
            xmlWriter.writeStartElement("Value");
            xmlWriter.writeNamespace("d6p1", "http://www.w3.org/2001/XMLSchema");
            xmlWriter.writeStringAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "d6p1:string");
            xmlWriter.writeString(this.value);
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of KeyValue from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of KeyValue if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the KeyValue.
     */
    public static KeyValueImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of KeyValue from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of KeyValue if the XmlReader was pointing to an instance of it, or null if it was pointing to
     * XML null.
     * @throws XMLStreamException If an error occurs while reading the KeyValue.
     */
    public static KeyValueImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName
            = CoreUtils.isNullOrEmpty(rootElementName) ? "KeyValueOfstringanyType" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            KeyValueImpl deserializedKeyValue = new KeyValueImpl();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("Key".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedKeyValue.key = reader.getStringElement();
                } else if ("Value".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedKeyValue.value = reader.getStringElement();
                } else {
                    reader.skipElement();
                }
            }

            return deserializedKeyValue;
        });
    }
}
