// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

/**
 * The CorrelationFilter model.
 */
@Fluent
public final class CorrelationFilterImpl extends RuleFilterImpl {
    private static final String SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT
        = "http://schemas.microsoft.com/netservices/2010/10/servicebus/connect";

    private static final String WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE
        = "http://www.w3.org/2001/XMLSchema-instance";

    /*
     * The type property.
     */
    private String type = "CorrelationFilter";

    /*
     * The correlationId property.
     */
    private String correlationId;

    /*
     * The messageId property.
     */
    private String messageId;

    /*
     * The to property.
     */
    private String to;

    /*
     * The replyTo property.
     */
    private String replyTo;

    /*
     * The label property.
     */
    private String label;

    /*
     * The sessionId property.
     */
    private String sessionId;

    /*
     * The replyToSessionId property.
     */
    private String replyToSessionId;

    /*
     * The contentType property.
     */
    private String contentType;

    /*
     * The properties property.
     */
    private List<KeyValueImpl> properties;

    /**
     * Creates an instance of CorrelationFilter class.
     */
    public CorrelationFilterImpl() {
    }

    /**
     * Get the type property: The type property.
     * 
     * @return the type value.
     */
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the correlationId property: The correlationId property.
     * 
     * @return the correlationId value.
     */
    public String getCorrelationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: The correlationId property.
     * 
     * @param correlationId the correlationId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the messageId property: The messageId property.
     * 
     * @return the messageId value.
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * Set the messageId property: The messageId property.
     * 
     * @param messageId the messageId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    /**
     * Get the to property: The to property.
     * 
     * @return the to value.
     */
    public String getTo() {
        return this.to;
    }

    /**
     * Set the to property: The to property.
     * 
     * @param to the to value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setTo(String to) {
        this.to = to;
        return this;
    }

    /**
     * Get the replyTo property: The replyTo property.
     * 
     * @return the replyTo value.
     */
    public String getReplyTo() {
        return this.replyTo;
    }

    /**
     * Set the replyTo property: The replyTo property.
     * 
     * @param replyTo the replyTo value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    /**
     * Get the label property: The label property.
     * 
     * @return the label value.
     */
    public String getLabel() {
        return this.label;
    }

    /**
     * Set the label property: The label property.
     * 
     * @param label the label value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the sessionId property: The sessionId property.
     * 
     * @return the sessionId value.
     */
    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * Set the sessionId property: The sessionId property.
     * 
     * @param sessionId the sessionId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    /**
     * Get the replyToSessionId property: The replyToSessionId property.
     * 
     * @return the replyToSessionId value.
     */
    public String getReplyToSessionId() {
        return this.replyToSessionId;
    }

    /**
     * Set the replyToSessionId property: The replyToSessionId property.
     * 
     * @param replyToSessionId the replyToSessionId value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setReplyToSessionId(String replyToSessionId) {
        this.replyToSessionId = replyToSessionId;
        return this;
    }

    /**
     * Get the contentType property: The contentType property.
     * 
     * @return the contentType value.
     */
    public String getContentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The contentType property.
     * 
     * @param contentType the contentType value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the properties property: The properties property.
     * 
     * @return the properties value.
     */
    public List<KeyValueImpl> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<>();
        }
        return this.properties;
    }

    /**
     * Set the properties property: The properties property.
     * 
     * @param properties the properties value to set.
     * @return the CorrelationFilter object itself.
     */
    public CorrelationFilterImpl setProperties(List<KeyValueImpl> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Filter" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeNamespace(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT);
        xmlWriter.writeNamespace("xsi", WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE);
        xmlWriter.writeStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type", this.type);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "CorrelationId", this.correlationId);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "MessageId", this.messageId);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "To", this.to);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ReplyTo", this.replyTo);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Label", this.label);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "SessionId", this.sessionId);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ReplyToSessionId",
            this.replyToSessionId);
        xmlWriter.writeStringElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "ContentType", this.contentType);
        if (this.properties != null) {
            xmlWriter.writeStartElement(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, "Properties");
            for (KeyValueImpl element : this.properties) {
                xmlWriter.writeXml(element, "KeyValueOfstringanyType");
            }
            xmlWriter.writeEndElement();
        }
        return xmlWriter.writeEndElement();
    }

    /**
     * Reads an instance of CorrelationFilter from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @return An instance of CorrelationFilter if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the CorrelationFilter.
     */
    public static CorrelationFilterImpl fromXml(XmlReader xmlReader) throws XMLStreamException {
        return fromXml(xmlReader, null);
    }

    /**
     * Reads an instance of CorrelationFilter from the XmlReader.
     * 
     * @param xmlReader The XmlReader being read.
     * @param rootElementName Optional root element name to override the default defined by the model. Used to support
     * cases where the model can deserialize from different root element names.
     * @return An instance of CorrelationFilter if the XmlReader was pointing to an instance of it, or null if it was
     * pointing to XML null.
     * @throws IllegalStateException If the deserialized XML object has an invalid polymorphic discriminator value.
     * @throws XMLStreamException If an error occurs while reading the CorrelationFilter.
     */
    public static CorrelationFilterImpl fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Filter" : rootElementName;
        return xmlReader.readObject(SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT, finalRootElementName, reader -> {
            CorrelationFilterImpl deserializedCorrelationFilter = new CorrelationFilterImpl();
            String discriminatorValue
                = reader.getStringAttribute(WWW_W3_ORG_TWO_ZERO_ZERO_ONE_XMLSCHEMA_INSTANCE, "type");
            if (!"CorrelationFilter".equals(discriminatorValue)) {
                throw new IllegalStateException(
                    "'type' was expected to be non-null and equal to 'CorrelationFilter'. The found 'type' was '"
                        + discriminatorValue + "'.");
            }
            deserializedCorrelationFilter.type = discriminatorValue;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();

                if ("CorrelationId".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.correlationId = reader.getStringElement();
                } else if ("MessageId".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.messageId = reader.getStringElement();
                } else if ("To".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.to = reader.getStringElement();
                } else if ("ReplyTo".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.replyTo = reader.getStringElement();
                } else if ("Label".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.label = reader.getStringElement();
                } else if ("SessionId".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.sessionId = reader.getStringElement();
                } else if ("ReplyToSessionId".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.replyToSessionId = reader.getStringElement();
                } else if ("ContentType".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    deserializedCorrelationFilter.contentType = reader.getStringElement();
                } else if ("Properties".equals(elementName.getLocalPart())
                    && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                    while (reader.nextElement() != XmlToken.END_ELEMENT) {
                        elementName = reader.getElementName();
                        if ("KeyValueOfstringanyType".equals(elementName.getLocalPart())
                            && SCHEMAS_MICROSOFT_COM_SERVICEBUS_CONNECT.equals(elementName.getNamespaceURI())) {
                            if (deserializedCorrelationFilter.properties == null) {
                                deserializedCorrelationFilter.properties = new ArrayList<>();
                            }
                            deserializedCorrelationFilter.properties
                                .add(KeyValueImpl.fromXml(reader, "KeyValueOfstringanyType"));
                        } else {
                            reader.skipElement();
                        }
                    }
                } else {
                    reader.skipElement();
                }
            }

            return deserializedCorrelationFilter;
        });
    }
}
