/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.MessageFlux;
import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.TracingFluxOperator;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.ServiceBusReceiveLinkProcessor;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusReceiverInstrumentation;
import java.util.Map;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ServiceBusAsyncConsumer
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusAsyncConsumer.class);
    private final boolean isV2;
    private final String linkName;
    private final ServiceBusReceiveLinkProcessor linkProcessor;
    private final MessageSerializer messageSerializer;
    private final Flux<ServiceBusReceivedMessage> processor;
    private final MessageFlux messageFlux;

    ServiceBusAsyncConsumer(String linkName, ServiceBusReceiveLinkProcessor linkProcessor, MessageSerializer messageSerializer, ReceiverOptions receiverOptions) {
        this.isV2 = false;
        this.linkName = linkName;
        this.linkProcessor = linkProcessor;
        this.messageFlux = null;
        this.messageSerializer = messageSerializer;
        this.processor = linkProcessor.map(message -> (ServiceBusReceivedMessage)this.messageSerializer.deserialize(message, ServiceBusReceivedMessage.class));
    }

    ServiceBusAsyncConsumer(String linkName, MessageFlux messageFlux, MessageSerializer messageSerializer, ReceiverOptions receiverOptions, ServiceBusReceiverInstrumentation instrumentation) {
        this.isV2 = true;
        this.linkName = linkName;
        this.messageFlux = messageFlux;
        this.linkProcessor = null;
        this.messageSerializer = messageSerializer;
        Flux deserialize = messageFlux.map(message -> (ServiceBusReceivedMessage)this.messageSerializer.deserialize(message, ServiceBusReceivedMessage.class));
        this.processor = TracingFluxOperator.create(deserialize, instrumentation);
    }

    String getLinkName() {
        return this.linkName;
    }

    Flux<ServiceBusReceivedMessage> receive() {
        return this.processor;
    }

    Mono<Void> updateDisposition(String lockToken, DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        DeliveryState deliveryState = MessageUtils.getDeliveryState(dispositionStatus, deadLetterReason, deadLetterErrorDescription, propertiesToModify, transactionContext);
        if (deliveryState == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'dispositionStatus' is not known. status: " + (Object)((Object)dispositionStatus)));
        }
        if (this.isV2) {
            return this.messageFlux.updateDisposition(lockToken, deliveryState);
        }
        return this.linkProcessor.updateDisposition(lockToken, deliveryState);
    }

    @Override
    public void close() {
        if (this.isV2) {
            return;
        }
        this.linkProcessor.dispose();
    }
}

