/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusErrorSource;
import com.azure.messaging.servicebus.ServiceBusException;

public final class ServiceBusErrorContext {
    private final Throwable exception;
    private final ServiceBusErrorSource errorSource;
    private final String fullyQualifiedNamespace;
    private final String entityPath;

    ServiceBusErrorContext(Throwable throwable, String fullyQualifiedNamespace, String entityPath) {
        this.exception = throwable;
        this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        this.entityPath = entityPath;
        if (throwable instanceof ServiceBusException) {
            ServiceBusException serviceBusException = (ServiceBusException)((Object)throwable);
            this.errorSource = serviceBusException.getErrorSource();
        } else {
            this.errorSource = ServiceBusErrorSource.RECEIVE;
        }
    }

    public Throwable getException() {
        return this.exception;
    }

    public ServiceBusErrorSource getErrorSource() {
        return this.errorSource;
    }

    public String getFullyQualifiedNamespace() {
        return this.fullyQualifiedNamespace;
    }

    public String getEntityPath() {
        return this.entityPath;
    }
}

