/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ConnectionCacheWrapper;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionAcquirer;
import com.azure.messaging.servicebus.ServiceBusSessionManager;
import com.azure.messaging.servicebus.ServiceBusSessionReactorReceiver;
import com.azure.messaging.servicebus.ServiceBusSingleSessionManager;
import com.azure.messaging.servicebus.implementation.MessagingEntityType;
import com.azure.messaging.servicebus.implementation.ServiceBusConstants;
import com.azure.messaging.servicebus.implementation.ServiceBusReceiveLink;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusReceiverInstrumentation;
import com.azure.messaging.servicebus.implementation.instrumentation.ServiceBusTracer;
import java.util.Objects;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusClientBuilder.class, isAsync=true)
public final class ServiceBusSessionReceiverAsyncClient
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusSessionReceiverAsyncClient.class);
    private final String fullyQualifiedNamespace;
    private final String entityPath;
    private final MessagingEntityType entityType;
    private final ReceiverOptions receiverOptions;
    private final ConnectionCacheWrapper connectionCacheWrapper;
    private final ServiceBusReceiverInstrumentation instrumentation;
    private final ServiceBusTracer tracer;
    private final MessageSerializer messageSerializer;
    private final Runnable onClientClose;
    private final ServiceBusSessionManager unNamedSessionManager;
    private final ServiceBusSessionAcquirer sessionAcquirer;
    private final String identifier;

    ServiceBusSessionReceiverAsyncClient(String fullyQualifiedNamespace, String entityPath, MessagingEntityType entityType, ReceiverOptions receiverOptions, ConnectionCacheWrapper connectionCacheWrapper, ServiceBusReceiverInstrumentation instrumentation, MessageSerializer messageSerializer, Runnable onClientClose, String identifier, boolean timeoutRetryDisabled) {
        this.fullyQualifiedNamespace = Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        this.entityPath = Objects.requireNonNull(entityPath, "'entityPath' cannot be null.");
        this.entityType = Objects.requireNonNull(entityType, "'entityType' cannot be null.");
        this.receiverOptions = Objects.requireNonNull(receiverOptions, "'receiveOptions cannot be null.'");
        this.connectionCacheWrapper = Objects.requireNonNull(connectionCacheWrapper, "'connectionCacheWrapper' cannot be null.");
        this.instrumentation = Objects.requireNonNull(instrumentation, "'instrumentation' cannot be null.");
        this.messageSerializer = Objects.requireNonNull(messageSerializer, "'messageSerializer' cannot be null.");
        this.onClientClose = Objects.requireNonNull(onClientClose, "'onClientClose' cannot be null.");
        if (connectionCacheWrapper.isV2()) {
            this.sessionAcquirer = new ServiceBusSessionAcquirer(LOGGER, identifier, entityPath, entityType, receiverOptions.getReceiveMode(), connectionCacheWrapper.getRetryOptions().getTryTimeout(), timeoutRetryDisabled, connectionCacheWrapper);
            this.unNamedSessionManager = null;
        } else {
            this.unNamedSessionManager = new ServiceBusSessionManager(entityPath, entityType, connectionCacheWrapper, messageSerializer, receiverOptions, identifier, instrumentation.getTracer());
            this.sessionAcquirer = null;
        }
        this.identifier = identifier;
        this.tracer = instrumentation.getTracer();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServiceBusReceiverAsyncClient> acceptNextSession() {
        if (this.sessionAcquirer != null) {
            return this.acquireSpecificOrNextSession(null, this.sessionAcquirer);
        }
        return this.tracer.traceMono("ServiceBus.acceptNextSession", this.unNamedSessionManager.getActiveLink().flatMap(receiveLink -> receiveLink.getSessionId().map(sessionId -> {
            ReceiverOptions newReceiverOptions = ReceiverOptions.createNamedSessionOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), sessionId);
            ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionCacheWrapper, this.messageSerializer, newReceiverOptions, (ServiceBusReceiveLink)receiveLink, this.identifier, this.instrumentation.getTracer());
            return new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionCacheWrapper, ServiceBusConstants.OPERATION_TIMEOUT, this.instrumentation, this.messageSerializer, () -> {}, sessionSpecificManager);
        })));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ServiceBusReceiverAsyncClient> acceptSession(String sessionId) {
        if (sessionId == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new NullPointerException("'sessionId' cannot be null"));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)sessionId)) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'sessionId' cannot be empty"));
        }
        if (this.sessionAcquirer != null) {
            return this.acquireSpecificOrNextSession(sessionId, this.sessionAcquirer);
        }
        ReceiverOptions newReceiverOptions = ReceiverOptions.createNamedSessionOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), sessionId);
        ServiceBusSessionManager sessionSpecificManager = new ServiceBusSessionManager(this.entityPath, this.entityType, this.connectionCacheWrapper, this.messageSerializer, newReceiverOptions, this.identifier, this.instrumentation.getTracer());
        return this.tracer.traceMono("ServiceBus.acceptSession", sessionSpecificManager.getActiveLink().map(receiveLink -> new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionCacheWrapper, ServiceBusConstants.OPERATION_TIMEOUT, this.instrumentation, this.messageSerializer, () -> {}, sessionSpecificManager)));
    }

    private Mono<ServiceBusReceiverAsyncClient> acquireSpecificOrNextSession(String specificSessionId, ServiceBusSessionAcquirer sessionAcquirer) {
        Mono<ServiceBusSessionAcquirer.Session> acquireSession = specificSessionId != null ? sessionAcquirer.acquire(specificSessionId) : sessionAcquirer.acquire();
        Mono acquireSessionReceiver = acquireSession.map(session -> {
            ServiceBusSessionReactorReceiver sessionReceiver = new ServiceBusSessionReactorReceiver(LOGGER, this.tracer, (ServiceBusSessionAcquirer.Session)session, null, this.receiverOptions.getMaxLockRenewDuration());
            ServiceBusSingleSessionManager sessionManager = new ServiceBusSingleSessionManager(LOGGER, this.identifier, sessionReceiver, this.receiverOptions.getPrefetchCount(), this.messageSerializer, this.connectionCacheWrapper.getRetryOptions(), this.instrumentation);
            ReceiverOptions newReceiverOptions = ReceiverOptions.createNamedSessionOptions(this.receiverOptions.getReceiveMode(), this.receiverOptions.getPrefetchCount(), this.receiverOptions.getMaxLockRenewDuration(), this.receiverOptions.isEnableAutoComplete(), session.getId());
            return new ServiceBusReceiverAsyncClient(this.fullyQualifiedNamespace, this.entityPath, this.entityType, newReceiverOptions, this.connectionCacheWrapper, ServiceBusConstants.OPERATION_TIMEOUT, this.instrumentation, this.messageSerializer, () -> {}, sessionManager);
        });
        return this.tracer.traceMono("ServiceBus.acceptSession", acquireSessionReceiver);
    }

    @Override
    public void close() {
        if (this.unNamedSessionManager != null) {
            this.unNamedSessionManager.close();
        }
        this.onClientClose.run();
    }
}

