/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusClientBuilder.class)
public final class ServiceBusSessionReceiverClient
implements AutoCloseable {
    private static final String TIMEOUT_MESSAGE_PREFIX = "Timeout on blocking read for ";
    private final ServiceBusSessionReceiverAsyncClient sessionAsyncClient;
    private final boolean isPrefetchDisabled;
    private final Duration operationTimeout;

    ServiceBusSessionReceiverClient(ServiceBusSessionReceiverAsyncClient asyncClient, boolean isPrefetchDisabled, Duration operationTimeout) {
        this.sessionAsyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
        this.operationTimeout = operationTimeout;
        this.isPrefetchDisabled = isPrefetchDisabled;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServiceBusReceiverClient acceptNextSession() {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptNextSession().map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.isPrefetchDisabled, this.operationTimeout)).timeout(this.operationTimeout, Mono.error(() -> {
            String message = TIMEOUT_MESSAGE_PREFIX + this.operationTimeout.toNanos() + " " + (Object)((Object)TimeUnit.NANOSECONDS) + " (client-timeout)";
            return new TimeoutException(message);
        })).onErrorMap(TimeoutException.class, e -> new IllegalStateException(e.getMessage(), (Throwable)e)).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ServiceBusReceiverClient acceptSession(String sessionId) {
        return (ServiceBusReceiverClient)this.sessionAsyncClient.acceptSession(sessionId).map(asyncClient -> new ServiceBusReceiverClient((ServiceBusReceiverAsyncClient)asyncClient, this.isPrefetchDisabled, this.operationTimeout)).timeout(this.operationTimeout, Mono.error(() -> {
            String message = TIMEOUT_MESSAGE_PREFIX + this.operationTimeout.toNanos() + " " + (Object)((Object)TimeUnit.NANOSECONDS) + " (client-timeout)";
            return new TimeoutException(message);
        })).onErrorMap(TimeoutException.class, e -> new IllegalStateException(e.getMessage(), (Throwable)e)).block();
    }

    @Override
    public void close() {
        this.sessionAsyncClient.close();
    }
}

