/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.AzureException;
import com.azure.core.exception.ClientAuthenticationException;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.ResourceExistsException;
import com.azure.core.exception.ResourceModifiedException;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.QueueRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.administration.models.TopicRuntimeProperties;
import com.azure.messaging.servicebus.implementation.EntitiesImpl;
import com.azure.messaging.servicebus.implementation.EntityHelper;
import com.azure.messaging.servicebus.implementation.RulesImpl;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementSerializer;
import com.azure.messaging.servicebus.implementation.models.CreateQueueBody;
import com.azure.messaging.servicebus.implementation.models.CreateQueueBodyContent;
import com.azure.messaging.servicebus.implementation.models.CreateRuleBody;
import com.azure.messaging.servicebus.implementation.models.CreateRuleBodyContent;
import com.azure.messaging.servicebus.implementation.models.CreateSubscriptionBody;
import com.azure.messaging.servicebus.implementation.models.CreateSubscriptionBodyContent;
import com.azure.messaging.servicebus.implementation.models.CreateTopicBody;
import com.azure.messaging.servicebus.implementation.models.CreateTopicBodyContent;
import com.azure.messaging.servicebus.implementation.models.NamespacePropertiesEntry;
import com.azure.messaging.servicebus.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.implementation.models.QueueDescriptionEntry;
import com.azure.messaging.servicebus.implementation.models.QueueDescriptionFeed;
import com.azure.messaging.servicebus.implementation.models.ResponseLink;
import com.azure.messaging.servicebus.implementation.models.RuleActionImpl;
import com.azure.messaging.servicebus.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.implementation.models.RuleDescriptionEntry;
import com.azure.messaging.servicebus.implementation.models.RuleDescriptionFeed;
import com.azure.messaging.servicebus.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementError;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import com.azure.messaging.servicebus.implementation.models.SubscriptionDescription;
import com.azure.messaging.servicebus.implementation.models.SubscriptionDescriptionEntry;
import com.azure.messaging.servicebus.implementation.models.SubscriptionDescriptionFeed;
import com.azure.messaging.servicebus.implementation.models.TopicDescription;
import com.azure.messaging.servicebus.implementation.models.TopicDescriptionEntry;
import com.azure.messaging.servicebus.implementation.models.TopicDescriptionFeed;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusAdministrationClientBuilder.class, isAsync=true)
public final class ServiceBusAdministrationAsyncClient {
    private static final String CONTENT_TYPE = "application/xml";
    private static final String QUEUES_ENTITY_TYPE = "queues";
    private static final String TOPICS_ENTITY_TYPE = "topics";
    private static final int NUMBER_OF_ELEMENTS = 100;
    private final ServiceBusManagementClientImpl managementClient;
    private final EntitiesImpl entityClient;
    private final ClientLogger logger = new ClientLogger(ServiceBusAdministrationAsyncClient.class);
    private final ServiceBusManagementSerializer serializer;
    private final RulesImpl rulesClient;

    ServiceBusAdministrationAsyncClient(ServiceBusManagementClientImpl managementClient, ServiceBusManagementSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        this.managementClient = Objects.requireNonNull(managementClient, "'managementClient' cannot be null.");
        this.entityClient = managementClient.getEntities();
        this.rulesClient = managementClient.getRules();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> createQueue(String queueName) {
        try {
            return this.createQueue(queueName, new CreateQueueOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> createQueue(String queueName, CreateQueueOptions queueOptions) {
        return this.createQueueWithResponse(queueName, queueOptions).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> createQueueWithResponse(String queueName, CreateQueueOptions queueOptions) {
        return FluxUtil.withContext(context -> this.createQueueWithResponse(queueName, queueOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> createRule(String topicName, String subscriptionName, String ruleName) {
        try {
            return this.createRule(topicName, subscriptionName, ruleName, new CreateRuleOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> createRule(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions) {
        return this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions) {
        return FluxUtil.withContext(context -> this.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> createSubscription(String topicName, String subscriptionName) {
        try {
            return this.createSubscription(topicName, subscriptionName, new CreateSubscriptionOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> createSubscription(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return FluxUtil.withContext(context -> this.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> createTopic(String topicName) {
        try {
            return this.createTopic(topicName, new CreateTopicOptions());
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> createTopic(String topicName, CreateTopicOptions topicOptions) {
        return this.createTopicWithResponse(topicName, topicOptions).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions) {
        return FluxUtil.withContext(context -> this.createTopicWithResponse(topicName, topicOptions, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteQueue(String queueName) {
        return this.deleteQueueWithResponse(queueName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.deleteQueueWithResponse(queueName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRule(String topicName, String subscriptionName, String ruleName) {
        return this.deleteRuleWithResponse(topicName, subscriptionName, ruleName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName) {
        return FluxUtil.withContext(context -> this.deleteRuleWithResponse(topicName, subscriptionName, ruleName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSubscription(String topicName, String subscriptionName) {
        return this.deleteSubscriptionWithResponse(topicName, subscriptionName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSubscriptionWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.deleteSubscriptionWithResponse(topicName, subscriptionName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteTopic(String topicName) {
        return this.deleteTopicWithResponse(topicName).then();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteTopicWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.deleteTopicWithResponse(topicName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> getQueue(String queueName) {
        return this.getQueueWithResponse(queueName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> getQueueWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueWithResponse(queueName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getQueueExists(String queueName) {
        return this.getQueueExistsWithResponse(queueName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getQueueExistsWithResponse(String queueName) {
        return this.getEntityExistsWithResponse(this.getQueueWithResponse(queueName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueRuntimeProperties> getQueueRuntimeProperties(String queueName) {
        return this.getQueueRuntimePropertiesWithResponse(queueName).map(response -> (QueueRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueRuntimeProperties>> getQueueRuntimePropertiesWithResponse(String queueName) {
        return FluxUtil.withContext(context -> this.getQueueWithResponse(queueName, (Context)context, QueueRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NamespaceProperties> getNamespaceProperties() {
        return this.getNamespacePropertiesWithResponse().map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NamespaceProperties>> getNamespacePropertiesWithResponse() {
        return FluxUtil.withContext(this::getNamespacePropertiesWithResponse);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> getRule(String topicName, String subscriptionName, String ruleName) {
        return this.getRuleWithResponse(topicName, subscriptionName, ruleName).map(response -> (RuleProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> getRuleWithResponse(String topicName, String subscriptionName, String ruleName) {
        return FluxUtil.withContext(context -> this.getRuleWithResponse(topicName, subscriptionName, ruleName, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> getSubscription(String topicName, String subscriptionName) {
        return this.getSubscriptionWithResponse(topicName, subscriptionName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> getSubscriptionWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.getSubscriptionWithResponse(topicName, subscriptionName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getSubscriptionExists(String topicName, String subscriptionName) {
        return this.getSubscriptionExistsWithResponse(topicName, subscriptionName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getSubscriptionExistsWithResponse(String topicName, String subscriptionName) {
        return this.getEntityExistsWithResponse(this.getSubscriptionWithResponse(topicName, subscriptionName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionRuntimeProperties> getSubscriptionRuntimeProperties(String topicName, String subscriptionName) {
        return this.getSubscriptionRuntimePropertiesWithResponse(topicName, subscriptionName).map(response -> (SubscriptionRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionRuntimeProperties>> getSubscriptionRuntimePropertiesWithResponse(String topicName, String subscriptionName) {
        return FluxUtil.withContext(context -> this.getSubscriptionWithResponse(topicName, subscriptionName, (Context)context, SubscriptionRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> getTopic(String topicName) {
        return this.getTopicWithResponse(topicName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> getTopicWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.getTopicWithResponse(topicName, (Context)context, Function.identity()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Boolean> getTopicExists(String topicName) {
        return this.getTopicExistsWithResponse(topicName).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Boolean>> getTopicExistsWithResponse(String topicName) {
        return this.getEntityExistsWithResponse(this.getTopicWithResponse(topicName));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicRuntimeProperties> getTopicRuntimeProperties(String topicName) {
        return this.getTopicRuntimePropertiesWithResponse(topicName).map(response -> (TopicRuntimeProperties)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicRuntimeProperties>> getTopicRuntimePropertiesWithResponse(String topicName) {
        return FluxUtil.withContext(context -> this.getTopicWithResponse(topicName, (Context)context, TopicRuntimeProperties::new));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<QueueProperties> listQueues() {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listQueuesFirstPage((Context)context)), token -> FluxUtil.withContext(context -> this.listQueuesNextPage((String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RuleProperties> listRules(String topicName, String subscriptionName) {
        if (topicName == null) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listRulesFirstPage(topicName, subscriptionName, (Context)context)), token -> FluxUtil.withContext(context -> this.listRulesNextPage(topicName, subscriptionName, (String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SubscriptionProperties> listSubscriptions(String topicName) {
        if (topicName == null) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.pagedFluxError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listSubscriptionsFirstPage(topicName, (Context)context)), token -> FluxUtil.withContext(context -> this.listSubscriptionsNextPage(topicName, (String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TopicProperties> listTopics() {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listTopicsFirstPage((Context)context)), token -> FluxUtil.withContext(context -> this.listTopicsNextPage((String)token, (Context)context)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<QueueProperties> updateQueue(QueueProperties queue) {
        return this.updateQueueWithResponse(queue).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<QueueProperties>> updateQueueWithResponse(QueueProperties queue) {
        return FluxUtil.withContext(context -> this.updateQueueWithResponse(queue, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RuleProperties> updateRule(String topicName, String subscriptionName, RuleProperties rule) {
        return this.updateRuleWithResponse(topicName, subscriptionName, rule).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RuleProperties>> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule) {
        return FluxUtil.withContext(context -> this.updateRuleWithResponse(topicName, subscriptionName, rule, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SubscriptionProperties> updateSubscription(SubscriptionProperties subscription) {
        return this.updateSubscriptionWithResponse(subscription).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SubscriptionProperties>> updateSubscriptionWithResponse(SubscriptionProperties subscription) {
        return FluxUtil.withContext(context -> this.updateSubscriptionWithResponse(subscription, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TopicProperties> updateTopic(TopicProperties topic) {
        return this.updateTopicWithResponse(topic).map(Response::getValue);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TopicProperties>> updateTopicWithResponse(TopicProperties topic) {
        return FluxUtil.withContext(context -> this.updateTopicWithResponse(topic, (Context)context));
    }

    Mono<Response<QueueProperties>> createQueueWithResponse(String queueName, CreateQueueOptions createQueueOptions, Context context) {
        String forwardDlqToEntity;
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null."));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be empty."));
        }
        if (createQueueOptions == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'createQueueOptions' cannot be null."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context contextWithHeaders = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
        String forwardToEntity = createQueueOptions.getForwardTo();
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            createQueueOptions.setForwardTo(this.getAbsoluteUrlFromEntity(forwardToEntity));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(forwardDlqToEntity = createQueueOptions.getForwardDeadLetteredMessagesTo()))) {
            this.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            createQueueOptions.setForwardDeadLetteredMessagesTo(this.getAbsoluteUrlFromEntity(forwardDlqToEntity));
        }
        QueueDescription description = EntityHelper.getQueueDescription(createQueueOptions);
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(description);
        CreateQueueBody createEntity = new CreateQueueBody().setContent(content);
        try {
            return this.entityClient.putWithResponseAsync(queueName, createEntity, null, contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeQueue);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be empty."));
        }
        if (subscriptionName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscriptionName' cannot be null."));
        }
        if (subscriptionName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be empty."));
        }
        if (ruleName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'ruleName' cannot be null."));
        }
        if (ruleName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be empty."));
        }
        if (ruleOptions == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'rule' cannot be null."));
        }
        RuleActionImpl action = ruleOptions.getAction() != null ? EntityHelper.toImplementation(ruleOptions.getAction()) : null;
        RuleFilterImpl filter = ruleOptions.getFilter() != null ? EntityHelper.toImplementation(ruleOptions.getFilter()) : null;
        RuleDescription rule = new RuleDescription().setAction(action).setFilter(filter).setName(ruleName);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(rule);
        CreateRuleBody createEntity = new CreateRuleBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.managementClient.getRules().putWithResponseAsync(topicName, subscriptionName, ruleName, createEntity, null, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeRule((Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<SubscriptionProperties>> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions, Context context) {
        String forwardDlqToEntity;
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be empty."));
        }
        if (subscriptionName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscriptionName' cannot be null."));
        }
        if (subscriptionName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be empty."));
        }
        if (subscriptionOptions == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscription' cannot be null."));
        }
        Context contextWithHeaders = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
        String forwardToEntity = subscriptionOptions.getForwardTo();
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            subscriptionOptions.setForwardTo(this.getAbsoluteUrlFromEntity(forwardToEntity));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(forwardDlqToEntity = subscriptionOptions.getForwardDeadLetteredMessagesTo()))) {
            this.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            subscriptionOptions.setForwardDeadLetteredMessagesTo(this.getAbsoluteUrlFromEntity(forwardDlqToEntity));
        }
        SubscriptionDescription subscription = EntityHelper.getSubscriptionDescription(subscriptionOptions);
        CreateSubscriptionBodyContent content = new CreateSubscriptionBodyContent().setType(CONTENT_TYPE).setSubscriptionDescription(subscription);
        CreateSubscriptionBody createEntity = new CreateSubscriptionBody().setContent(content);
        try {
            return this.managementClient.getSubscriptions().putWithResponseAsync(topicName, subscriptionName, createEntity, null, contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeSubscription(topicName, (Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<TopicProperties>> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions, Context context) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be empty."));
        }
        if (topicOptions == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicOptions' cannot be null"));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        TopicDescription topic = EntityHelper.getTopicDescription(topicOptions);
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(topic);
        CreateTopicBody createEntity = new CreateTopicBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.putWithResponseAsync(topicName, createEntity, null, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeTopic);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteQueueWithResponse(String queueName, Context context) {
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null"));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be an empty string."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.deleteWithResponseAsync(queueName, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null"));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        if (subscriptionName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscriptionName' cannot be null"));
        }
        if (subscriptionName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be an empty string."));
        }
        if (ruleName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'ruleName' cannot be null"));
        }
        if (ruleName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'ruleName' cannot be an empty string."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.rulesClient.deleteWithResponseAsync(topicName, subscriptionName, ruleName, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        if (subscriptionName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscriptionName' cannot be null"));
        }
        if (subscriptionName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be an empty string."));
        }
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null"));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.managementClient.getSubscriptions().deleteWithResponseAsync(topicName, subscriptionName, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> deleteTopicWithResponse(String topicName, Context context) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null"));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.deleteWithResponseAsync(topicName, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    <T> Mono<Response<Boolean>> getEntityExistsWithResponse(Mono<Response<T>> getEntityOperation) {
        return getEntityOperation.map(response -> {
            boolean exists = response.getValue() != null;
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)exists);
        }).onErrorResume(ResourceNotFoundException.class, exception -> {
            HttpResponse response = exception.getResponse();
            SimpleResponse result = new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)false);
            return Mono.just((Object)result);
        });
    }

    <T> Mono<Response<T>> getQueueWithResponse(String queueName, Context context, Function<QueueProperties, T> mapper) {
        if (queueName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queueName' cannot be null"));
        }
        if (queueName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'queueName' cannot be empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.getWithResponseAsync(queueName, true, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<QueueProperties> deserialize = this.deserializeQueue((Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityNotFoundHttpResponse notFoundResponse = new EntityNotFoundHttpResponse(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Queue '%s' does not exist.", queueName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((QueueProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> getRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.rulesClient.getWithResponseAsync(topicName, subscriptionName, ruleName, true, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(this::deserializeRule);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    <T> Mono<Response<T>> getSubscriptionWithResponse(String topicName, String subscriptionName, Context context, Function<SubscriptionProperties, T> mapper) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null."));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be an empty string."));
        }
        if (subscriptionName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscriptionName' cannot be null."));
        }
        if (subscriptionName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'subscriptionName' cannot be an empty string."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.managementClient.getSubscriptions().getWithResponseAsync(topicName, subscriptionName, true, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<SubscriptionProperties> deserialize = this.deserializeSubscription(topicName, (Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityNotFoundHttpResponse notFoundResponse = new EntityNotFoundHttpResponse(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Subscription '%s' in topic '%s' does not exist.", topicName, subscriptionName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((SubscriptionProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<NamespaceProperties>> getNamespacePropertiesWithResponse(Context context) {
        return this.managementClient.getNamespaces().getWithResponseAsync(context).handle((response, sink) -> {
            NamespacePropertiesEntry entry = (NamespacePropertiesEntry)response.getValue();
            if (entry == null || entry.getContent() == null) {
                sink.error((Throwable)new AzureException("There was no content inside namespace response. Entry: " + response));
                return;
            }
            NamespaceProperties namespaceProperties = entry.getContent().getNamespaceProperties();
            SimpleResponse result = new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)namespaceProperties);
            sink.next((Object)result);
        });
    }

    <T> Mono<Response<T>> getTopicWithResponse(String topicName, Context context, Function<TopicProperties, T> mapper) {
        if (topicName == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topicName' cannot be null"));
        }
        if (topicName.isEmpty()) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("'topicName' cannot be empty."));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.getWithResponseAsync(topicName, true, withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).handle((response, sink) -> {
                Response<TopicProperties> deserialize = this.deserializeTopic((Response<Object>)response);
                if (deserialize.getValue() == null) {
                    EntityNotFoundHttpResponse notFoundResponse = new EntityNotFoundHttpResponse(deserialize);
                    sink.error((Throwable)new ResourceNotFoundException(String.format("Topic '%s' does not exist.", topicName), notFoundResponse));
                } else {
                    Object mapped = mapper.apply((TopicProperties)deserialize.getValue());
                    sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), mapped));
                }
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PagedResponse<QueueProperties>> listQueuesFirstPage(Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.listQueues(0, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<QueueProperties>> listQueuesNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
            int skip = Integer.parseInt(continuationToken);
            return this.listQueues(skip, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<RuleProperties>> listRulesFirstPage(String topicName, String subscriptionName, Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.listRules(topicName, subscriptionName, 0, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<RuleProperties>> listRulesNextPage(String topicName, String subscriptionName, String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
            int skip = Integer.parseInt(continuationToken);
            return this.listRules(topicName, subscriptionName, skip, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<SubscriptionProperties>> listSubscriptionsFirstPage(String topicName, Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.listSubscriptions(topicName, 0, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<SubscriptionProperties>> listSubscriptionsNextPage(String topicName, String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
            int skip = Integer.parseInt(continuationToken);
            return this.listSubscriptions(topicName, skip, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<TopicProperties>> listTopicsFirstPage(Context context) {
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.listTopics(0, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<PagedResponse<TopicProperties>> listTopicsNextPage(String continuationToken, Context context) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        try {
            Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
            int skip = Integer.parseInt(continuationToken);
            return this.listTopics(skip, withTracing);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    Mono<Response<QueueProperties>> updateQueueWithResponse(QueueProperties queue, Context context) {
        String forwardDlqToEntity;
        if (queue == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'queue' cannot be null"));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context contextWithHeaders = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
        String forwardToEntity = queue.getForwardTo();
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            queue.setForwardTo(this.getAbsoluteUrlFromEntity(forwardToEntity));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(forwardDlqToEntity = queue.getForwardDeadLetteredMessagesTo()))) {
            this.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            queue.setForwardDeadLetteredMessagesTo(this.getAbsoluteUrlFromEntity(forwardDlqToEntity));
        }
        QueueDescription queueDescription = EntityHelper.toImplementation(queue);
        CreateQueueBodyContent content = new CreateQueueBodyContent().setType(CONTENT_TYPE).setQueueDescription(queueDescription);
        CreateQueueBody createEntity = new CreateQueueBody().setContent(content);
        try {
            return this.entityClient.putWithResponseAsync(queue.getName(), createEntity, "*", contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeQueue((Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<RuleProperties>> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule, Context context) {
        if (rule == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'rule' cannot be null"));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        RuleDescription implementation = EntityHelper.toImplementation(rule);
        CreateRuleBodyContent content = new CreateRuleBodyContent().setType(CONTENT_TYPE).setRuleDescription(implementation);
        CreateRuleBody ruleBody = new CreateRuleBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.managementClient.getRules().putWithResponseAsync(topicName, subscriptionName, rule.getName(), ruleBody, "*", withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeRule((Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<SubscriptionProperties>> updateSubscriptionWithResponse(SubscriptionProperties subscription, Context context) {
        String forwardDlqToEntity;
        if (subscription == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'subscription' cannot be null"));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        Context contextWithHeaders = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"azure-http-headers-key", (Object)new HttpHeaders());
        String forwardToEntity = subscription.getForwardTo();
        if (!CoreUtils.isNullOrEmpty((CharSequence)forwardToEntity)) {
            this.addSupplementaryAuthHeader("ServiceBusSupplementaryAuthorization", forwardToEntity, contextWithHeaders);
            subscription.setForwardTo(this.getAbsoluteUrlFromEntity(forwardToEntity));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)(forwardDlqToEntity = subscription.getForwardDeadLetteredMessagesTo()))) {
            this.addSupplementaryAuthHeader("ServiceBusDlqSupplementaryAuthorization", forwardDlqToEntity, contextWithHeaders);
            subscription.setForwardDeadLetteredMessagesTo(this.getAbsoluteUrlFromEntity(forwardDlqToEntity));
        }
        String topicName = subscription.getTopicName();
        String subscriptionName = subscription.getSubscriptionName();
        SubscriptionDescription implementation = EntityHelper.toImplementation(subscription);
        CreateSubscriptionBodyContent content = new CreateSubscriptionBodyContent().setType(CONTENT_TYPE).setSubscriptionDescription(implementation);
        CreateSubscriptionBody createEntity = new CreateSubscriptionBody().setContent(content);
        try {
            return this.managementClient.getSubscriptions().putWithResponseAsync(topicName, subscriptionName, createEntity, "*", contextWithHeaders).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeSubscription(topicName, (Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<TopicProperties>> updateTopicWithResponse(TopicProperties topic, Context context) {
        if (topic == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'topic' cannot be null"));
        }
        if (context == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'context' cannot be null."));
        }
        TopicDescription implementation = EntityHelper.toImplementation(topic);
        CreateTopicBodyContent content = new CreateTopicBodyContent().setType(CONTENT_TYPE).setTopicDescription(implementation);
        CreateTopicBody createEntity = new CreateTopicBody().setContent(content);
        Context withTracing = context.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus");
        try {
            return this.entityClient.putWithResponseAsync(topic.getName(), createEntity, "*", withTracing).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).map(response -> this.deserializeTopic((Response<Object>)response));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    private <T> T deserialize(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String contents = String.valueOf(object);
        if (contents.isEmpty()) {
            return null;
        }
        try {
            return this.serializer.deserialize(contents, clazz);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(String.format("Exception while deserializing. Body: [%s]. Class: %s", contents, clazz), e));
        }
    }

    private <T> Response<T> deserialize(Response<Object> response, Class<T> clazz) {
        T deserialize = this.deserialize(response.getValue(), clazz);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), deserialize);
    }

    private Response<QueueProperties> deserializeQueue(Response<Object> response) {
        TopicDescriptionEntry entryTopic;
        QueueDescriptionEntry entry = this.deserialize(response.getValue(), QueueDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getQueueDescription() == null && (entryTopic = this.deserialize(response.getValue(), TopicDescriptionEntry.class)) != null && entryTopic.getContent() != null && entryTopic.getContent().getTopicDescription() != null) {
            this.logger.warning("'{}' is not a queue, it is a topic.", new Object[]{entryTopic.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        QueueProperties result = EntityHelper.toModel(entry.getContent().getQueueDescription());
        String queueName = this.getTitleValue(entry.getTitle());
        EntityHelper.setQueueName(result, queueName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private Response<RuleProperties> deserializeRule(Response<Object> response) {
        RuleDescriptionEntry entry = this.deserialize(response.getValue(), RuleDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.info("entry.getContent() is null. The entity may not exist. {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        RuleDescription description = entry.getContent().getRuleDescription();
        RuleProperties result = EntityHelper.toModel(description);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private Response<SubscriptionProperties> deserializeSubscription(String topicName, Response<Object> response) {
        SubscriptionDescriptionEntry entry = this.deserialize(response.getValue(), SubscriptionDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        SubscriptionProperties subscription = EntityHelper.toModel(entry.getContent().getSubscriptionDescription());
        String subscriptionName = this.getTitleValue(entry.getTitle());
        EntityHelper.setSubscriptionName(subscription, subscriptionName);
        EntityHelper.setTopicName(subscription, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)subscription);
    }

    private Response<TopicProperties> deserializeTopic(Response<Object> response) {
        QueueDescriptionEntry entryQueue;
        TopicDescriptionEntry entry = this.deserialize(response.getValue(), TopicDescriptionEntry.class);
        if (entry == null) {
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent() == null) {
            this.logger.warning("entry.getContent() is null. There should have been content returned. Entry: {}", new Object[]{entry});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        if (entry.getContent().getTopicDescription() == null && (entryQueue = this.deserialize(response.getValue(), QueueDescriptionEntry.class)) != null && entryQueue.getContent() != null && entryQueue.getContent().getQueueDescription() != null) {
            this.logger.warning("'{}' is not a topic, it is a queue.", new Object[]{entryQueue.getTitle()});
            return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null);
        }
        TopicProperties result = EntityHelper.toModel(entry.getContent().getTopicDescription());
        String topicName = this.getTitleValue(entry.getTitle());
        EntityHelper.setTopicName(result, topicName);
        return new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)result);
    }

    private <TResult, TFeed> FeedPage<TResult> extractPage(Response<TFeed> response, List<TResult> entities, List<ResponseLink> responseLinks) throws MalformedURLException, UnsupportedEncodingException {
        Optional<ResponseLink> nextLink = responseLinks.stream().filter(link -> link.getRel().equalsIgnoreCase("next")).findFirst();
        if (!nextLink.isPresent()) {
            return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
        }
        URL url = new URL(nextLink.get().getHref());
        String decode = URLDecoder.decode(url.getQuery(), StandardCharsets.UTF_8.name());
        Optional<Integer> skipParameter = Arrays.stream(decode.split("&amp;|&")).map(part -> part.split("=", 2)).filter(parts -> parts[0].equalsIgnoreCase("$skip") && ((String[])parts).length == 2).map(parts -> Integer.valueOf(parts[1])).findFirst();
        if (skipParameter.isPresent()) {
            return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities, skipParameter.get());
        }
        this.logger.warning("There should have been a skip parameter for the next page.");
        return new FeedPage(response.getStatusCode(), response.getHeaders(), response.getRequest(), entities);
    }

    private Mono<PagedResponse<QueueProperties>> listQueues(int skip, Context context) {
        return this.managementClient.listEntitiesWithResponseAsync(QUEUES_ENTITY_TYPE, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<QueueDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, QueueDescriptionFeed.class);
            QueueDescriptionFeed feed = (QueueDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                this.logger.warning("Could not deserialize QueueDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List entities = feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getQueueDescription() != null).map(e -> {
                String queueName = this.getTitleValue(e.getTitle());
                QueueProperties queueProperties = EntityHelper.toModel(e.getContent().getQueueDescription());
                EntityHelper.setQueueName(queueProperties, queueName);
                return queueProperties;
            }).collect(Collectors.toList());
            try {
                return Mono.just(this.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<QueueDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<RuleProperties>> listRules(String topicName, String subscriptionName, int skip, Context context) {
        return this.managementClient.listRulesWithResponseAsync(topicName, subscriptionName, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<RuleDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, RuleDescriptionFeed.class);
            RuleDescriptionFeed feed = (RuleDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                this.logger.warning("Could not deserialize RuleDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List entities = feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getRuleDescription() != null).map(e -> EntityHelper.toModel(e.getContent().getRuleDescription())).collect(Collectors.toList());
            try {
                return Mono.just(this.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<RuleDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<SubscriptionProperties>> listSubscriptions(String topicName, int skip, Context context) {
        return this.managementClient.listSubscriptionsWithResponseAsync(topicName, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<SubscriptionDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, SubscriptionDescriptionFeed.class);
            SubscriptionDescriptionFeed feed = (SubscriptionDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                this.logger.warning("Could not deserialize SubscriptionDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List entities = feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getSubscriptionDescription() != null).map(e -> {
                String subscriptionName = this.getTitleValue(e.getTitle());
                SubscriptionProperties description = EntityHelper.toModel(e.getContent().getSubscriptionDescription());
                EntityHelper.setTopicName(description, topicName);
                EntityHelper.setSubscriptionName(description, subscriptionName);
                return description;
            }).collect(Collectors.toList());
            try {
                return Mono.just(this.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<SubscriptionDescription>", error));
            }
        });
    }

    private Mono<PagedResponse<TopicProperties>> listTopics(int skip, Context context) {
        return this.managementClient.listEntitiesWithResponseAsync(TOPICS_ENTITY_TYPE, skip, 100, context).onErrorMap(ServiceBusAdministrationAsyncClient::mapException).flatMap(response -> {
            Response<TopicDescriptionFeed> feedResponse = this.deserialize((Response<Object>)response, TopicDescriptionFeed.class);
            TopicDescriptionFeed feed = (TopicDescriptionFeed)feedResponse.getValue();
            if (feed == null) {
                this.logger.warning("Could not deserialize TopicDescriptionFeed. skip {}, top: {}", new Object[]{skip, 100});
                return Mono.empty();
            }
            List entities = feed.getEntry().stream().filter(e -> e.getContent() != null && e.getContent().getTopicDescription() != null).map(e -> {
                String topicName = this.getTitleValue(e.getTitle());
                TopicProperties topicProperties = EntityHelper.toModel(e.getContent().getTopicDescription());
                EntityHelper.setTopicName(topicProperties, topicName);
                return topicProperties;
            }).collect(Collectors.toList());
            try {
                return Mono.just(this.extractPage(feedResponse, entities, feed.getLink()));
            }
            catch (UnsupportedEncodingException | MalformedURLException error) {
                return Mono.error((Throwable)new RuntimeException("Could not parse response into FeedPage<TopicDescription>", error));
            }
        });
    }

    private void addSupplementaryAuthHeader(String headerName, String entity, Context context) {
        context.getData((Object)"azure-http-headers-key").ifPresent(headers -> {
            if (headers instanceof HttpHeaders) {
                HttpHeaders customHttpHeaders = (HttpHeaders)headers;
                customHttpHeaders.add(headerName, entity);
            }
        });
    }

    private String getAbsoluteUrlFromEntity(String entity) {
        try {
            URL url = new URL(entity);
            return url.toString();
        }
        catch (MalformedURLException url) {
            UrlBuilder urlBuilder = new UrlBuilder();
            urlBuilder.setScheme("https");
            urlBuilder.setHost(this.managementClient.getEndpoint());
            urlBuilder.setPath(entity);
            try {
                URL url2 = urlBuilder.toUrl();
                return url2.toString();
            }
            catch (MalformedURLException ex) {
                this.logger.error("Failed to construct URL using the endpoint:'{}' and entity:'{}'", new Object[]{this.managementClient.getEndpoint(), entity});
                this.logger.logThrowableAsError((Throwable)ex);
                return null;
            }
        }
    }

    private String getTitleValue(Object responseTitle) {
        if (!(responseTitle instanceof Map)) {
            return null;
        }
        try {
            Map map = (Map)responseTitle;
            return (String)map.get("");
        }
        catch (ClassCastException error) {
            this.logger.warning("Unable to cast to Map<String,String>. Title: {}", new Object[]{responseTitle, error});
            return null;
        }
    }

    private static Throwable mapException(Throwable exception) {
        if (!(exception instanceof ServiceBusManagementErrorException)) {
            return exception;
        }
        ServiceBusManagementErrorException managementError = (ServiceBusManagementErrorException)((Object)exception);
        ServiceBusManagementError error = managementError.getValue();
        HttpResponse errorHttpResponse = managementError.getResponse();
        int statusCode = error != null && error.getCode() != null ? error.getCode().intValue() : errorHttpResponse.getStatusCode();
        String errorDetail = error != null && error.getDetail() != null ? error.getDetail() : managementError.getMessage();
        switch (statusCode) {
            case 401: {
                return new ClientAuthenticationException(errorDetail, managementError.getResponse(), exception);
            }
            case 404: {
                return new ResourceNotFoundException(errorDetail, managementError.getResponse(), exception);
            }
            case 409: {
                return new ResourceExistsException(errorDetail, managementError.getResponse(), exception);
            }
            case 412: {
                return new ResourceModifiedException(errorDetail, managementError.getResponse(), exception);
            }
        }
        return new HttpResponseException(errorDetail, managementError.getResponse(), exception);
    }

    private static final class EntityNotFoundHttpResponse<T>
    extends HttpResponse {
        private final int statusCode;
        private final HttpHeaders headers;

        private EntityNotFoundHttpResponse(Response<T> response) {
            super(response.getRequest());
            this.headers = response.getHeaders();
            this.statusCode = response.getStatusCode();
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getHeaderValue(String name) {
            return this.headers.getValue(name);
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    }

    private static final class FeedPage<T>
    implements PagedResponse<T> {
        private final int statusCode;
        private final HttpHeaders header;
        private final HttpRequest request;
        private final IterableStream<T> entries;
        private final String continuationToken;

        private FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = null;
        }

        private FeedPage(int statusCode, HttpHeaders header, HttpRequest request, List<T> entries, int skip) {
            this.statusCode = statusCode;
            this.header = header;
            this.request = request;
            this.entries = new IterableStream(entries);
            this.continuationToken = String.valueOf(skip);
        }

        public IterableStream<T> getElements() {
            return this.entries;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.header;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public void close() {
        }
    }
}

