/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CorrelationRuleFilter
extends RuleFilter {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String correlationId;
    private String contentType;
    private String label;
    private String messageId;
    private String replyTo;
    private String replyToSessionId;
    private String sessionId;
    private String to;

    public CorrelationRuleFilter() {
        this.correlationId = null;
    }

    public CorrelationRuleFilter(String correlationId) {
        ClientLogger logger = new ClientLogger(CorrelationRuleFilter.class);
        if (correlationId == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("'correlationId' cannot be null"));
        }
        if (correlationId.isEmpty()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'correlationId' cannot be empty."));
        }
        this.correlationId = correlationId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public CorrelationRuleFilter setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public CorrelationRuleFilter setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public CorrelationRuleFilter setLabel(String label) {
        this.label = label;
        return this;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public CorrelationRuleFilter setMessageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public CorrelationRuleFilter setReplyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    public String getReplyToSessionId() {
        return this.replyToSessionId;
    }

    public CorrelationRuleFilter setReplyToSessionId(String replyToSessionId) {
        this.replyToSessionId = replyToSessionId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public CorrelationRuleFilter setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getTo() {
        return this.to;
    }

    public CorrelationRuleFilter setTo(String to) {
        this.to = to;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CorrelationRuleFilter: ");
        boolean isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(true, builder, "sys.CorrelationId", this.correlationId);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.MessageId", this.messageId);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.To", this.to);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.ReplyTo", this.replyTo);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.Label", this.label);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.SessionId", this.sessionId);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.ReplyToSessionId", this.replyToSessionId);
        isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, "sys.ContentType", this.contentType);
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            isFirstExpression = CorrelationRuleFilter.appendPropertyExpression(isFirstExpression, builder, entry.getKey(), entry.getValue().toString());
        }
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CorrelationRuleFilter)) {
            return false;
        }
        CorrelationRuleFilter that = (CorrelationRuleFilter)other;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.correlationId, that.correlationId) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.label, that.label) && Objects.equals(this.messageId, that.messageId) && Objects.equals(this.replyTo, that.replyTo) && Objects.equals(this.replyToSessionId, that.replyToSessionId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.correlationId, this.messageId, this.sessionId);
    }

    private static boolean appendPropertyExpression(boolean isFirstExpression, StringBuilder builder, String display, String value) {
        if (value == null) {
            return true;
        }
        if (!isFirstExpression) {
            builder.append(" AND ");
        }
        builder.append(String.format("%s = '%s'", display, value));
        return false;
    }
}

