/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SqlRuleFilter
extends RuleFilter {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final String sqlExpression;
    private final String compatibilityLevel;
    private final Boolean requiresPreprocessing;

    public SqlRuleFilter(String sqlExpression) {
        ClientLogger logger = new ClientLogger(SqlRuleFilter.class);
        if (sqlExpression == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("'sqlExpression' cannot be null."));
        }
        if (sqlExpression.isEmpty()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sqlExpression' cannot be an empty string."));
        }
        this.sqlExpression = sqlExpression;
        this.compatibilityLevel = null;
        this.requiresPreprocessing = null;
    }

    SqlRuleFilter(String sqlExpression, String compatibilityLevel, Boolean requiresPreprocessing) {
        this.sqlExpression = sqlExpression;
        this.compatibilityLevel = compatibilityLevel;
        this.requiresPreprocessing = requiresPreprocessing;
    }

    String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    Boolean isPreprocessingRequired() {
        return this.requiresPreprocessing;
    }

    public Map<String, Object> getParameters() {
        return this.properties;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    public String toString() {
        return String.format("SqlRuleFilter: %s", this.sqlExpression);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlRuleFilter)) {
            return false;
        }
        SqlRuleFilter that = (SqlRuleFilter)other;
        return this.sqlExpression.equals(that.sqlExpression) && Objects.equals(this.compatibilityLevel, that.compatibilityLevel) && Objects.equals(this.requiresPreprocessing, that.requiresPreprocessing) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return this.sqlExpression.hashCode();
    }
}

