/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationAsyncClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.NamespaceProperties;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.QueueRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.SubscriptionRuntimeProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.administration.models.TopicRuntimeProperties;
import java.util.Objects;
import java.util.function.Function;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ServiceBusAdministrationClientBuilder.class)
public final class ServiceBusAdministrationClient {
    private final ServiceBusAdministrationAsyncClient asyncClient;

    ServiceBusAdministrationClient(ServiceBusAdministrationAsyncClient asyncClient) {
        this.asyncClient = Objects.requireNonNull(asyncClient, "'asyncClient' cannot be null.");
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName) {
        return (QueueProperties)this.asyncClient.createQueue(queueName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties createQueue(String queueName, CreateQueueOptions queueOptions) {
        return (QueueProperties)this.asyncClient.createQueue(queueName, queueOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> createQueueWithResponse(String queueName, CreateQueueOptions queueOptions, Context context) {
        return (Response)this.asyncClient.createQueueWithResponse(queueName, queueOptions, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String subscriptionName, String ruleName) {
        return (RuleProperties)this.asyncClient.createRule(topicName, subscriptionName, ruleName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties createRule(String topicName, String ruleName, String subscriptionName, CreateRuleOptions ruleOptions) {
        return (RuleProperties)this.asyncClient.createRule(topicName, subscriptionName, ruleName, ruleOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> createRuleWithResponse(String topicName, String subscriptionName, String ruleName, CreateRuleOptions ruleOptions, Context context) {
        return (Response)this.asyncClient.createRuleWithResponse(topicName, subscriptionName, ruleName, ruleOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName) {
        return (SubscriptionProperties)this.asyncClient.createSubscription(topicName, subscriptionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties createSubscription(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions) {
        return (SubscriptionProperties)this.asyncClient.createSubscription(topicName, subscriptionName, subscriptionOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> createSubscriptionWithResponse(String topicName, String subscriptionName, CreateSubscriptionOptions subscriptionOptions, Context context) {
        return (Response)this.asyncClient.createSubscriptionWithResponse(topicName, subscriptionName, subscriptionOptions, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName) {
        return (TopicProperties)this.asyncClient.createTopic(topicName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties createTopic(String topicName, CreateTopicOptions topicOptions) {
        return (TopicProperties)this.asyncClient.createTopic(topicName, topicOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> createTopicWithResponse(String topicName, CreateTopicOptions topicOptions, Context context) {
        return (Response)this.asyncClient.createTopicWithResponse(topicName, topicOptions, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteQueue(String queueName) {
        this.asyncClient.deleteQueue(queueName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteQueueWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.deleteQueueWithResponse(queueName, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRule(String topicName, String subscriptionName, String ruleName) {
        this.asyncClient.deleteRule(topicName, subscriptionName, ruleName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        return (Response)this.asyncClient.deleteRuleWithResponse(topicName, subscriptionName, ruleName, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSubscription(String topicName, String subscriptionName) {
        this.asyncClient.deleteSubscription(topicName, subscriptionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        return (Response)this.asyncClient.deleteSubscriptionWithResponse(topicName, subscriptionName, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteTopic(String topicName) {
        this.asyncClient.deleteTopic(topicName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteTopicWithResponse(String topicName, Context context) {
        return (Response)this.asyncClient.deleteTopicWithResponse(topicName, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties getQueue(String queueName) {
        return (QueueProperties)this.asyncClient.getQueue(queueName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> getQueueWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.getQueueWithResponse(queueName, context != null ? context : Context.NONE, Function.identity()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getQueueExists(String queueName) {
        Boolean exists = (Boolean)this.asyncClient.getQueueExists(queueName).block();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getQueueExistsWithResponse(String queueName, Context context) {
        Mono queueWithResponse = this.asyncClient.getQueueWithResponse(queueName, context != null ? context : Context.NONE, Function.identity());
        return (Response)this.asyncClient.getEntityExistsWithResponse(queueWithResponse).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueRuntimeProperties getQueueRuntimeProperties(String queueName) {
        return (QueueRuntimeProperties)this.asyncClient.getQueueRuntimeProperties(queueName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueRuntimeProperties> getQueueRuntimePropertiesWithResponse(String queueName, Context context) {
        return (Response)this.asyncClient.getQueueWithResponse(queueName, context != null ? context : Context.NONE, QueueRuntimeProperties::new).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NamespaceProperties getNamespaceProperties() {
        return (NamespaceProperties)this.asyncClient.getNamespaceProperties().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NamespaceProperties> getNamespacePropertiesWithResponse(Context context) {
        return (Response)this.asyncClient.getNamespacePropertiesWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties getRule(String topicName, String subscriptionName, String ruleName) {
        return (RuleProperties)this.asyncClient.getRule(topicName, subscriptionName, ruleName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> getRuleWithResponse(String topicName, String subscriptionName, String ruleName, Context context) {
        return (Response)this.asyncClient.getRuleWithResponse(topicName, subscriptionName, ruleName, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties getSubscription(String topicName, String subscriptionName) {
        return (SubscriptionProperties)this.asyncClient.getSubscription(topicName, subscriptionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> getSubscriptionWithResponse(String topicName, String subscriptionName, Context context) {
        return (Response)this.asyncClient.getSubscriptionWithResponse(topicName, subscriptionName, context != null ? context : Context.NONE, Function.identity()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getSubscriptionExists(String topicName, String subscriptionName) {
        Boolean exists = (Boolean)this.asyncClient.getSubscriptionExists(topicName, subscriptionName).block();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getSubscriptionExistsWithResponse(String topicName, String subscriptionName, Context context) {
        Mono subscriptionWithResponse = this.asyncClient.getSubscriptionWithResponse(topicName, subscriptionName, context != null ? context : Context.NONE, Function.identity());
        return (Response)this.asyncClient.getEntityExistsWithResponse(subscriptionWithResponse).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionRuntimeProperties getSubscriptionRuntimeProperties(String topicName, String subscriptionName) {
        return (SubscriptionRuntimeProperties)this.asyncClient.getSubscriptionRuntimeProperties(topicName, subscriptionName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionRuntimeProperties> getSubscriptionRuntimePropertiesWithResponse(String topicName, String subscriptionName, Context context) {
        return (Response)this.asyncClient.getSubscriptionWithResponse(topicName, subscriptionName, context != null ? context : Context.NONE, SubscriptionRuntimeProperties::new).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties getTopic(String topicName) {
        return (TopicProperties)this.asyncClient.getTopic(topicName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> getTopicWithResponse(String topicName, Context context) {
        return (Response)this.asyncClient.getTopicWithResponse(topicName, context != null ? context : Context.NONE, Function.identity()).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public boolean getTopicExists(String topicName) {
        Boolean exists = (Boolean)this.asyncClient.getTopicExists(topicName).block();
        return exists != null && exists != false;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Boolean> getTopicExistsWithResponse(String topicName, Context context) {
        Mono topicWithResponse = this.asyncClient.getTopicWithResponse(topicName, context != null ? context : Context.NONE, Function.identity());
        return (Response)this.asyncClient.getEntityExistsWithResponse(topicWithResponse).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicRuntimeProperties getTopicRuntimeProperties(String topicName) {
        return (TopicRuntimeProperties)this.asyncClient.getTopicRuntimeProperties(topicName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicRuntimeProperties> getTopicRuntimePropertiesWithResponse(String topicName, Context context) {
        return (Response)this.asyncClient.getTopicWithResponse(topicName, context != null ? context : Context.NONE, TopicRuntimeProperties::new).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues() {
        return new PagedIterable(this.asyncClient.listQueues());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<QueueProperties> listQueues(Context context) {
        PagedFlux pagedFlux = new PagedFlux(() -> this.asyncClient.listQueuesFirstPage(context), continuationToken -> this.asyncClient.listQueuesNextPage((String)continuationToken, context != null ? context : Context.NONE));
        return new PagedIterable(pagedFlux);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RuleProperties> listRules(String topicName, String subscriptionName) {
        return new PagedIterable(this.asyncClient.listRules(topicName, subscriptionName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName) {
        return new PagedIterable(this.asyncClient.listSubscriptions(topicName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SubscriptionProperties> listSubscriptions(String topicName, Context context) {
        PagedFlux pagedFlux = new PagedFlux(() -> this.asyncClient.listSubscriptionsFirstPage(topicName, context != null ? context : Context.NONE), continuationToken -> this.asyncClient.listSubscriptionsNextPage(topicName, (String)continuationToken, context != null ? context : Context.NONE));
        return new PagedIterable(pagedFlux);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics() {
        return new PagedIterable(this.asyncClient.listTopics());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TopicProperties> listTopics(Context context) {
        PagedFlux pagedFlux = new PagedFlux(() -> this.asyncClient.listTopicsFirstPage(context), continuationToken -> this.asyncClient.listTopicsNextPage((String)continuationToken, context != null ? context : Context.NONE));
        return new PagedIterable(pagedFlux);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public QueueProperties updateQueue(QueueProperties queue) {
        return (QueueProperties)this.asyncClient.updateQueue(queue).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<QueueProperties> updateQueueWithResponse(QueueProperties queue, Context context) {
        return (Response)this.asyncClient.updateQueueWithResponse(queue, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RuleProperties updateRule(String topicName, String subscriptionName, RuleProperties rule) {
        return (RuleProperties)this.asyncClient.updateRule(topicName, subscriptionName, rule).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RuleProperties> updateRuleWithResponse(String topicName, String subscriptionName, RuleProperties rule, Context context) {
        return (Response)this.asyncClient.updateRuleWithResponse(topicName, subscriptionName, rule, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SubscriptionProperties updateSubscription(SubscriptionProperties subscription) {
        return (SubscriptionProperties)this.asyncClient.updateSubscription(subscription).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SubscriptionProperties> updateSubscriptionWithResponse(SubscriptionProperties subscription, Context context) {
        return (Response)this.asyncClient.updateSubscriptionWithResponse(subscription, context != null ? context : Context.NONE).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TopicProperties updateTopic(TopicProperties topic) {
        return (TopicProperties)this.asyncClient.updateTopic(topic).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TopicProperties> updateTopicWithResponse(TopicProperties topic, Context context) {
        return (Response)this.asyncClient.updateTopicWithResponse(topic, context != null ? context : Context.NONE).block();
    }
}

