/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.implementation.EntityHelper;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.models.EntityAvailabilityStatus;
import com.azure.messaging.servicebus.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.implementation.models.SubscriptionDescription;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class SubscriptionProperties {
    private Duration lockDuration;
    private final boolean requiresSession;
    private Duration defaultMessageTimeToLive;
    private boolean deadLetteringOnMessageExpiration;
    private boolean deadLetteringOnFilterEvaluationExceptions;
    private int messageCount;
    private int maxDeliveryCount;
    private boolean enableBatchedOperations;
    private EntityStatus status;
    private String forwardTo;
    private final OffsetDateTime createdAt;
    private final OffsetDateTime updatedAt;
    private final OffsetDateTime accessedAt;
    private final MessageCountDetails messageCountDetails;
    private String userMetadata;
    private String forwardDeadLetteredMessagesTo;
    private Duration autoDeleteOnIdle;
    private final EntityAvailabilityStatus entityAvailabilityStatus;
    private String topicName;
    private String subscriptionName;

    SubscriptionProperties(SubscriptionDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        this.accessedAt = description.getAccessedAt();
        this.autoDeleteOnIdle = description.getAutoDeleteOnIdle();
        this.createdAt = description.getCreatedAt();
        this.defaultMessageTimeToLive = description.getDefaultMessageTimeToLive();
        this.deadLetteringOnMessageExpiration = MessageUtils.toPrimitive(description.isDeadLetteringOnMessageExpiration());
        this.deadLetteringOnFilterEvaluationExceptions = MessageUtils.toPrimitive(description.isDeadLetteringOnFilterEvaluationExceptions());
        this.enableBatchedOperations = MessageUtils.toPrimitive(description.isEnableBatchedOperations());
        this.entityAvailabilityStatus = description.getEntityAvailabilityStatus();
        this.forwardTo = description.getForwardTo();
        this.forwardDeadLetteredMessagesTo = description.getForwardDeadLetteredMessagesTo();
        this.lockDuration = description.getLockDuration();
        this.maxDeliveryCount = MessageUtils.toPrimitive(description.getMaxDeliveryCount());
        this.messageCount = MessageUtils.toPrimitive(description.getMessageCount());
        this.messageCountDetails = description.getMessageCountDetails();
        this.requiresSession = MessageUtils.toPrimitive(description.isRequiresSession());
        this.status = description.getStatus();
        this.updatedAt = description.getUpdatedAt();
        this.userMetadata = description.getUserMetadata();
    }

    public String getTopicName() {
        return this.topicName;
    }

    SubscriptionProperties setTopicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    SubscriptionProperties setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public SubscriptionProperties setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public boolean isSessionRequired() {
        return this.requiresSession;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public SubscriptionProperties setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public SubscriptionProperties setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public boolean isDeadLetteringOnFilterEvaluationExceptions() {
        return this.deadLetteringOnFilterEvaluationExceptions;
    }

    public SubscriptionProperties setEnableDeadLetteringOnFilterEvaluationExceptions(boolean deadLetteringOnFilterEvaluationExceptions) {
        this.deadLetteringOnFilterEvaluationExceptions = deadLetteringOnFilterEvaluationExceptions;
        return this;
    }

    int getMessageCount() {
        return this.messageCount;
    }

    SubscriptionProperties setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public SubscriptionProperties setMaxDeliveryCount(int maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public SubscriptionProperties setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public SubscriptionProperties setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public SubscriptionProperties setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    MessageCountDetails getMessageCountDetails() {
        return this.messageCountDetails;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public SubscriptionProperties setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public SubscriptionProperties setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public SubscriptionProperties setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    EntityAvailabilityStatus getEntityAvailabilityStatus() {
        return this.entityAvailabilityStatus;
    }

    static {
        EntityHelper.setSubscriptionAccessor(new EntityHelper.SubscriptionAccessor(){

            @Override
            public SubscriptionProperties toModel(SubscriptionDescription description) {
                return new SubscriptionProperties(description);
            }

            @Override
            public SubscriptionDescription toImplementation(SubscriptionProperties subscription) {
                return new SubscriptionDescription().setAccessedAt(subscription.getAccessedAt()).setAutoDeleteOnIdle(subscription.getAutoDeleteOnIdle()).setCreatedAt(subscription.getCreatedAt()).setDeadLetteringOnFilterEvaluationExceptions(subscription.isDeadLetteringOnFilterEvaluationExceptions()).setDeadLetteringOnMessageExpiration(subscription.isDeadLetteringOnMessageExpiration()).setDefaultMessageTimeToLive(subscription.getDefaultMessageTimeToLive()).setEnableBatchedOperations(subscription.enableBatchedOperations).setEntityAvailabilityStatus(subscription.entityAvailabilityStatus).setForwardTo(subscription.getForwardTo()).setForwardDeadLetteredMessagesTo(subscription.getForwardDeadLetteredMessagesTo()).setLockDuration(subscription.getLockDuration()).setMaxDeliveryCount(subscription.getMaxDeliveryCount()).setMessageCount(subscription.messageCount).setMessageCountDetails(subscription.getMessageCountDetails()).setStatus(subscription.getStatus()).setRequiresSession(subscription.isSessionRequired()).setUpdatedAt(subscription.getUpdatedAt()).setUserMetadata(subscription.getUserMetadata());
            }

            @Override
            public void setTopicName(SubscriptionProperties subscriptionProperties, String topicName) {
                subscriptionProperties.setTopicName(topicName);
            }

            @Override
            public void setSubscriptionName(SubscriptionProperties subscriptionProperties, String subscriptionName) {
                subscriptionProperties.setSubscriptionName(subscriptionName);
            }
        });
    }
}

