/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.core.amqp.implementation.MessageSerializer;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.ReceiverOptions;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.ServiceBusReceiveLinkProcessor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ServiceBusAsyncConsumer
implements AutoCloseable {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceBusAsyncConsumer.class);
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final String linkName;
    private final ServiceBusReceiveLinkProcessor linkProcessor;
    private final MessageSerializer messageSerializer;
    private final Flux<ServiceBusReceivedMessage> processor;

    ServiceBusAsyncConsumer(String linkName, ServiceBusReceiveLinkProcessor linkProcessor, MessageSerializer messageSerializer, ReceiverOptions receiverOptions) {
        this.linkName = linkName;
        this.linkProcessor = linkProcessor;
        this.messageSerializer = messageSerializer;
        this.processor = linkProcessor.map(message -> (ServiceBusReceivedMessage)this.messageSerializer.deserialize(message, ServiceBusReceivedMessage.class));
    }

    String getLinkName() {
        return this.linkName;
    }

    Flux<ServiceBusReceivedMessage> receive() {
        return this.processor;
    }

    Mono<Void> updateDisposition(String lockToken, DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        DeliveryState deliveryState = MessageUtils.getDeliveryState(dispositionStatus, deadLetterReason, deadLetterErrorDescription, propertiesToModify, transactionContext);
        if (deliveryState == null) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)new IllegalArgumentException("'dispositionStatus' is not known. status: " + (Object)((Object)dispositionStatus)));
        }
        return this.linkProcessor.updateDisposition(lockToken, deliveryState);
    }

    @Override
    public void close() {
        if (!this.isDisposed.getAndSet(true)) {
            this.linkProcessor.dispose();
        }
    }
}

