/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;

@ServiceClientBuilder(serviceClients={ServiceBusManagementClientImpl.class})
public final class ServiceBusManagementClientImplBuilder {
    private String endpoint;
    private String apiVersion;
    private HttpPipeline pipeline;
    private SerializerAdapter serializerAdapter;

    public ServiceBusManagementClientImplBuilder endpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ServiceBusManagementClientImplBuilder apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public ServiceBusManagementClientImplBuilder pipeline(HttpPipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public ServiceBusManagementClientImplBuilder serializerAdapter(SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        return this;
    }

    public ServiceBusManagementClientImpl buildClient() {
        if (this.pipeline == null) {
            this.pipeline = new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build();
        }
        if (this.serializerAdapter == null) {
            this.serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
        }
        ServiceBusManagementClientImpl client = new ServiceBusManagementClientImpl(this.pipeline, this.serializerAdapter, this.endpoint, this.apiVersion);
        return client;
    }
}

