/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.WebPubSubAsyncServiceClient;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebPubSubAsyncGroup {
    private final ClientLogger logger = new ClientLogger(WebPubSubAsyncGroup.class);
    private final WebPubSubsImpl webPubSubApis;
    private final String hub;
    private final String group;

    WebPubSubAsyncGroup(WebPubSubsImpl webPubSubApis, String hub, String group) {
        this.webPubSubApis = webPubSubApis;
        this.hub = hub;
        this.group = group;
    }

    public Mono<Void> sendToAll(String message) {
        return this.sendToAll(message, null);
    }

    public Mono<Void> sendToAll(String message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(message, contentType, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds) {
        return FluxUtil.withContext(context -> this.sendToAllWithResponse(message, contentType, excludedConnectionIds, (Context)context));
    }

    Mono<Response<Void>> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_JSON : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.webPubSubApis.sendToGroupWithResponseAsync(this.hub, this.group, message, excludedConnectionIds, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Broadcasting message")).doOnSuccess(response -> this.logger.verbose("Broadcasted message, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to broadcast message, response: {}", new Object[]{error}));
            }
        }
        return this.sendToAllWithResponse(message.getBytes(StandardCharsets.UTF_8), contentType, excludedConnectionIds, context);
    }

    public Mono<Void> sendToAll(byte[] message) {
        return this.sendToAll(message, null);
    }

    public Mono<Void> sendToAll(byte[] message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(message, contentType, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds) {
        return FluxUtil.withContext(context -> this.sendToAllWithResponse(message, contentType, excludedConnectionIds, (Context)context));
    }

    Mono<Response<Void>> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_OCTET_STREAM : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.sendToAllWithResponse(new String(message, StandardCharsets.UTF_8), contentType, excludedConnectionIds, context);
            }
        }
        Flux byteFlux = Flux.just((Object)ByteBuffer.wrap(message));
        return this.webPubSubApis.sendToGroupWithResponseAsync(this.hub, this.group, contentType, (Flux<ByteBuffer>)byteFlux, message.length, excludedConnectionIds, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Broadcasting binary message")).doOnSuccess(response -> this.logger.verbose("Broadcasted binary message, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to broadcast binary message, response: {}", new Object[]{error}));
    }

    public Mono<Void> addUser(String userId) {
        return this.addUserWithResponse(userId, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> addUserWithResponse(String userId) {
        return FluxUtil.withContext(context -> this.addUserWithResponse(userId, (Context)context));
    }

    Mono<Response<Void>> addUserWithResponse(String userId, Context context) {
        return this.webPubSubApis.addUserToGroupWithResponseAsync(this.hub, this.group, userId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Adding user '{}'", new Object[]{userId})).doOnSuccess(response -> this.logger.verbose("Added user '{}', response: {}", new Object[]{userId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to add user '{}', response: {}", new Object[]{userId, error}));
    }

    public Mono<Void> removeUser(String userId) {
        return this.removeUserWithResponse(userId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> removeUserWithResponse(String userId) {
        return FluxUtil.withContext(context -> this.removeUserWithResponse(userId, (Context)context));
    }

    Mono<Response<Void>> removeUserWithResponse(String userId, Context context) {
        return this.webPubSubApis.removeUserFromGroupWithResponseAsync(this.hub, this.group, userId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Removing user '{}'", new Object[]{userId})).doOnSuccess(response -> this.logger.verbose("Removed user '{}', response: {}", new Object[]{userId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to remove user '{}', response: {}", new Object[]{userId, error}));
    }

    public Mono<Void> addConnection(String connectionId) {
        return this.addConnectionWithResponse(connectionId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> addConnectionWithResponse(String connectionId) {
        return FluxUtil.withContext(context -> this.addConnectionWithResponse(connectionId, (Context)context));
    }

    Mono<Response<Void>> addConnectionWithResponse(String connectionId, Context context) {
        return this.webPubSubApis.addConnectionToGroupWithResponseAsync(this.hub, this.group, connectionId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Adding connection '{}'", new Object[]{connectionId})).doOnSuccess(response -> this.logger.verbose("Added connection '{}', response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to add connection '{}', response: {}", new Object[]{connectionId, error}));
    }

    public Mono<Void> removeConnection(String connectionId) {
        return this.removeConnectionWithResponse(connectionId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> removeConnectionWithResponse(String connectionId) {
        return FluxUtil.withContext(context -> this.removeConnectionWithResponse(connectionId, (Context)context));
    }

    Mono<Response<Void>> removeConnectionWithResponse(String connectionId, Context context) {
        return this.webPubSubApis.removeConnectionFromGroupWithResponseAsync(this.hub, this.group, connectionId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Removing connection '{}'", new Object[]{connectionId})).doOnSuccess(response -> this.logger.verbose("Removed connection '{}', response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to remove connection '{}', response: {}", new Object[]{connectionId, error}));
    }
}

