/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.WebPubSubAsyncGroup;
import com.azure.messaging.webpubsub.WebPubSubAuthenticationPolicy;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;
import com.azure.messaging.webpubsub.models.GetAuthenticationTokenOptions;
import com.azure.messaging.webpubsub.models.WebPubSubAuthenticationToken;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebPubSubAsyncServiceClient {
    static final String TRACING_NAMESPACE_VALUE = "Microsoft.SignalRService";
    private final ClientLogger logger = new ClientLogger(WebPubSubAsyncServiceClient.class);
    private final WebPubSubsImpl webPubSubApis;
    private final String hub;
    private final String endpoint;
    private final WebPubSubAuthenticationPolicy webPubSubAuthPolicy;
    private final WebPubSubServiceVersion serviceVersion;

    WebPubSubAsyncServiceClient(WebPubSubsImpl webPubSubApis, String hub, String endpoint, WebPubSubAuthenticationPolicy webPubSubAuthPolicy, WebPubSubServiceVersion serviceVersion) {
        this.webPubSubApis = webPubSubApis;
        this.hub = hub;
        this.endpoint = endpoint;
        this.webPubSubAuthPolicy = webPubSubAuthPolicy;
        this.serviceVersion = serviceVersion;
    }

    static Context configureTracing(Context context) {
        return (context == null ? Context.NONE : context).addData((Object)"az.namespace", (Object)TRACING_NAMESPACE_VALUE);
    }

    public WebPubSubAsyncGroup getAsyncGroup(String group) {
        return new WebPubSubAsyncGroup(this.webPubSubApis, this.hub, group);
    }

    public WebPubSubAuthenticationToken getAuthenticationToken(GetAuthenticationTokenOptions options) {
        String endpoint = this.endpoint.endsWith("/") ? this.endpoint : this.endpoint + "/";
        String audience = endpoint + "client/hubs/" + this.hub;
        String authToken = WebPubSubAuthenticationPolicy.getAuthenticationToken(audience, options, this.webPubSubAuthPolicy.getCredential());
        String clientEndpoint = endpoint.replaceFirst("http", "ws");
        String clientUrl = clientEndpoint + "client/hubs/" + this.hub;
        String url = clientUrl + "?access_token=" + authToken;
        return new WebPubSubAuthenticationToken(authToken, url);
    }

    public Mono<Void> sendToAll(String message) {
        return this.sendToAllWithResponse(message, null, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToAll(String message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(message, contentType, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds) {
        return FluxUtil.withContext(context -> this.sendToAllWithResponse(message, contentType, excludedConnectionIds, (Context)context));
    }

    Mono<Response<Void>> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_JSON : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.webPubSubApis.sendToAllWithResponseAsync(this.hub, message, excludedConnectionIds, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Broadcasting message")).doOnSuccess(response -> this.logger.verbose("Broadcasted message, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to broadcast message, response: {}", new Object[]{error}));
            }
        }
        return this.sendToAllWithResponse(message.getBytes(StandardCharsets.UTF_8), contentType, excludedConnectionIds, context);
    }

    public Mono<Void> sendToAll(byte[] message) {
        return this.sendToAllWithResponse(message, null, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToAll(byte[] message, WebPubSubContentType contentType) {
        return this.sendToAllWithResponse(message, contentType, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds) {
        return FluxUtil.withContext(context -> this.sendToAllWithResponse(message, contentType, excludedConnectionIds, (Context)context));
    }

    Mono<Response<Void>> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_OCTET_STREAM : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.sendToAllWithResponse(new String(message, StandardCharsets.UTF_8), contentType, excludedConnectionIds, context);
            }
        }
        Flux byteFlux = Flux.just((Object)ByteBuffer.wrap(message));
        return this.webPubSubApis.sendToAllWithResponseAsync(this.hub, contentType, (Flux<ByteBuffer>)byteFlux, message.length, excludedConnectionIds, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Broadcasting binary data")).doOnSuccess(response -> this.logger.verbose("Broadcasted binary data, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to broadcast binary data, response: {}", new Object[]{error}));
    }

    public Mono<Void> sendToUser(String userId, String message) {
        return this.sendToUserWithResponse(userId, message, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToUser(String userId, String message, WebPubSubContentType contentType) {
        return this.sendToUserWithResponse(userId, message, contentType).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToUserWithResponse(String userId, String message, WebPubSubContentType contentType) {
        return FluxUtil.withContext(context -> this.sendToUserWithResponse(userId, message, contentType, (Context)context));
    }

    Mono<Response<Void>> sendToUserWithResponse(String userId, String message, WebPubSubContentType contentType, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_JSON : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.webPubSubApis.sendToUserWithResponseAsync(this.hub, userId, message, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Sending to user '{}'", new Object[]{userId, message})).doOnSuccess(response -> this.logger.verbose("Sent to user '{}', response: {}", new Object[]{userId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to send message to user '{}', response: {}", new Object[]{message, userId, error}));
            }
        }
        return this.sendToUserWithResponse(userId, message.getBytes(StandardCharsets.UTF_8), contentType, context);
    }

    public Mono<Void> sendToUser(String userId, byte[] message) {
        return this.sendToUserWithResponse(userId, message, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToUser(String userId, byte[] message, WebPubSubContentType contentType) {
        return this.sendToUserWithResponse(userId, message, contentType).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToUserWithResponse(String userId, byte[] message, WebPubSubContentType contentType) {
        return FluxUtil.withContext(context -> this.sendToUserWithResponse(userId, message, contentType, (Context)context));
    }

    Mono<Response<Void>> sendToUserWithResponse(String userId, byte[] message, WebPubSubContentType contentType, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_OCTET_STREAM : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.sendToUserWithResponse(userId, new String(message, StandardCharsets.UTF_8), contentType, context);
            }
        }
        Flux byteFlux = Flux.just((Object)ByteBuffer.wrap(message));
        return this.webPubSubApis.sendToUserWithResponseAsync(this.hub, userId, contentType, (Flux<ByteBuffer>)byteFlux, message.length, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Sending binary data to user")).doOnSuccess(response -> this.logger.verbose("Sent binary data to user, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to send binary data to user, response: {}", new Object[]{error}));
    }

    public Mono<Void> sendToConnection(String connectionId, String message) {
        return this.sendToConnectionWithResponse(connectionId, message, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToConnection(String connectionId, String message, WebPubSubContentType contentType) {
        return this.sendToConnectionWithResponse(connectionId, message, contentType).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, String message, WebPubSubContentType contentType) {
        return FluxUtil.withContext(context -> this.sendToConnectionWithResponse(connectionId, message, contentType, (Context)context));
    }

    Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, String message, WebPubSubContentType contentType, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_JSON : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.webPubSubApis.sendToConnectionWithResponseAsync(this.hub, connectionId, message, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Sending to connection '{}'", new Object[]{connectionId})).doOnSuccess(response -> this.logger.verbose("Sent to connection '{}', response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to send message to connection '{}', response: {}", new Object[]{connectionId, error}));
            }
        }
        return this.sendToConnectionWithResponse(connectionId, message.getBytes(StandardCharsets.UTF_8), contentType, context);
    }

    public Mono<Void> sendToConnection(String connectionId, byte[] message) {
        return this.sendToConnectionWithResponse(connectionId, message, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Void> sendToConnection(String connectionId, byte[] message, WebPubSubContentType contentType) {
        return this.sendToConnectionWithResponse(connectionId, message, contentType).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, byte[] message, WebPubSubContentType contentType) {
        return FluxUtil.withContext(context -> this.sendToConnectionWithResponse(connectionId, message, contentType, (Context)context));
    }

    Mono<Response<Void>> sendToConnectionWithResponse(String connectionId, byte[] message, WebPubSubContentType contentType, Context context) {
        contentType = contentType == null ? WebPubSubContentType.APPLICATION_OCTET_STREAM : contentType;
        switch (contentType) {
            case TEXT_PLAIN: {
                return this.sendToConnectionWithResponse(connectionId, new String(message, StandardCharsets.UTF_8), contentType, context);
            }
        }
        Flux byteFlux = Flux.just((Object)ByteBuffer.wrap(message));
        return this.webPubSubApis.sendToConnectionWithResponseAsync(this.hub, connectionId, contentType, (Flux<ByteBuffer>)byteFlux, message.length, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Sending binary message to connection")).doOnSuccess(response -> this.logger.verbose("Sent binary message to connection, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to send binary message to connection, response: {}", new Object[]{error}));
    }

    public Mono<Void> removeUserFromAllGroups(String userId) {
        return this.removeUserFromAllGroupsWithResponse(userId).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> removeUserFromAllGroupsWithResponse(String userId) {
        return FluxUtil.withContext(context -> this.removeUserFromAllGroupsWithResponse(userId, (Context)context));
    }

    Mono<Response<Void>> removeUserFromAllGroupsWithResponse(String userId, Context context) {
        return this.webPubSubApis.removeUserFromAllGroupsWithResponseAsync(this.hub, userId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Removing user '{}' from all groups")).doOnSuccess(response -> this.logger.verbose("Removed user '{}' from all groups, response: {}", new Object[]{response.getValue()})).doOnError(error -> this.logger.warning("Failed to remove user '{}' from all groups, response: {}", new Object[]{error}));
    }

    public Mono<Boolean> checkUserExists(String userId) {
        return this.checkUserExistsWithResponse(userId).map(Response::getValue);
    }

    public Mono<Response<Boolean>> checkUserExistsWithResponse(String userId) {
        return FluxUtil.withContext(context -> this.checkUserExistsWithResponse(userId, (Context)context));
    }

    Mono<Response<Boolean>> checkUserExistsWithResponse(String userId, Context context) {
        return this.webPubSubApis.userExistsWithResponseAsync(this.hub, userId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Checking if user '{}' exists", new Object[]{userId})).doOnSuccess(response -> this.logger.verbose("Checked if user '{}' exists, response: {}", new Object[]{userId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to check if user '{}' exists, response: {}", new Object[]{userId, error}));
    }

    public Mono<Boolean> checkGroupExists(String group) {
        return this.checkGroupExistsWithResponse(group).map(Response::getValue);
    }

    public Mono<Response<Boolean>> checkGroupExistsWithResponse(String group) {
        return FluxUtil.withContext(context -> this.checkGroupExistsWithResponse(group, (Context)context));
    }

    Mono<Response<Boolean>> checkGroupExistsWithResponse(String group, Context context) {
        return this.webPubSubApis.groupExistsWithResponseAsync(this.hub, group, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Checking if group '{}' exists", new Object[]{group})).doOnSuccess(response -> this.logger.verbose("Checked if group '{}' exists, response: {}", new Object[]{group, response.getValue()})).doOnError(error -> this.logger.warning("Failed to check if group '{}' exists, response: {}", new Object[]{group, error}));
    }

    public Mono<Void> closeConnection(String connectionId) {
        return this.closeConnectionWithResponse(connectionId, null).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<Void>> closeConnectionWithResponse(String connectionId, String reason) {
        return FluxUtil.withContext(context -> this.closeConnectionWithResponse(connectionId, reason, (Context)context));
    }

    Mono<Response<Void>> closeConnectionWithResponse(String connectionId, String reason, Context context) {
        return this.webPubSubApis.closeClientConnectionWithResponseAsync(this.hub, connectionId, reason, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Closing connection {}", new Object[]{connectionId})).doOnSuccess(response -> this.logger.verbose("Closed connection {}, response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to close connection {}, response: {}", new Object[]{connectionId, error}));
    }

    public Mono<Boolean> checkConnectionExists(String connectionId) {
        return this.checkConnectionExistsWithResponse(connectionId).map(Response::getValue);
    }

    public Mono<Response<Boolean>> checkConnectionExistsWithResponse(String connectionId) {
        return FluxUtil.withContext(context -> this.checkConnectionExistsWithResponse(connectionId, (Context)context));
    }

    Mono<Response<Boolean>> checkConnectionExistsWithResponse(String connectionId, Context context) {
        return this.webPubSubApis.connectionExistsWithResponseAsync(this.hub, connectionId, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Checking if connection '{}' exists", new Object[]{connectionId})).doOnSuccess(response -> this.logger.verbose("Checked if connection '{}' exists, response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to check if connection '{}' exists, response: {}", new Object[]{connectionId, error}));
    }

    public Mono<Boolean> checkPermissionExists(WebPubSubPermission permission, String connectionId, String targetName) {
        return this.checkPermissionExistsWithResponse(permission, connectionId, targetName).map(Response::getValue);
    }

    public Mono<Response<Boolean>> checkPermissionExistsWithResponse(WebPubSubPermission permission, String connectionId, String targetName) {
        return FluxUtil.withContext(context -> this.checkPermissionExistsWithResponse(permission, connectionId, targetName, (Context)context));
    }

    Mono<Response<Boolean>> checkPermissionExistsWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.webPubSubApis.checkPermissionWithResponseAsync(this.hub, permission, connectionId, targetName, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Checking if permission '{}' exists for connection '{}'", new Object[]{permission, connectionId})).doOnSuccess(response -> this.logger.verbose("Checked if permission '{}' exists, response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to check if permission '{}' exists, response: {}", new Object[]{connectionId, error}));
    }

    public Mono<Void> grantPermission(WebPubSubPermission permission, String connectionId) {
        return this.grantPermissionWithResponse(permission, connectionId, null).map(Response::getValue);
    }

    public Mono<Response<Void>> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName) {
        return FluxUtil.withContext(context -> this.grantPermissionWithResponse(permission, connectionId, targetName, (Context)context));
    }

    Mono<Response<Void>> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.webPubSubApis.grantPermissionWithResponseAsync(this.hub, permission, connectionId, targetName, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Granting permission '{}' for connection '{}'", new Object[]{permission, connectionId})).doOnSuccess(response -> this.logger.verbose("Granted permission '{}', response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to grant permission '{}', response: {}", new Object[]{connectionId, error}));
    }

    public Mono<Void> revokePermission(WebPubSubPermission permission, String connectionId) {
        return this.revokePermissionWithResponse(permission, connectionId, null).map(Response::getValue);
    }

    public Mono<Response<Void>> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName) {
        return FluxUtil.withContext(context -> this.revokePermissionWithResponse(permission, connectionId, targetName, (Context)context));
    }

    Mono<Response<Void>> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.webPubSubApis.revokePermissionWithResponseAsync(this.hub, permission, connectionId, targetName, WebPubSubAsyncServiceClient.configureTracing(context)).doOnSubscribe(ignoredValue -> this.logger.verbose("Revoking permission '{}' for connection '{}'", new Object[]{permission, connectionId})).doOnSuccess(response -> this.logger.verbose("Revoked permission '{}', response: {}", new Object[]{connectionId, response.getValue()})).doOnError(error -> this.logger.warning("Failed to revoke permission '{}', response: {}", new Object[]{connectionId, error}));
    }
}

