/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.messaging.webpubsub.WebPubSubAsyncGroup;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;

public final class WebPubSubGroup {
    private final WebPubSubAsyncGroup asyncGroupClient;

    WebPubSubGroup(WebPubSubAsyncGroup asyncGroupClient) {
        this.asyncGroupClient = asyncGroupClient;
    }

    public void sendToAll(String message) {
        this.sendToAll(message, null);
    }

    public void sendToAll(String message, WebPubSubContentType contentType) {
        this.sendToAllWithResponse(message, contentType, null, Context.NONE);
    }

    public Response<Void> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        return (Response)this.asyncGroupClient.sendToAllWithResponse(message, contentType, excludedConnectionIds, context).block();
    }

    public void sendToAll(byte[] message) {
        this.sendToAll(message, null);
    }

    public void sendToAll(byte[] message, WebPubSubContentType contentType) {
        this.sendToAllWithResponse(message, contentType, null, Context.NONE);
    }

    public Response<Void> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        return (Response)this.asyncGroupClient.sendToAllWithResponse(message, contentType, excludedConnectionIds, context).block();
    }

    public void addUser(String userId) {
        this.addUserWithResponse(userId, Context.NONE);
    }

    public Response<Void> addUserWithResponse(String userId, Context context) {
        return (Response)this.asyncGroupClient.addUserWithResponse(userId, context).block();
    }

    public void removeUser(String userId) {
        this.removeUserWithResponse(userId, Context.NONE);
    }

    public Response<Void> removeUserWithResponse(String userId, Context context) {
        return (Response)this.asyncGroupClient.removeUserWithResponse(userId, context).block();
    }

    public void addConnection(String connectionId) {
        this.addConnectionWithResponse(connectionId, Context.NONE);
    }

    public Response<Void> addConnectionWithResponse(String connectionId, Context context) {
        return (Response)this.asyncGroupClient.addConnectionWithResponse(connectionId, context).block();
    }

    public void removeConnection(String connectionId) {
        this.removeConnectionWithResponse(connectionId, Context.NONE);
    }

    public Response<Void> removeConnectionWithResponse(String connectionId, Context context) {
        return (Response)this.asyncGroupClient.removeConnectionWithResponse(connectionId, context).block();
    }
}

