/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.messaging.webpubsub.WebPubSubAsyncServiceClient;
import com.azure.messaging.webpubsub.WebPubSubGroup;
import com.azure.messaging.webpubsub.models.GetAuthenticationTokenOptions;
import com.azure.messaging.webpubsub.models.WebPubSubAuthenticationToken;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;

public final class WebPubSubServiceClient {
    private final WebPubSubAsyncServiceClient asyncClient;

    WebPubSubServiceClient(WebPubSubAsyncServiceClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public WebPubSubGroup getGroup(String group) {
        return new WebPubSubGroup(this.asyncClient.getAsyncGroup(group));
    }

    public WebPubSubAuthenticationToken getAuthenticationToken(GetAuthenticationTokenOptions options) {
        return this.asyncClient.getAuthenticationToken(options);
    }

    public void sendToAll(String message) {
        this.sendToAll(message, null);
    }

    public void sendToAll(String message, WebPubSubContentType contentType) {
        this.sendToAllWithResponse(message, contentType, null, Context.NONE);
    }

    public Response<Void> sendToAllWithResponse(String message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        return (Response)this.asyncClient.sendToAllWithResponse(message, contentType, excludedConnectionIds, context).block();
    }

    public void sendToAll(byte[] message) {
        this.sendToAll(message, null);
    }

    public void sendToAll(byte[] message, WebPubSubContentType contentType) {
        this.sendToAllWithResponse(message, contentType, null, Context.NONE);
    }

    public Response<Void> sendToAllWithResponse(byte[] message, WebPubSubContentType contentType, Iterable<String> excludedConnectionIds, Context context) {
        return (Response)this.asyncClient.sendToAllWithResponse(message, contentType, excludedConnectionIds, context).block();
    }

    public void sendToUser(String userId, String message) {
        this.sendToUser(userId, message, null);
    }

    public void sendToUser(String userId, String message, WebPubSubContentType contentType) {
        this.sendToUserWithResponse(userId, message, contentType, Context.NONE);
    }

    public Response<Void> sendToUserWithResponse(String userId, String message, WebPubSubContentType contentType, Context context) {
        return (Response)this.asyncClient.sendToUserWithResponse(userId, message, contentType, context).block();
    }

    public void sendToUser(String userId, byte[] message) {
        this.sendToUser(userId, message, null);
    }

    public void sendToUser(String userId, byte[] message, WebPubSubContentType contentType) {
        this.sendToUserWithResponse(userId, message, contentType, Context.NONE);
    }

    public Response<Void> sendToUserWithResponse(String userId, byte[] message, WebPubSubContentType contentType, Context context) {
        return (Response)this.asyncClient.sendToUserWithResponse(userId, message, contentType, context).block();
    }

    public void sendToConnection(String connectionId, String message) {
        this.sendToConnection(connectionId, message, null);
    }

    public void sendToConnection(String connectionId, String message, WebPubSubContentType contentType) {
        this.sendToConnectionWithResponse(connectionId, message, contentType, Context.NONE);
    }

    public Response<Void> sendToConnectionWithResponse(String connectionId, String message, WebPubSubContentType contentType, Context context) {
        return (Response)this.asyncClient.sendToConnectionWithResponse(connectionId, message, contentType, context).block();
    }

    public void sendToConnection(String connectionId, byte[] message) {
        this.sendToConnection(connectionId, message, null);
    }

    public void sendToConnection(String connectionId, byte[] message, WebPubSubContentType contentType) {
        this.sendToConnectionWithResponse(connectionId, message, contentType, Context.NONE);
    }

    public Response<Void> sendToConnectionWithResponse(String connectionId, byte[] message, WebPubSubContentType contentType, Context context) {
        return (Response)this.asyncClient.sendToConnectionWithResponse(connectionId, message, contentType, context).block();
    }

    public void removeUserFromAllGroups(String userId) {
        this.removeUserFromAllGroupsWithResponse(userId, Context.NONE);
    }

    public Response<Void> removeUserFromAllGroupsWithResponse(String userId, Context context) {
        return (Response)this.asyncClient.removeUserFromAllGroupsWithResponse(userId, context).block();
    }

    public boolean checkUserExists(String userId) {
        return (Boolean)this.checkUserExistsWithResponse(userId, Context.NONE).getValue();
    }

    public Response<Boolean> checkUserExistsWithResponse(String userId, Context context) {
        return (Response)this.asyncClient.checkUserExistsWithResponse(userId, context).block();
    }

    public boolean checkGroupExists(String group) {
        return (Boolean)this.checkGroupExistsWithResponse(group, Context.NONE).getValue();
    }

    public Response<Boolean> checkGroupExistsWithResponse(String group, Context context) {
        return (Response)this.asyncClient.checkGroupExistsWithResponse(group, context).block();
    }

    public void closeConnection(String connectionId) {
        this.closeConnectionWithResponse(connectionId, null, Context.NONE);
    }

    public Response<Void> closeConnectionWithResponse(String connectionId, String reason, Context context) {
        return (Response)this.asyncClient.closeConnectionWithResponse(connectionId, reason, context).block();
    }

    public boolean checkConnectionExists(String connectionId) {
        return (Boolean)this.checkConnectionExistsWithResponse(connectionId, Context.NONE).getValue();
    }

    public Response<Boolean> checkConnectionExistsWithResponse(String connectionId, Context context) {
        return (Response)this.asyncClient.checkConnectionExistsWithResponse(connectionId, context).block();
    }

    public boolean checkPermissionExists(WebPubSubPermission permission, String connectionId, String targetName) {
        return (Boolean)this.checkPermissionExistsWithResponse(permission, connectionId, targetName, Context.NONE).getValue();
    }

    public Response<Boolean> checkPermissionExistsWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.asyncClient.checkPermissionExistsWithResponse(permission, connectionId, targetName, context).block();
    }

    public void grantPermission(WebPubSubPermission permission, String connectionId) {
        this.grantPermissionWithResponse(permission, connectionId, null, Context.NONE).getValue();
    }

    public Response<Void> grantPermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.asyncClient.grantPermissionWithResponse(permission, connectionId, targetName, context).block();
    }

    public void revokePermission(WebPubSubPermission permission, String connectionId) {
        this.revokePermissionWithResponse(permission, connectionId, null, Context.NONE);
    }

    public Response<Void> revokePermissionWithResponse(WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.asyncClient.revokePermissionWithResponse(permission, connectionId, targetName, context).block();
    }
}

