/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.implementation.HealthApisImpl;
import com.azure.messaging.webpubsub.implementation.WebPubSubsImpl;

public final class AzureWebPubSubServiceRestAPIImpl {
    private final String host;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final HealthApisImpl healthApis;
    private final WebPubSubsImpl webPubSubs;

    public String getHost() {
        return this.host;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public HealthApisImpl getHealthApis() {
        return this.healthApis;
    }

    public WebPubSubsImpl getWebPubSubs() {
        return this.webPubSubs;
    }

    AzureWebPubSubServiceRestAPIImpl(String host, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), host, apiVersion);
    }

    AzureWebPubSubServiceRestAPIImpl(HttpPipeline httpPipeline, String host, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), host, apiVersion);
    }

    AzureWebPubSubServiceRestAPIImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String host, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.host = host;
        this.apiVersion = apiVersion;
        this.healthApis = new HealthApisImpl(this);
        this.webPubSubs = new WebPubSubsImpl(this);
    }
}

