/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.implementation.AzureWebPubSubServiceRestAPIImpl;
import reactor.core.publisher.Mono;

public final class HealthApisImpl {
    private final HealthApisService service;
    private final AzureWebPubSubServiceRestAPIImpl client;

    HealthApisImpl(AzureWebPubSubServiceRestAPIImpl client) {
        this.service = (HealthApisService)RestProxy.create(HealthApisService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<Void>> getHealthStatusWithResponseAsync() {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getHealthStatus(this.client.getHost(), this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> getHealthStatusWithResponseAsync(Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        return this.service.getHealthStatus(this.client.getHost(), this.client.getApiVersion(), context);
    }

    public Mono<Void> getHealthStatusAsync() {
        return this.getHealthStatusWithResponseAsync().flatMap(res -> Mono.empty());
    }

    public Mono<Void> getHealthStatusAsync(Context context) {
        return this.getHealthStatusWithResponseAsync(context).flatMap(res -> Mono.empty());
    }

    public void getHealthStatus() {
        this.getHealthStatusAsync().block();
    }

    public Response<Void> getHealthStatusWithResponse(Context context) {
        return (Response)this.getHealthStatusWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureWebPubSubServic")
    public static interface HealthApisService {
        @Head(value="/api/health")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> getHealthStatus(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);
    }
}

