/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.webpubsub.implementation.AzureWebPubSubServiceRestAPIImpl;
import com.azure.messaging.webpubsub.models.WebPubSubContentType;
import com.azure.messaging.webpubsub.models.WebPubSubPermission;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebPubSubsImpl {
    private final WebPubSubsService service;
    private final AzureWebPubSubServiceRestAPIImpl client;

    WebPubSubsImpl(AzureWebPubSubServiceRestAPIImpl client) {
        this.service = (WebPubSubsService)RestProxy.create(WebPubSubsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<Void>> sendToAllWithResponseAsync(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToAll(this.client.getHost(), hub, excluded, this.client.getApiVersion(), contentType, message, contentLength, (Context)context));
    }

    public Mono<Response<Void>> sendToAllWithResponseAsync(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToAll(this.client.getHost(), hub, excluded, this.client.getApiVersion(), contentType, message, contentLength, context);
    }

    public Mono<Void> sendToAllAsync(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        return this.sendToAllWithResponseAsync(hub, contentType, message, contentLength, excluded).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToAllAsync(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        return this.sendToAllWithResponseAsync(hub, contentType, message, contentLength, excluded, context).flatMap(res -> Mono.empty());
    }

    public void sendToAll(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        this.sendToAllAsync(hub, contentType, message, contentLength, excluded).block();
    }

    public Response<Void> sendToAllWithResponse(String hub, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        return (Response)this.sendToAllWithResponseAsync(hub, contentType, message, contentLength, excluded, context).block();
    }

    public Mono<Response<Void>> sendToAllWithResponseAsync(String hub, String message, Iterable<String> excluded) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToAll(this.client.getHost(), hub, excluded, this.client.getApiVersion(), message, (Context)context));
    }

    public Mono<Response<Void>> sendToAllWithResponseAsync(String hub, String message, Iterable<String> excluded, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToAll(this.client.getHost(), hub, excluded, this.client.getApiVersion(), message, context);
    }

    public Mono<Void> sendToAllAsync(String hub, String message, Iterable<String> excluded) {
        return this.sendToAllWithResponseAsync(hub, message, excluded).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToAllAsync(String hub, String message, Iterable<String> excluded, Context context) {
        return this.sendToAllWithResponseAsync(hub, message, excluded, context).flatMap(res -> Mono.empty());
    }

    public void sendToAll(String hub, String message, Iterable<String> excluded) {
        this.sendToAllAsync(hub, message, excluded).block();
    }

    public Response<Void> sendToAllWithResponse(String hub, String message, Iterable<String> excluded, Context context) {
        return (Response)this.sendToAllWithResponseAsync(hub, message, excluded, context).block();
    }

    public Mono<Response<Boolean>> connectionExistsWithResponseAsync(String hub, String connectionId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.connectionExists(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Boolean>> connectionExistsWithResponseAsync(String hub, String connectionId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.connectionExists(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), context);
    }

    public Mono<Boolean> connectionExistsAsync(String hub, String connectionId) {
        return this.connectionExistsWithResponseAsync(hub, connectionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> connectionExistsAsync(String hub, String connectionId, Context context) {
        return this.connectionExistsWithResponseAsync(hub, connectionId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public boolean connectionExists(String hub, String connectionId) {
        Boolean value = (Boolean)this.connectionExistsAsync(hub, connectionId).block();
        if (value != null) {
            return value;
        }
        throw new NullPointerException();
    }

    public Response<Boolean> connectionExistsWithResponse(String hub, String connectionId, Context context) {
        return (Response)this.connectionExistsWithResponseAsync(hub, connectionId, context).block();
    }

    public Mono<Response<Void>> closeClientConnectionWithResponseAsync(String hub, String connectionId, String reason) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.closeClientConnection(this.client.getHost(), hub, connectionId, reason, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> closeClientConnectionWithResponseAsync(String hub, String connectionId, String reason, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.closeClientConnection(this.client.getHost(), hub, connectionId, reason, this.client.getApiVersion(), context);
    }

    public Mono<Void> closeClientConnectionAsync(String hub, String connectionId, String reason) {
        return this.closeClientConnectionWithResponseAsync(hub, connectionId, reason).flatMap(res -> Mono.empty());
    }

    public Mono<Void> closeClientConnectionAsync(String hub, String connectionId, String reason, Context context) {
        return this.closeClientConnectionWithResponseAsync(hub, connectionId, reason, context).flatMap(res -> Mono.empty());
    }

    public void closeClientConnection(String hub, String connectionId, String reason) {
        this.closeClientConnectionAsync(hub, connectionId, reason).block();
    }

    public Response<Void> closeClientConnectionWithResponse(String hub, String connectionId, String reason, Context context) {
        return (Response)this.closeClientConnectionWithResponseAsync(hub, connectionId, reason, context).block();
    }

    public Mono<Response<Void>> sendToConnectionWithResponseAsync(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToConnection(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), contentType, message, contentLength, (Context)context));
    }

    public Mono<Response<Void>> sendToConnectionWithResponseAsync(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToConnection(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), contentType, message, contentLength, context);
    }

    public Mono<Void> sendToConnectionAsync(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        return this.sendToConnectionWithResponseAsync(hub, connectionId, contentType, message, contentLength).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToConnectionAsync(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        return this.sendToConnectionWithResponseAsync(hub, connectionId, contentType, message, contentLength, context).flatMap(res -> Mono.empty());
    }

    public void sendToConnection(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        this.sendToConnectionAsync(hub, connectionId, contentType, message, contentLength).block();
    }

    public Response<Void> sendToConnectionWithResponse(String hub, String connectionId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        return (Response)this.sendToConnectionWithResponseAsync(hub, connectionId, contentType, message, contentLength, context).block();
    }

    public Mono<Response<Void>> sendToConnectionWithResponseAsync(String hub, String connectionId, String message) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToConnection(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), message, (Context)context));
    }

    public Mono<Response<Void>> sendToConnectionWithResponseAsync(String hub, String connectionId, String message, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToConnection(this.client.getHost(), hub, connectionId, this.client.getApiVersion(), message, context);
    }

    public Mono<Void> sendToConnectionAsync(String hub, String connectionId, String message) {
        return this.sendToConnectionWithResponseAsync(hub, connectionId, message).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToConnectionAsync(String hub, String connectionId, String message, Context context) {
        return this.sendToConnectionWithResponseAsync(hub, connectionId, message, context).flatMap(res -> Mono.empty());
    }

    public void sendToConnection(String hub, String connectionId, String message) {
        this.sendToConnectionAsync(hub, connectionId, message).block();
    }

    public Response<Void> sendToConnectionWithResponse(String hub, String connectionId, String message, Context context) {
        return (Response)this.sendToConnectionWithResponseAsync(hub, connectionId, message, context).block();
    }

    public Mono<Response<Boolean>> groupExistsWithResponseAsync(String hub, String group) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.groupExists(this.client.getHost(), hub, group, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Boolean>> groupExistsWithResponseAsync(String hub, String group, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        return this.service.groupExists(this.client.getHost(), hub, group, this.client.getApiVersion(), context);
    }

    public Mono<Boolean> groupExistsAsync(String hub, String group) {
        return this.groupExistsWithResponseAsync(hub, group).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> groupExistsAsync(String hub, String group, Context context) {
        return this.groupExistsWithResponseAsync(hub, group, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public boolean groupExists(String hub, String group) {
        Boolean value = (Boolean)this.groupExistsAsync(hub, group).block();
        if (value != null) {
            return value;
        }
        throw new NullPointerException();
    }

    public Response<Boolean> groupExistsWithResponse(String hub, String group, Context context) {
        return (Response)this.groupExistsWithResponseAsync(hub, group, context).block();
    }

    public Mono<Response<Void>> sendToGroupWithResponseAsync(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToGroup(this.client.getHost(), hub, group, excluded, this.client.getApiVersion(), contentType, message, contentLength, (Context)context));
    }

    public Mono<Response<Void>> sendToGroupWithResponseAsync(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToGroup(this.client.getHost(), hub, group, excluded, this.client.getApiVersion(), contentType, message, contentLength, context);
    }

    public Mono<Void> sendToGroupAsync(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        return this.sendToGroupWithResponseAsync(hub, group, contentType, message, contentLength, excluded).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToGroupAsync(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        return this.sendToGroupWithResponseAsync(hub, group, contentType, message, contentLength, excluded, context).flatMap(res -> Mono.empty());
    }

    public void sendToGroup(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded) {
        this.sendToGroupAsync(hub, group, contentType, message, contentLength, excluded).block();
    }

    public Response<Void> sendToGroupWithResponse(String hub, String group, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Iterable<String> excluded, Context context) {
        return (Response)this.sendToGroupWithResponseAsync(hub, group, contentType, message, contentLength, excluded, context).block();
    }

    public Mono<Response<Void>> sendToGroupWithResponseAsync(String hub, String group, String message, Iterable<String> excluded) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToGroup(this.client.getHost(), hub, group, excluded, this.client.getApiVersion(), message, (Context)context));
    }

    public Mono<Response<Void>> sendToGroupWithResponseAsync(String hub, String group, String message, Iterable<String> excluded, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToGroup(this.client.getHost(), hub, group, excluded, this.client.getApiVersion(), message, context);
    }

    public Mono<Void> sendToGroupAsync(String hub, String group, String message, Iterable<String> excluded) {
        return this.sendToGroupWithResponseAsync(hub, group, message, excluded).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToGroupAsync(String hub, String group, String message, Iterable<String> excluded, Context context) {
        return this.sendToGroupWithResponseAsync(hub, group, message, excluded, context).flatMap(res -> Mono.empty());
    }

    public void sendToGroup(String hub, String group, String message, Iterable<String> excluded) {
        this.sendToGroupAsync(hub, group, message, excluded).block();
    }

    public Response<Void> sendToGroupWithResponse(String hub, String group, String message, Iterable<String> excluded, Context context) {
        return (Response)this.sendToGroupWithResponseAsync(hub, group, message, excluded, context).block();
    }

    public Mono<Response<Void>> addConnectionToGroupWithResponseAsync(String hub, String group, String connectionId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.addConnectionToGroup(this.client.getHost(), hub, group, connectionId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> addConnectionToGroupWithResponseAsync(String hub, String group, String connectionId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.addConnectionToGroup(this.client.getHost(), hub, group, connectionId, this.client.getApiVersion(), context);
    }

    public Mono<Void> addConnectionToGroupAsync(String hub, String group, String connectionId) {
        return this.addConnectionToGroupWithResponseAsync(hub, group, connectionId).flatMap(res -> Mono.empty());
    }

    public Mono<Void> addConnectionToGroupAsync(String hub, String group, String connectionId, Context context) {
        return this.addConnectionToGroupWithResponseAsync(hub, group, connectionId, context).flatMap(res -> Mono.empty());
    }

    public void addConnectionToGroup(String hub, String group, String connectionId) {
        this.addConnectionToGroupAsync(hub, group, connectionId).block();
    }

    public Response<Void> addConnectionToGroupWithResponse(String hub, String group, String connectionId, Context context) {
        return (Response)this.addConnectionToGroupWithResponseAsync(hub, group, connectionId, context).block();
    }

    public Mono<Response<Void>> removeConnectionFromGroupWithResponseAsync(String hub, String group, String connectionId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeConnectionFromGroup(this.client.getHost(), hub, group, connectionId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> removeConnectionFromGroupWithResponseAsync(String hub, String group, String connectionId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.removeConnectionFromGroup(this.client.getHost(), hub, group, connectionId, this.client.getApiVersion(), context);
    }

    public Mono<Void> removeConnectionFromGroupAsync(String hub, String group, String connectionId) {
        return this.removeConnectionFromGroupWithResponseAsync(hub, group, connectionId).flatMap(res -> Mono.empty());
    }

    public Mono<Void> removeConnectionFromGroupAsync(String hub, String group, String connectionId, Context context) {
        return this.removeConnectionFromGroupWithResponseAsync(hub, group, connectionId, context).flatMap(res -> Mono.empty());
    }

    public void removeConnectionFromGroup(String hub, String group, String connectionId) {
        this.removeConnectionFromGroupAsync(hub, group, connectionId).block();
    }

    public Response<Void> removeConnectionFromGroupWithResponse(String hub, String group, String connectionId, Context context) {
        return (Response)this.removeConnectionFromGroupWithResponseAsync(hub, group, connectionId, context).block();
    }

    public Mono<Response<Boolean>> userExistsWithResponseAsync(String hub, String userId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.userExists(this.client.getHost(), hub, userId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Boolean>> userExistsWithResponseAsync(String hub, String userId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.userExists(this.client.getHost(), hub, userId, this.client.getApiVersion(), context);
    }

    public Mono<Boolean> userExistsAsync(String hub, String userId) {
        return this.userExistsWithResponseAsync(hub, userId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> userExistsAsync(String hub, String userId, Context context) {
        return this.userExistsWithResponseAsync(hub, userId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public boolean userExists(String hub, String userId) {
        Boolean value = (Boolean)this.userExistsAsync(hub, userId).block();
        if (value != null) {
            return value;
        }
        throw new NullPointerException();
    }

    public Response<Boolean> userExistsWithResponse(String hub, String userId, Context context) {
        return (Response)this.userExistsWithResponseAsync(hub, userId, context).block();
    }

    public Mono<Response<Void>> sendToUserWithResponseAsync(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToUser(this.client.getHost(), hub, userId, this.client.getApiVersion(), contentType, message, contentLength, (Context)context));
    }

    public Mono<Response<Void>> sendToUserWithResponseAsync(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (contentType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contentType is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToUser(this.client.getHost(), hub, userId, this.client.getApiVersion(), contentType, message, contentLength, context);
    }

    public Mono<Void> sendToUserAsync(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        return this.sendToUserWithResponseAsync(hub, userId, contentType, message, contentLength).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToUserAsync(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        return this.sendToUserWithResponseAsync(hub, userId, contentType, message, contentLength, context).flatMap(res -> Mono.empty());
    }

    public void sendToUser(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength) {
        this.sendToUserAsync(hub, userId, contentType, message, contentLength).block();
    }

    public Response<Void> sendToUserWithResponse(String hub, String userId, WebPubSubContentType contentType, Flux<ByteBuffer> message, long contentLength, Context context) {
        return (Response)this.sendToUserWithResponseAsync(hub, userId, contentType, message, contentLength, context).block();
    }

    public Mono<Response<Void>> sendToUserWithResponseAsync(String hub, String userId, String message) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.sendToUser(this.client.getHost(), hub, userId, this.client.getApiVersion(), message, (Context)context));
    }

    public Mono<Response<Void>> sendToUserWithResponseAsync(String hub, String userId, String message, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (message == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter message is required and cannot be null."));
        }
        return this.service.sendToUser(this.client.getHost(), hub, userId, this.client.getApiVersion(), message, context);
    }

    public Mono<Void> sendToUserAsync(String hub, String userId, String message) {
        return this.sendToUserWithResponseAsync(hub, userId, message).flatMap(res -> Mono.empty());
    }

    public Mono<Void> sendToUserAsync(String hub, String userId, String message, Context context) {
        return this.sendToUserWithResponseAsync(hub, userId, message, context).flatMap(res -> Mono.empty());
    }

    public void sendToUser(String hub, String userId, String message) {
        this.sendToUserAsync(hub, userId, message).block();
    }

    public Response<Void> sendToUserWithResponse(String hub, String userId, String message, Context context) {
        return (Response)this.sendToUserWithResponseAsync(hub, userId, message, context).block();
    }

    public Mono<Response<Void>> addUserToGroupWithResponseAsync(String hub, String group, String userId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.addUserToGroup(this.client.getHost(), hub, group, userId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> addUserToGroupWithResponseAsync(String hub, String group, String userId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.addUserToGroup(this.client.getHost(), hub, group, userId, this.client.getApiVersion(), context);
    }

    public Mono<Void> addUserToGroupAsync(String hub, String group, String userId) {
        return this.addUserToGroupWithResponseAsync(hub, group, userId).flatMap(res -> Mono.empty());
    }

    public Mono<Void> addUserToGroupAsync(String hub, String group, String userId, Context context) {
        return this.addUserToGroupWithResponseAsync(hub, group, userId, context).flatMap(res -> Mono.empty());
    }

    public void addUserToGroup(String hub, String group, String userId) {
        this.addUserToGroupAsync(hub, group, userId).block();
    }

    public Response<Void> addUserToGroupWithResponse(String hub, String group, String userId, Context context) {
        return (Response)this.addUserToGroupWithResponseAsync(hub, group, userId, context).block();
    }

    public Mono<Response<Void>> removeUserFromGroupWithResponseAsync(String hub, String group, String userId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeUserFromGroup(this.client.getHost(), hub, group, userId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> removeUserFromGroupWithResponseAsync(String hub, String group, String userId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (group == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter group is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.removeUserFromGroup(this.client.getHost(), hub, group, userId, this.client.getApiVersion(), context);
    }

    public Mono<Void> removeUserFromGroupAsync(String hub, String group, String userId) {
        return this.removeUserFromGroupWithResponseAsync(hub, group, userId).flatMap(res -> Mono.empty());
    }

    public Mono<Void> removeUserFromGroupAsync(String hub, String group, String userId, Context context) {
        return this.removeUserFromGroupWithResponseAsync(hub, group, userId, context).flatMap(res -> Mono.empty());
    }

    public void removeUserFromGroup(String hub, String group, String userId) {
        this.removeUserFromGroupAsync(hub, group, userId).block();
    }

    public Response<Void> removeUserFromGroupWithResponse(String hub, String group, String userId, Context context) {
        return (Response)this.removeUserFromGroupWithResponseAsync(hub, group, userId, context).block();
    }

    public Mono<Response<Void>> removeUserFromAllGroupsWithResponseAsync(String hub, String userId) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.removeUserFromAllGroups(this.client.getHost(), hub, userId, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> removeUserFromAllGroupsWithResponseAsync(String hub, String userId, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.removeUserFromAllGroups(this.client.getHost(), hub, userId, this.client.getApiVersion(), context);
    }

    public Mono<Void> removeUserFromAllGroupsAsync(String hub, String userId) {
        return this.removeUserFromAllGroupsWithResponseAsync(hub, userId).flatMap(res -> Mono.empty());
    }

    public Mono<Void> removeUserFromAllGroupsAsync(String hub, String userId, Context context) {
        return this.removeUserFromAllGroupsWithResponseAsync(hub, userId, context).flatMap(res -> Mono.empty());
    }

    public void removeUserFromAllGroups(String hub, String userId) {
        this.removeUserFromAllGroupsAsync(hub, userId).block();
    }

    public Response<Void> removeUserFromAllGroupsWithResponse(String hub, String userId, Context context) {
        return (Response)this.removeUserFromAllGroupsWithResponseAsync(hub, userId, context).block();
    }

    public Mono<Response<Void>> grantPermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.grantPermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> grantPermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.grantPermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), context);
    }

    public Mono<Void> grantPermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        return this.grantPermissionWithResponseAsync(hub, permission, connectionId, targetName).flatMap(res -> Mono.empty());
    }

    public Mono<Void> grantPermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.grantPermissionWithResponseAsync(hub, permission, connectionId, targetName, context).flatMap(res -> Mono.empty());
    }

    public void grantPermission(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        this.grantPermissionAsync(hub, permission, connectionId, targetName).block();
    }

    public Response<Void> grantPermissionWithResponse(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.grantPermissionWithResponseAsync(hub, permission, connectionId, targetName, context).block();
    }

    public Mono<Response<Void>> revokePermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.revokePermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Void>> revokePermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.revokePermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), context);
    }

    public Mono<Void> revokePermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        return this.revokePermissionWithResponseAsync(hub, permission, connectionId, targetName).flatMap(res -> Mono.empty());
    }

    public Mono<Void> revokePermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.revokePermissionWithResponseAsync(hub, permission, connectionId, targetName, context).flatMap(res -> Mono.empty());
    }

    public void revokePermission(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        this.revokePermissionAsync(hub, permission, connectionId, targetName).block();
    }

    public Response<Void> revokePermissionWithResponse(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.revokePermissionWithResponseAsync(hub, permission, connectionId, targetName, context).block();
    }

    public Mono<Response<Boolean>> checkPermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.checkPermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), (Context)context));
    }

    public Mono<Response<Boolean>> checkPermissionWithResponseAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        if (this.client.getHost() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getHost() is required and cannot be null."));
        }
        if (hub == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hub is required and cannot be null."));
        }
        if (permission == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter permission is required and cannot be null."));
        }
        if (connectionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionId is required and cannot be null."));
        }
        return this.service.checkPermission(this.client.getHost(), hub, permission, connectionId, targetName, this.client.getApiVersion(), context);
    }

    public Mono<Boolean> checkPermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        return this.checkPermissionWithResponseAsync(hub, permission, connectionId, targetName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> checkPermissionAsync(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return this.checkPermissionWithResponseAsync(hub, permission, connectionId, targetName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Boolean)res.getValue()));
            }
            return Mono.empty();
        });
    }

    public boolean checkPermission(String hub, WebPubSubPermission permission, String connectionId, String targetName) {
        Boolean value = (Boolean)this.checkPermissionAsync(hub, permission, connectionId, targetName).block();
        if (value != null) {
            return value;
        }
        throw new NullPointerException();
    }

    public Response<Boolean> checkPermissionWithResponse(String hub, WebPubSubPermission permission, String connectionId, String targetName, Context context) {
        return (Response)this.checkPermissionWithResponseAsync(hub, permission, connectionId, targetName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AzureWebPubSubServic")
    public static interface WebPubSubsService {
        @Post(value="/api/hubs/{hub}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToAll(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @QueryParam(value="excluded") Iterable<String> var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") WebPubSubContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") long var7, Context var9);

        @Post(value="/api/hubs/{hub}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToAll(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @QueryParam(value="excluded") Iterable<String> var3, @QueryParam(value="api-version") String var4, @BodyParam(value="text/plain") String var5, Context var6);

        @Head(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Boolean>> connectionExists(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Delete(value="/api/hubs/{hub}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> closeClientConnection(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="reason") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Post(value="/api/hubs/{hub}/connections/{connectionId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToConnection(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") WebPubSubContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") long var7, Context var9);

        @Post(value="/api/hubs/{hub}/connections/{connectionId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToConnection(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="connectionId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="text/plain") String var5, Context var6);

        @Head(value="/api/hubs/{hub}/groups/{group}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Boolean>> groupExists(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Post(value="/api/hubs/{hub}/groups/{group}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="excluded") Iterable<String> var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Content-Type") WebPubSubContentType var6, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var7, @HeaderParam(value="Content-Length") long var8, Context var10);

        @Post(value="/api/hubs/{hub}/groups/{group}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @QueryParam(value="excluded") Iterable<String> var4, @QueryParam(value="api-version") String var5, @BodyParam(value="text/plain") String var6, Context var7);

        @Put(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> addConnectionToGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Delete(value="/api/hubs/{hub}/groups/{group}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> removeConnectionFromGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="connectionId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Head(value="/api/hubs/{hub}/users/{userId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Boolean>> userExists(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Post(value="/api/hubs/{hub}/users/{userId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToUser(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Content-Type") WebPubSubContentType var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") long var7, Context var9);

        @Post(value="/api/hubs/{hub}/users/{userId}/:send")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> sendToUser(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="text/plain") String var5, Context var6);

        @Put(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> addUserToGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups/{group}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> removeUserFromGroup(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="group") String var3, @PathParam(value="userId") String var4, @QueryParam(value="api-version") String var5, Context var6);

        @Delete(value="/api/hubs/{hub}/users/{userId}/groups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> removeUserFromAllGroups(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="userId") String var3, @QueryParam(value="api-version") String var4, Context var5);

        @Put(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> grantPermission(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") WebPubSubPermission var3, @PathParam(value="connectionId") String var4, @QueryParam(value="targetName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Delete(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> revokePermission(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") WebPubSubPermission var3, @PathParam(value="connectionId") String var4, @QueryParam(value="targetName") String var5, @QueryParam(value="api-version") String var6, Context var7);

        @Head(value="/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}")
        @ExpectedResponses(value={200, 404})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Boolean>> checkPermission(@HostParam(value="$host") String var1, @PathParam(value="hub") String var2, @PathParam(value="permission") WebPubSubPermission var3, @PathParam(value="connectionId") String var4, @QueryParam(value="targetName") String var5, @QueryParam(value="api-version") String var6, Context var7);
    }
}

