/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.webpubsub;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.webpubsub.ReverseProxyPolicy;
import com.azure.messaging.webpubsub.WebPubSubAuthenticationPolicy;
import com.azure.messaging.webpubsub.WebPubSubServiceAsyncClient;
import com.azure.messaging.webpubsub.WebPubSubServiceClient;
import com.azure.messaging.webpubsub.WebPubSubServiceVersion;
import com.azure.messaging.webpubsub.implementation.AzureWebPubSubServiceRestApiImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={WebPubSubServiceAsyncClient.class, WebPubSubServiceClient.class})
public final class WebPubSubServiceClientBuilder {
    private static final String WPS_DEFAULT_SCOPE = "https://webpubsub.azure.com/.default";
    private final ClientLogger logger = new ClientLogger(WebPubSubServiceClientBuilder.class);
    private static final String WEBPUBSUB_PROPERTIES = "azure-messaging-webpubsub.properties";
    private static final String SDK_NAME = "name";
    private static final String SDK_VERSION = "version";
    private static final HttpPipelinePolicy DEFAULT_RETRY_POLICY = new RetryPolicy();
    private final Map<String, String> properties;
    private final List<HttpPipelinePolicy> policies;
    private String connectionString;
    private String endpoint;
    private AzureKeyCredential credential;
    private TokenCredential tokenCredential;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private HttpPipeline pipeline;
    private RetryPolicy retryPolicy;
    private Configuration configuration;
    private WebPubSubServiceVersion version = WebPubSubServiceVersion.getLatest();
    private String hub;
    private ClientOptions clientOptions;
    private String reverseProxyEndpoint;

    public WebPubSubServiceClientBuilder() {
        this.policies = new ArrayList<HttpPipelinePolicy>();
        this.httpLogOptions = new HttpLogOptions();
        this.properties = CoreUtils.getProperties((String)WEBPUBSUB_PROPERTIES);
    }

    public WebPubSubServiceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public WebPubSubServiceClientBuilder connectionString(String connectionString) {
        Objects.requireNonNull(connectionString, "'connectionString' cannot be null.");
        this.connectionString = connectionString;
        return this;
    }

    public WebPubSubServiceClientBuilder endpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "'endpoint' cannot be null.");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException e) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be valid URL", e));
        }
        this.endpoint = endpoint;
        return this;
    }

    public WebPubSubServiceClientBuilder credential(AzureKeyCredential credential) {
        this.credential = credential;
        return this;
    }

    public WebPubSubServiceClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = credential;
        return this;
    }

    public WebPubSubServiceClientBuilder reverseProxyEndpoint(String reverseProxyEndpoint) {
        this.reverseProxyEndpoint = reverseProxyEndpoint;
        return this;
    }

    public WebPubSubServiceClientBuilder hub(String hub) {
        Objects.requireNonNull(hub, "'hub' cannot be null.");
        this.hub = hub;
        return this;
    }

    public WebPubSubServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public WebPubSubServiceClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy);
        this.policies.add(policy);
        return this;
    }

    public WebPubSubServiceClientBuilder httpClient(HttpClient client) {
        if (this.httpClient != null && client == null) {
            this.logger.info("HttpClient is being set to 'null' when it was previously configured.");
        }
        this.httpClient = client;
        return this;
    }

    public WebPubSubServiceClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.pipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.pipeline = pipeline;
        return this;
    }

    public WebPubSubServiceClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public WebPubSubServiceClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public WebPubSubServiceClientBuilder serviceVersion(WebPubSubServiceVersion version) {
        this.version = version;
        return this;
    }

    private AzureWebPubSubServiceRestApiImpl buildInnerClient() {
        WebPubSubServiceVersion serviceVersion;
        if (this.hub == null || this.hub.isEmpty()) {
            this.logger.logThrowableAsError((Throwable)new IllegalStateException("hub is not valid - it must be non-null and non-empty."));
        }
        if (this.connectionString != null) {
            URL url;
            Map<String, String> csParams = this.parseConnectionString(this.connectionString);
            if (!csParams.containsKey("endpoint") && !csParams.containsKey("accesskey")) {
                this.logger.logThrowableAsError((Throwable)new IllegalArgumentException("Connection string does not contain required 'endpoint' and 'accesskey' values"));
            }
            String accessKey = csParams.get("accesskey");
            this.credential = new AzureKeyCredential(accessKey);
            String csEndpoint = csParams.get("endpoint");
            try {
                url = new URL(csEndpoint);
                this.endpoint = csEndpoint;
            }
            catch (MalformedURLException e) {
                throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("Connection string contains invalid endpoint", e));
            }
            String port = csParams.get("port");
            if (!CoreUtils.isNullOrEmpty((CharSequence)port)) {
                this.endpoint = UrlBuilder.parse((URL)url).setPort(port).toString();
            }
        }
        if (this.endpoint == null || this.endpoint.isEmpty()) {
            this.logger.logThrowableAsError((Throwable)new IllegalStateException("endpoint is not valid - it must be non-null and non-empty."));
        }
        WebPubSubServiceVersion webPubSubServiceVersion = serviceVersion = this.version != null ? this.version : WebPubSubServiceVersion.getLatest();
        if (this.pipeline != null) {
            return new AzureWebPubSubServiceRestApiImpl(this.pipeline, this.endpoint, serviceVersion);
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration().clone() : this.configuration;
        String clientName = this.properties.getOrDefault(SDK_NAME, "UnknownName");
        String clientVersion = this.properties.getOrDefault(SDK_VERSION, "UnknownVersion");
        String applicationId = this.clientOptions == null ? this.httpLogOptions.getApplicationId() : this.clientOptions.getApplicationId();
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(applicationId, clientName, clientVersion, buildConfiguration));
        policies.add(new CookiePolicy());
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
        if (this.credential != null) {
            WebPubSubAuthenticationPolicy webPubSubAuthPolicy = new WebPubSubAuthenticationPolicy(this.credential);
            policies.add(webPubSubAuthPolicy);
        } else if (this.tokenCredential != null) {
            BearerTokenAuthenticationPolicy tokenPolicy = new BearerTokenAuthenticationPolicy(this.tokenCredential, new String[]{WPS_DEFAULT_SCOPE});
            policies.add(tokenPolicy);
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("No credential available to create the client. Please provide connection string or AzureKeyCredential or TokenCredential."));
        }
        if (!CoreUtils.isNullOrEmpty((CharSequence)this.reverseProxyEndpoint)) {
            policies.add(new ReverseProxyPolicy(this.reverseProxyEndpoint));
        }
        policies.addAll(this.policies);
        if (this.clientOptions != null) {
            ArrayList httpHeaderList = new ArrayList();
            this.clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
            policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList)));
        }
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(new HttpLoggingPolicy(this.httpLogOptions));
        HttpPipeline buildPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        return new AzureWebPubSubServiceRestApiImpl(buildPipeline, this.endpoint, serviceVersion);
    }

    public WebPubSubServiceAsyncClient buildAsyncClient() {
        return new WebPubSubServiceAsyncClient(this.buildInnerClient().getWebPubSubs(), this.hub, this.endpoint, this.credential, this.version);
    }

    public WebPubSubServiceClient buildClient() {
        return new WebPubSubServiceClient(this.buildInnerClient().getWebPubSubs(), this.hub, this.endpoint, this.credential, this.version);
    }

    private Map<String, String> parseConnectionString(String cs) {
        String[] params = cs.split(";");
        HashMap<String, String> connectionStringParams = new HashMap<String, String>();
        for (String param : params) {
            String[] paramSplit = param.split("=", 2);
            if (paramSplit.length != 2) continue;
            String key = paramSplit[0].trim().toLowerCase(Locale.ROOT);
            if (connectionStringParams.containsKey(key)) {
                this.logger.logThrowableAsError((Throwable)new IllegalArgumentException("Duplicate connection string key parameter provided for key '" + key + "'"));
            }
            String value = paramSplit[1].trim();
            connectionStringParams.put(key, value);
        }
        return connectionStringParams;
    }
}

